﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "account_BaasProblemDetails.h"

#include "../http/account_HttpUtil.h"
#include <nn/account/baas/account_ResultForBaas.h>
#include <nn/account/account_ResultPrivate.h>

#include <utility>

#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace account { namespace baas {
namespace
{
struct ErrorDefinition
{
    BaasProblemDetails details;
    Result result;
};

#define NN_ACCOUNT_ERRDEF(status, errorCode, result) \
    {{static_cast<uint16_t>(status), errorCode}, result}

const ErrorDefinition Errors400[] =
{
    NN_ACCOUNT_ERRDEF(400, "invalid_params",                ResultBaasStatus400InvalidParams()),
    NN_ACCOUNT_ERRDEF(400, "invalid_request",               ResultBaasStatus400InvalidRequest()),
    NN_ACCOUNT_ERRDEF(400, "invalid_device_account",        ResultBaasStatus400InvalidDeviceAccount()),
    NN_ACCOUNT_ERRDEF(400, "invalid_ndas_app_authn_token",  ResultBaasStatus400InvalidNdasAppAuthnToken()),
    NN_ACCOUNT_ERRDEF(400, "invalid_idp",                   ResultBaasStatus400InvalidIdp()),
    NN_ACCOUNT_ERRDEF(400, "invalid_idp_account",           ResultBaasStatus400InvalidIdpAccount()),
    NN_ACCOUNT_ERRDEF(400, "linked_user_not_found",         ResultBaasStatus400LinkedUserNotFound()),
    NN_ACCOUNT_ERRDEF(400, "invalid_friend_code_format",    ResultBaasStatus400InvalidFriendCodeFormat()),
    NN_ACCOUNT_ERRDEF(400, "user_link_not_exist",           ResultBaasStatus400UserLinkNotExist()),
    NN_ACCOUNT_ERRDEF(400, "invalid_raw_content",           ResultBaasStatus400InvalidRawContent()),
};
const ErrorDefinition Errors4xx[] =
{
    NN_ACCOUNT_ERRDEF(401, "invalid_token",                 ResultBaasStatus401InvalidToken()),
    NN_ACCOUNT_ERRDEF(403, "insufficient_scope",            ResultBaasStatus403InsufficientScope()),
    NN_ACCOUNT_ERRDEF(403, "forbidden",                     ResultBaasStatus403Forbidden()),
    NN_ACCOUNT_ERRDEF(403, "membership_required",           ResultBaasStatus403MembershipRequired()),
    NN_ACCOUNT_ERRDEF(403, "unavailable_device_account",    ResultBaasStatus403UnavailableDeviceAccount()),
    NN_ACCOUNT_ERRDEF(404, "resource_is_not_found",         ResultBaasStatus404ResourceIsNotFound()),
    NN_ACCOUNT_ERRDEF(405, "method_not_allowed",            ResultBaasStatus405MethodNotAllowed()),
    NN_ACCOUNT_ERRDEF(406, "not_acceptable_language",       ResultBaasStatus406NotAcceptableLanguage()),
    NN_ACCOUNT_ERRDEF(409, "resource_already_exists",       ResultBaasStatus409ResourceAlreadyExists()),
    NN_ACCOUNT_ERRDEF(409, "user_link_already_exists",      ResultBaasStatus409UserLinkAlreadyExists()),
    NN_ACCOUNT_ERRDEF(412, "precondition_failed",           ResultBaasStatus412PreconditionFailed()),
    NN_ACCOUNT_ERRDEF(422, "friend_code_unregenerable_state", ResultBaasStatus422FriendCodeUnregenerableState()),
    NN_ACCOUNT_ERRDEF(403, "banned_user",                   ResultBaasStatus403BannedUser()),
    NN_ACCOUNT_ERRDEF(404, "deleted_user",                  ResultBaasStatus404DeletedUser()),
    NN_ACCOUNT_ERRDEF(403, "banned_user_by_application",    ResultBaasStatus403BannedUserByApplication()),
};
const ErrorDefinition Errors5xx[] =
{
    NN_ACCOUNT_ERRDEF(500, "internal_server_error",         ResultBaasStatus500InternalServerError()),
    NN_ACCOUNT_ERRDEF(502, "could_not_confirm_membership",  ResultBaasStatus502CouldNotConfirmMembership()),
    NN_ACCOUNT_ERRDEF(503, "under_maintenance",             ResultBaasStatus503UnderMaintenance()),
};

#undef NN_ACCOUNT_ERRDEF

template <typename ListType>
std::pair<bool, Result> FindResult(const ListType& list, const BaasProblemDetails& problemDetails) NN_NOEXCEPT
{
    for (const auto& e: list)
    {
        if (e.details == problemDetails)
        {
            return std::pair<bool, Result>(true, e.result);
        }
    }
    return std::pair<bool, Result>(false, ResultNotImplemented());
}

} // ~namespace nn::account::baas::<anonymous>

std::pair<bool, Result> FindResult(int32_t httpCode, const BaasProblemDetails& problemDetails) NN_NOEXCEPT
{
    switch (httpCode / 100)
    {
    case 4:
        return (httpCode == 400)
            ? FindResult(Errors400, problemDetails)
            : FindResult(Errors4xx, problemDetails);
    case 5:
        return FindResult(Errors5xx, problemDetails);
    default:
        return std::pair<bool, Result>(false, ResultNotImplemented());
    }
}

}}} // ~namespace nn::account::baas
