﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_OAuthProcedure.h>

#include <nn/account/account_Types.h>
#include <nn/account/account_ResultPrivate.h>
#include <nn/account/http/account_Interface.sfdl.h>
#include <nn/account/nas/account_Interface.sfdl.h>

#include <cstring>
#include <utility>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn {
namespace account {

/* --------------------------------------------------------------------------------------------
    NintendoAccountLinkageProcedure
 */
NintendoAccountLinkageProcedure::NintendoAccountLinkageProcedure() NN_NOEXCEPT
{
}
NintendoAccountLinkageProcedure::NintendoAccountLinkageProcedure(const Uid& user, nas::IOAuthProcedureForNintendoAccountLinkage* ptr) NN_NOEXCEPT
    : OAuthProcedureBase(user, reinterpret_cast<http::IOAuthProcedure*>(ptr))
{
}
NintendoAccountLinkageProcedure::NintendoAccountLinkageProcedure(NintendoAccountLinkageProcedure&& rhs) NN_NOEXCEPT
    : OAuthProcedureBase(std::move(rhs))
{
}
NintendoAccountLinkageProcedure& NintendoAccountLinkageProcedure::operator=(NintendoAccountLinkageProcedure&& rhs) NN_NOEXCEPT
{
    NintendoAccountLinkageProcedure tmp(std::move(rhs));
    this->Swap(tmp);
    return *this;
}
NintendoAccountLinkageProcedure& NintendoAccountLinkageProcedure::Swap(NintendoAccountLinkageProcedure& rhs) NN_NOEXCEPT
{
    OAuthProcedureBase::Swap(rhs);
    return *this;
}
Result NintendoAccountLinkageProcedure::GetRequest(RequestUrl* pOutRequestUrl, CallbackUri* pOutCallbackUri, NintendoAccountAuthorizationPageTheme theme) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutRequestUrl);
    NN_SDK_REQUIRES_NOT_NULL(pOutCallbackUri);
    NN_ABORT_UNLESS_NOT_NULL(GetPtr());

    return GetPtr()->GetRequestWithTheme(pOutRequestUrl, pOutCallbackUri, theme);
}
Result NintendoAccountLinkageProcedure::IsNetworkServiceAccountReplaced(bool* pOut) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);
    NN_ABORT_UNLESS_NOT_NULL(GetPtr());

    return GetPtr()->IsNetworkServiceAccountReplaced(pOut);
}
/* --------------------------------------------------------------------------------------------
    NintendoAccountApplicationAuthorizationProcedure
*/
NintendoAccountApplicationAuthorizationProcedure::NintendoAccountApplicationAuthorizationProcedure() NN_NOEXCEPT
{
}
NintendoAccountApplicationAuthorizationProcedure::NintendoAccountApplicationAuthorizationProcedure(const Uid& user, http::IOAuthProcedure* ptr) NN_NOEXCEPT
    : OAuthProcedureBase(user, reinterpret_cast<http::IOAuthProcedure*>(ptr))
{
}
NintendoAccountApplicationAuthorizationProcedure::NintendoAccountApplicationAuthorizationProcedure(NintendoAccountApplicationAuthorizationProcedure&& rhs) NN_NOEXCEPT
    : OAuthProcedureBase(std::move(rhs))
{
}
NintendoAccountApplicationAuthorizationProcedure& NintendoAccountApplicationAuthorizationProcedure::operator=(NintendoAccountApplicationAuthorizationProcedure&& rhs) NN_NOEXCEPT
{
    NintendoAccountApplicationAuthorizationProcedure tmp(std::move(rhs));
    this->Swap(tmp);
    return *this;
}
NintendoAccountApplicationAuthorizationProcedure& NintendoAccountApplicationAuthorizationProcedure::Swap(NintendoAccountApplicationAuthorizationProcedure& rhs) NN_NOEXCEPT
{
    OAuthProcedureBase::Swap(rhs);
    return *this;
}

/* --------------------------------------------------------------------------------------------
    ExternalNetworkServiceAccountIntroducingProcedure
*/
ExternalNetworkServiceAccountIntroducingProcedure::ExternalNetworkServiceAccountIntroducingProcedure() NN_NOEXCEPT
{
}
ExternalNetworkServiceAccountIntroducingProcedure::ExternalNetworkServiceAccountIntroducingProcedure(nas::IOAuthProcedureForExternalNsa* ptr) NN_NOEXCEPT
    : OAuthProcedureBase(InvalidUid, ptr)
{
}
ExternalNetworkServiceAccountIntroducingProcedure::ExternalNetworkServiceAccountIntroducingProcedure(ExternalNetworkServiceAccountIntroducingProcedure&& rhs) NN_NOEXCEPT
    : OAuthProcedureBase(std::move(rhs))
{
}
ExternalNetworkServiceAccountIntroducingProcedure& ExternalNetworkServiceAccountIntroducingProcedure::operator=(ExternalNetworkServiceAccountIntroducingProcedure&& rhs) NN_NOEXCEPT
{
    ExternalNetworkServiceAccountIntroducingProcedure tmp(std::move(rhs));
    this->Swap(tmp);
    return *this;
}
ExternalNetworkServiceAccountIntroducingProcedure& ExternalNetworkServiceAccountIntroducingProcedure::Swap(ExternalNetworkServiceAccountIntroducingProcedure& rhs) NN_NOEXCEPT
{
    OAuthProcedureBase::Swap(rhs);
    return *this;
}

Result ExternalNetworkServiceAccountIntroducingProcedure::GetNickname(Nickname* pOut) const NN_NOEXCEPT
{
    return GetPtr()->GetNickname(sf::OutArray<char>(pOut->name, sizeof(pOut->name)));
}
Result ExternalNetworkServiceAccountIntroducingProcedure::GetProfileImage(size_t* pOutSizeActual, void* buffer, size_t bufferSize) const NN_NOEXCEPT
{
    uint32_t size;
    NN_RESULT_DO(GetPtr()->GetProfileImage(&size, sf::OutBuffer(reinterpret_cast<char*>(buffer), bufferSize)));
    *pOutSizeActual = static_cast<size_t>(size);
    NN_RESULT_SUCCESS;
}
Result ExternalNetworkServiceAccountIntroducingProcedure::GetNetworkServiceAccountId(NetworkServiceAccountId* pOut) const NN_NOEXCEPT
{
    return GetPtr()->GetAccountId(pOut);
}
Result ExternalNetworkServiceAccountIntroducingProcedure::GetLinkedNintendoAccountId(NintendoAccountId* pOut) const NN_NOEXCEPT
{
    return GetPtr()->GetLinkedNintendoAccountId(pOut);
}

}
} // ~namespace nn::account
