﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_ApiBaasAccessToken.h>
#include <nn/account/account_ApiPrivate.h>

#include "detail/account_HipcProxyClientResource.h"
#include <nn/account/account_IAccountService.sfdl.h>
#include <nn/account/account_ServiceNames.h>

#include <nn/sf/sf_ShimLibraryUtility.h>

namespace nn {
namespace account {

namespace {
#if defined(NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON)
sf::SimpleAllInOneHipcSubDomainClientManager<17> g_Manager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_SUB_DOMAIN_CLIENT_MANAGER_INITIALIZER;
#endif
sf::ShimLibraryObjectHolder<IBaasAccessTokenAccessor> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
} // ~namespace nn::account::<anonymous>

/** -------------------------------------------------------------------------------------------
    初期化
 */
void InitializeBaasAccessTokenAccessor() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN)
    InitializeBaasAccessTokenAccessorWith(detail::GetServiceResourceRef().GetBaasAccessTokenAccessorPointer());
#elif defined(NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON)
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_Manager.InitializeShimLibraryHolder(&g_Holder, ServiceNameForBaasAccessTokenAccessor));
#else
#   error("Unsuppored os type specified")
#endif
}
void InitializeBaasAccessTokenAccessorWith(
    sf::SharedPointer<IBaasAccessTokenAccessor>&& p) NN_NOEXCEPT
{
    sf::SharedPointer<IBaasAccessTokenAccessor> tmp(std::move(p));
    g_Holder.InitializeHolderDirectly(tmp);
}
void FinalizeBaasAccessTokenAccessor() NN_NOEXCEPT
{
    g_Holder.FinalizeHolder();
}

/** -------------------------------------------------------------------------------------------
    API実装
 */
Result EnsureBaasAccessTokenCacheAsync(AsyncContext* pOutContext, const Uid& user) NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> asyncContextPtr;
    NN_RESULT_DO(g_Holder.GetObject()->EnsureCacheAsync(&asyncContextPtr, user));
    *pOutContext = AsyncContext(asyncContextPtr.Detach(), user);
    NN_RESULT_SUCCESS;
}
Result LoadBaasAccessTokenCache(size_t* pOutActualSize, char* buffer, size_t bufferSize, const Uid& user) NN_NOEXCEPT
{
    uint32_t sizeActual;
    NN_RESULT_DO(g_Holder.GetObject()->LoadCache(&sizeActual, sf::OutBuffer(buffer, bufferSize), user));
    *pOutActualSize = sizeActual;
    NN_RESULT_SUCCESS;
}
Result GetBaasDeviceAccountId(uint64_t* pOut, const Uid& user) NN_NOEXCEPT
{
    return g_Holder.GetObject()->GetDeviceAccountId(pOut, user);
}
Result PutBaasChannelResourceAsync(AsyncContext* pOutContext, const Uid& user, const npns::NotificationToken& nt) NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> asyncContextPtr;
    NN_RESULT_DO(g_Holder.GetObject()->RegisterNotificationTokenAsync(&asyncContextPtr, user, nt));
    *pOutContext = AsyncContext(asyncContextPtr.Detach(), user);
    NN_RESULT_SUCCESS;
}
Result DeleteBaasChannelResourceAsync(AsyncContext* pOutContext, const Uid& user) NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> asyncContextPtr;
    NN_RESULT_DO(g_Holder.GetObject()->UnregisterNotificationTokenAsync(&asyncContextPtr, user));
    *pOutContext = AsyncContext(asyncContextPtr.Detach(), user);
    NN_RESULT_SUCCESS;
}

}
} // ~namespace nn::account
