﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/os/os_InterruptEvent.h>
#include <nn/gpio/gpio.h>
#include <nn/i2c/i2c.h>
#include <nn/i2c/i2c_BusDev.h>

#include <nnd/tmp451/tmp451.h>

namespace nnd {
namespace tmp451 {

nn::Result Initialize() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result Finalize() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result GetMeasurementRange(MeasurementRange* pOutRange) NN_NOEXCEPT
{
    NN_UNUSED(pOutRange);

    NN_RESULT_SUCCESS;
}

nn::Result SetMeasurementRange(MeasurementRange range) NN_NOEXCEPT
{
    NN_UNUSED(range);

    NN_RESULT_SUCCESS;
}

nn::Result GetMeasurementRateBy2ToThePowerN(int* pOutN) NN_NOEXCEPT
{
    NN_UNUSED(pOutN);

    NN_RESULT_SUCCESS;
}

nn::Result SetMeasurementRateBy2ToThePowerN(int n) NN_NOEXCEPT
{
    NN_UNUSED(n);

    NN_RESULT_SUCCESS;
}

nn::Result GetBusTimeoutFunctionEnabled(bool* pOutEnable) NN_NOEXCEPT
{
    NN_UNUSED(pOutEnable);

    NN_RESULT_SUCCESS;
}

nn::Result SetBusTimeoutFunctionEnabled(bool enable) NN_NOEXCEPT
{
    NN_UNUSED(enable);

    NN_RESULT_SUCCESS;
}

nn::Result GetRemoteDigitalFilterControl(DigitalFilter* pOutFilter) NN_NOEXCEPT
{
    NN_UNUSED(pOutFilter);

    NN_RESULT_SUCCESS;
}

nn::Result SetRemoteDigitalFilterControl(DigitalFilter filter) NN_NOEXCEPT
{
    NN_UNUSED(filter);

    NN_RESULT_SUCCESS;
}

nn::Result GetRemoteTemperatureOffset(Temperature* pOutOffset) NN_NOEXCEPT
{
    NN_UNUSED(pOutOffset);

    NN_RESULT_SUCCESS;
}

nn::Result SetRemoteTemperatureOffset(Temperature offset) NN_NOEXCEPT
{
    NN_UNUSED(offset);

    NN_RESULT_SUCCESS;
}

nn::Result GetRemoteEtaFactorCorrectionValueByN(int8_t* pOutN) NN_NOEXCEPT
{
    NN_UNUSED(pOutN);

    NN_RESULT_SUCCESS;
}

nn::Result SetRemoteEtaFactorCorrectionValueByN(int8_t n) NN_NOEXCEPT
{
    NN_UNUSED(n);

    NN_RESULT_SUCCESS;
}

nn::Result GetPin1DetectionSettings(Temperature* pOutRemoteLimit, Temperature* pOutLocalLimit) NN_NOEXCEPT
{
    NN_UNUSED(pOutRemoteLimit);
    NN_UNUSED(pOutLocalLimit);

    NN_RESULT_SUCCESS;
}

nn::Result SetPin1DetectionSettings(Temperature remoteLimit, Temperature localLimit) NN_NOEXCEPT
{
    NN_UNUSED(remoteLimit);
    NN_UNUSED(localLimit);

    NN_RESULT_SUCCESS;
}

nn::Result GetPin2DetectionSettings(Temperature* pOutRemoteLowLimit, Temperature* pOutRemoteHighLimit,
                                    Temperature* pOutLocalLowLimit, Temperature* pOutLocalHighLimit,
                                    DetectionMode* pOutDetection) NN_NOEXCEPT
{
    NN_UNUSED(pOutRemoteLowLimit);
    NN_UNUSED(pOutRemoteHighLimit);
    NN_UNUSED(pOutLocalLowLimit);
    NN_UNUSED(pOutLocalHighLimit);
    NN_UNUSED(pOutDetection);

    NN_RESULT_SUCCESS;
}

nn::Result SetPin2DetectionSettings(Temperature remoteLowLimit, Temperature remoteHighLimit,
                                    Temperature locaLowlLimit, Temperature localHighLimit,
                                    DetectionMode mode) NN_NOEXCEPT
{
    NN_UNUSED(remoteLowLimit);
    NN_UNUSED(remoteHighLimit);
    NN_UNUSED(locaLowlLimit);
    NN_UNUSED(localHighLimit);
    NN_UNUSED(mode);

    NN_RESULT_SUCCESS;
}

nn::Result BindInterrupt(nn::os::SystemEventType* pEvent, SignalPin pin) NN_NOEXCEPT
{
    NN_UNUSED(pEvent);
    NN_UNUSED(pin);

    NN_RESULT_SUCCESS;
}

nn::Result UnbindInterrupt(SignalPin pin) NN_NOEXCEPT
{
    NN_UNUSED(pin);

    NN_RESULT_SUCCESS;
}

nn::Result SetInterruptEnable(bool enable, SignalPin pin) NN_NOEXCEPT
{
    NN_UNUSED(enable);
    NN_UNUSED(pin);

    NN_RESULT_SUCCESS;
}

nn::Result GetThermHysterisis(uint8_t* pOutHysterisis) NN_NOEXCEPT
{
    NN_UNUSED(pOutHysterisis);

    NN_RESULT_SUCCESS;
}

nn::Result SetThermHysterisis(uint8_t hysterisis) NN_NOEXCEPT
{
    NN_UNUSED(hysterisis);

    NN_RESULT_SUCCESS;
}

nn::Result GetConsecutiveAlert(AlertConsecutive* pOutConsecutive) NN_NOEXCEPT
{
    NN_UNUSED(pOutConsecutive);

    NN_RESULT_SUCCESS;
}

nn::Result SetConsecutiveAlert(AlertConsecutive consecutive) NN_NOEXCEPT
{
    NN_UNUSED(consecutive);

    NN_RESULT_SUCCESS;
}

MeasurementMode GetMeasurementMode() NN_NOEXCEPT
{
    return MeasurementMode::Standby;
}

nn::Result SetMeasurementMode(MeasurementMode mode) NN_NOEXCEPT
{
    NN_UNUSED(mode);

    NN_RESULT_SUCCESS;
}

nn::Result ReadTemperature(Temperature* pOutTemperatute, Location location) NN_NOEXCEPT
{
    NN_UNUSED(pOutTemperatute);
    NN_UNUSED(location);

    NN_RESULT_SUCCESS;
}

nn::Result ReadStatus(Status* pOutStatus) NN_NOEXCEPT
{
    NN_UNUSED(pOutStatus);

    NN_RESULT_SUCCESS;
}

nn::Result ReadManufacturerId(uint8_t* pOutId) NN_NOEXCEPT
{
    NN_UNUSED(pOutId);

    NN_RESULT_SUCCESS;
}


} // tmp451
} // nnd
