﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * 温度計測の有効化と読み取り専用情報の取得に関する関数群
 */

#include <nn/os.h>
#include <nn/nn_Common.h>

#include <nn/i2c/i2c.h>
#include <nn/gpio/gpio.h>

#include <nnd/tmp451/tmp451.h>

#include "tmp451_InternalFunction.h"

namespace nnd {
namespace tmp451 {
namespace detail {

MeasurementMode GetMeasurementMode(BusSessions bus) NN_NOEXCEPT;
nn::Result SetMeasurementMode(MeasurementMode mode, BusSessions bus) NN_NOEXCEPT;
nn::Result ReadTemperature(Temperature* pOutTemp, Location location, BusSessions bus) NN_NOEXCEPT;
nn::Result ReadStatus(Status* pOutStatus, BusSessions bus, bool readFromExternal) NN_NOEXCEPT;
nn::Result ReadManufacturerId(uint8_t* pOutId, BusSessions bus) NN_NOEXCEPT;
nn::Result HasDevice(BusSessions bus) NN_NOEXCEPT;

} // detail
} // tmp451
} // nnd
