﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * ドライバ内部で共通して使用するヘッダ
 */

#include <nn/nn_Common.h>
#include <nn/TargetConfigs/build_Base.h>

#include <nn/i2c/i2c.h>
#include <nn/gpio/gpio.h>

#include "tmp451_Specification.h"

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
    #include "tmp451_InternalFunction-hardware.nx.h"
#else
    #error NN_BUILD_CONFIG_HARDWARE_ not selected or supported
#endif

namespace nnd {
namespace tmp451 {
namespace detail {

// コンフィグレジスタに対応するデータ群
struct ConfigReg
{
    DetectionMode       pin2Mode;
    bool                isShutdown;
    MeasurementRange    range;
};

// 温度値のバイトデータ群
struct TemperatureByteData
{
    uint8_t       integerByte;
    uint8_t       decimalByte;
};


// cmd に指定するレジスタを読む
nn::Result ReadRegister(uint8_t* config, BusSessions bus, RegRead cmd) NN_NOEXCEPT;

// コンフィグレジスタの値を読む
nn::Result ReadConfig(ConfigReg* config, BusSessions bus) NN_NOEXCEPT;

// レンジに応じて、温度値をバイトデータに変換
TemperatureByteData ConvertTemperature2ByteData(Temperature temperature, MeasurementRange range) NN_NOEXCEPT;

// レンジに応じて、バイトデータから温度値に変換
Temperature ConvertByteData2Temperature(TemperatureByteData regData, MeasurementRange range) NN_NOEXCEPT;

// デバイスをリセットする
nn::Result ResetDevice(BusSessions bus) NN_NOEXCEPT;

} // detail
} // tmp451
} // nnd

