﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

#include <nnd/tmp451/tmp451.h>

#include "tmp451_BusConfig.h"
#include "tmp451_Debug.h"
#include "tmp451_InternalFunction.h"
#include "tmp451_Specification.h"

namespace{
const nn::i2c::I2cDevice    I2cDeviceName   = nn::i2c::I2cDevice_Tmp451;
}

namespace nnd {
namespace tmp451 {
namespace detail {

void Initialize(BusSessions* pOutSessions) NN_NOEXCEPT
{
    NN_TMP451_LOG_DETAIL("START\n");

    // I2C -------------------------
    nn::i2c::Initialize();

    nn::i2c::OpenSession(&pOutSessions->i2cSession, I2cDeviceName);
}

void Finalize(BusSessions* pOutSessions) NN_NOEXCEPT
{
    NN_TMP451_LOG_DETAIL("START\n");

    // I2C -------------------------
    nn::i2c::CloseSession(pOutSessions->i2cSession);
    nn::i2c::Finalize();
}

} // detail
} // tmp451
} // nnd
