﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ftm のコントローラに関する定義
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/i2c/i2c.h>
#include <nnd/ftm/ftm.h>
#include <nnd/ftm/ftm_Fab.h>

namespace nnd { namespace ftm { namespace detail {

class IController
{
protected:
    ::nn::i2c::I2cSession m_Session;
    int m_MaxTouchNumber;
    int m_MaxEventReportCount;
    size_t m_EventReportByteSize;

public:
    IController() NN_NOEXCEPT;
    virtual ~IController() NN_NOEXCEPT;
    virtual ::nn::Result ResetDevice() const NN_NOEXCEPT;
    virtual ::nn::Result SleepInDevice() const NN_NOEXCEPT;
    virtual ::nn::Result SleepOutDevice() const NN_NOEXCEPT;
    virtual ::nn::Result BindInterrupt() const NN_NOEXCEPT;
    virtual ::nn::Result ActivateSensing() const NN_NOEXCEPT;
    virtual ::nn::Result DeactivateSensing() const NN_NOEXCEPT;
    virtual ::nn::Result ReadLeftEventCount(uint32_t* pOutLeftCount) const NN_NOEXCEPT;
    virtual ::nn::Result ReadEventReports(char* pOutReadData, uint32_t* pOutReadCount, bool* pOutIsOverflow, uint32_t readCount) const NN_NOEXCEPT;
    virtual ::nn::Result ReadEventReports(char* pOutReadData, uint32_t* pOutReadCount, uint32_t* pOutLeftCount, bool* pOutIsOverflow, uint32_t readCount) const NN_NOEXCEPT;
    virtual void ParseEventReports(EventReport* pOutEventReport, const char* pRawData, uint32_t parseCount) const NN_NOEXCEPT;
    virtual ::nn::Result UpdateFirmware(FirmwareInputFunctionPointer const pFunction, void* const pParameter, size_t fileSize) NN_NOEXCEPT;
    virtual ::nn::Result EraseFirmware() const NN_NOEXCEPT;
    virtual ::nn::Result RunAutoTune() const NN_NOEXCEPT;
    virtual ::nn::Result RunItoTest(ItoEventReport* pOutItoEventReport) const NN_NOEXCEPT;
    virtual ::nn::Result ReadMutualCompensationData(MutualCompensationData* pOutCompensationData) const NN_NOEXCEPT;
    virtual ::nn::Result ReadSelfCompensationData(SelfCompensationData* pOutCompensationData) const NN_NOEXCEPT;
    virtual ::nn::Result ReadMutualRawData(MutualRawData* pOutRawData) const NN_NOEXCEPT;
    virtual ::nn::Result ReadSelfRawData(SelfRawData* pOutRawData) const NN_NOEXCEPT;
    virtual ::nn::Result RequestGpioState(GpioInformEventReport* pOutGpioInformEventReport) const NN_NOEXCEPT;
    virtual void SetI2cSession(::nn::i2c::I2cSession session) NN_NOEXCEPT;
    int          GetMaxTouchNumber() const NN_NOEXCEPT;
    int          GetMaxEventReportCount() const NN_NOEXCEPT;
    size_t       GetEventReportByteSize() const NN_NOEXCEPT;
    ::nn::Result ReadFirmwareVersion(FirmwareVersion* pOutFirmwareVersion) const NN_NOEXCEPT;

private:
    ::nn::Result ReadVersionAddressRegister(uint16_t* pOutAddress) const NN_NOEXCEPT;
    ::nn::Result ReadVersionRegister(FirmwareVersion* pOutFirmwareVersion, uint16_t address) const NN_NOEXCEPT;
};

void InitializeController(::nn::i2c::I2cSession session) NN_NOEXCEPT;
void FinalizeController() NN_NOEXCEPT;
IController* GetController() NN_NOEXCEPT;

}}} // namespace nnd::ftm::detail
