﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ftm 関連のペリフェラルに関する定義です。
 */

#pragma once

#include <nn/i2c/i2c.h>
#include <nn/gpio/gpio.h>

namespace nnd { namespace ftm { namespace detail {

void SetPowerEnabled(bool enabled) NN_NOEXCEPT;
void InitializeBus(::nn::i2c::I2cSession* pOutI2c, ::nn::gpio::GpioPadSession* pOutIrq, ::nn::gpio::GpioPadSession* pOutReset) NN_NOEXCEPT;
void FinalizeBus(::nn::i2c::I2cSession* pI2c, ::nn::gpio::GpioPadSession* pIrq, ::nn::gpio::GpioPadSession* pReset) NN_NOEXCEPT;
void SleepInBus(::nn::i2c::I2cSession* pOutI2c, ::nn::gpio::GpioPadSession* pOutIrq, ::nn::gpio::GpioPadSession* pOutReset) NN_NOEXCEPT;
void SleepOutBus(::nn::i2c::I2cSession* pI2c, ::nn::gpio::GpioPadSession* pIrq, ::nn::gpio::GpioPadSession* pReset) NN_NOEXCEPT;
void DeassertReset(::nn::gpio::GpioPadSession* pOutReset) NN_NOEXCEPT;

}}} // namespace nnd::ftm::detail
