﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/ssl/ssl_Types.h>

//  cppname 同等のサイズとアライメントを持つオブジェクトを cname で定義する
#define NN_SSL_DEFINE_ALIGNED_STORAGE(cname, cppname, size, alignment_type)  \
        typedef union cname                                                  \
        {                                                                    \
            uint8_t         buf[size];                                       \
            alignment_type  alignment_holder;                                \
        } cname

// TODO: Need to define this properly
#define NN_SSL_SIZEOF_SSL_CONTEXT_TYPE 0x80 // NOLINT(readability/define)
NN_SSL_DEFINE_ALIGNED_STORAGE(nnsslSslContextType, nn::ssl::Context, NN_SSL_SIZEOF_SSL_CONTEXT_TYPE, void*);

typedef enum nnsslContextSslVersion
{
    nnsslContextSslVersion_Auto   = 0x01, //<! Automatically select the highest version supported
    nnsslContextSslVersion_SslV2  = 0x02, //<! SSLv2
    nnsslContextSslVersion_SslV3  = 0x04, //<! SSLv3
    nnsslContextSslVersion_TlsV10 = 0x08, //<! TLS 1.0
    nnsslContextSslVersion_TlsV11 = 0x10, //<! TLS 1.1
    nnsslContextSslVersion_TlsV12 = 0x20, //<! TLS 1.2
}nnsslContextSslVersion;

typedef enum nnsslContextOption
{
    nnsslContextOption_None = 0x00, //<! No option
}nnsslContextOption;

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

nnResult nnsslContextCreate(
    nnsslSslContextType* pSslContext,
    nnsslContextSslVersion version);

nnResult nnsslContextDestroy(nnsslSslContextType* pClientContext);

nnResult nnsslContextGetContextId(
    nnsslSslContextType* pInSslontext,
    nnsslSslContextId* pOutContextId);

#ifdef __cplusplus
}
#endif // __cplusplus
