﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nnc/dns/parser/dns_ParserDependencies.h>
#include <nnc/dns/parser/dns_ParserCommon.h>

struct nndnsparserRecord
{
    const struct nndnsparserMessage* pMessage;
    struct nndnsparserMemoryBlock range;
    size_t dirtySize;
    struct nndnsparserLabel name;
    uint16_t type;
    uint16_t rclass;
    uint32_t timeToLive;
    uint16_t length;
    const uint8_t* data;
};

void nndnsparserRecordInitialize(struct nndnsparserRecord* pRecord,
                                 const struct nndnsparserMessage* pMessage);

ssize_t nndnsparserRecordSizeOf(const struct nndnsparserRecord* pRecord);

bool nndnsparserRecordIsEqual(const struct nndnsparserRecord* pRecord1,
                              const struct nndnsparserRecord* pRecord2);

ssize_t nndnsparserRecordFromBuffer(struct nndnsparserRecord* pRecord,
                                    const uint8_t* pBuffer,
                                    size_t size);

ssize_t nndnsparserRecordToBuffer(uint8_t * const pBuffer,
                                  size_t left,
                                  const struct nndnsparserRecord* pRecord);
