﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nnc/dns/parser/dns_ParserDependencies.h>

struct nndnsparserHeader;
struct nndnsparserLabel;
struct nndnsparserMessage;
struct nndnsparserQuestion;
struct nndnsparserRecord;
struct nndnsparserRecordIterator;

int nndnsparserCreateInaddrArpaString(char* pArpaBuffer,
                                      size_t size,
                                      uint32_t ipAddress);

struct nndnsparserMemoryBlock
{
    const uint8_t* pStart;
    const uint8_t* pEnd;
};

bool nndnsparserMemoryBlockIsEqual(const struct nndnsparserMemoryBlock* pBlock1,
                                   const struct nndnsparserMemoryBlock* pBlock2);

#if !defined(NN_DNSPARSER_HEADER_FLAG_VALUE)
#define NN_DNSPARSER_HEADER_FLAG_VALUE(flags, shift, mask) (((flags) >> shift ) & mask)
#endif
