﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       xcd ライブラリに関係する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace xcd {


/**
 * @brief       Joy-Con からのスリープ復帰トリガーの発行要因を表す列挙体です。
 */
enum  AwakeTriggerReason: uint8_t
{
    AwakeTriggerReason_None,                  //!< スリープ復帰要因が存在しません
    AwakeTriggerReason_HomePressed,           //!< Home ボタンが押下されました
    AwakeTriggerReason_BatteryLevelChanged,   //!< 電池残量が変化しました
};

/**
 * @brief       左レールのスリープ復帰トリガーの発行要因を取得します
 *
 * @details     Joy-Con がスリープ復帰のトリガーを発行した要因を取得します。
 *              Joy-Con は、本体との通信が確立されていない状況で Home ボタンの押下または電池残量の変化が発生すると、
 *              スリープ復帰のトリガーを発行します。
 *
 *              本関数では、最後に発行したスリープ復帰のトリガーの要因を取得します。
 *              スリープ復帰のトリガーが発行されていない場合やJoy-Con が接続されていない場合は、SleepTriggerReason_None が返ります。
 *
 * @return      スリープ復帰トリガーに対する発行要因
 */
AwakeTriggerReason GetAwakeTriggerReasonForLeftRail() NN_NOEXCEPT;

/**
 * @brief       右レールのスリープ復帰トリガーの発行要因を取得します
 *
 * @details     Joy-Con がスリープ復帰のトリガーを発行した要因を取得します。
 *              Joy-Con は、本体との通信が確立されていない状況で Home ボタンの押下または電池残量の変化が発生すると、
 *              スリープ復帰のトリガーを発行します。
 *
 *              本関数では、最後に発行したスリープ復帰のトリガーの要因を取得します。
 *              スリープ復帰のトリガーが発行されていない場合やJoy-Con が接続されていない場合は、SleepTriggerReason_None が返ります。
 *
 * @return      スリープ復帰トリガーに対する発行要因
 */
AwakeTriggerReason GetAwakeTriggerReasonForRightRail() NN_NOEXCEPT;

}} // namespace nn::xcd
