﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       xcd ライブラリに関係する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_BitTypes.h>

namespace nn { namespace xcd {

/**
 * @brief       プレイヤーインジケータの点灯パターンを取得します。
 *
 * @details     プレイヤーインジケータの点灯パターンを取得します。
 *              4つのインジケータの個別の点灯/消灯状態を取得します。
 *
 * @param[out]  pPattern             点灯パターン。4bitで各インジケータの状態をそれぞれ取得します。
 * @param[in]   handle               デバイスへのハンドル。
 *
 * @return      実行結果を返します。
 * @retval      ResultSuccess                 処理に成功しました。
 * @retval      ResultNotConnected            デバイスが接続されていません。
 *
 * @pre         - xcd ライブラリは初期化済である必要があります。
 *              - pPattern != nullptr
 */
Result GetPlayerIndicatorPattern(nn::Bit8* pPattern, DeviceHandle handle) NN_NOEXCEPT;

/**
 * @brief       プレイヤーインジケータの点灯パターンを設定します。
 *
 * @details     プレイヤーインジケータの点灯パターンを設定します。
 *              4つのインジケータに対してそれぞれ点灯/消灯状態を個別に設定できます。
 *
 * @param[in]   pattern         点灯パターン。4bitで各インジケータの状態をそれぞれ設定します。
 * @param[in]   handle          デバイスへのハンドル。
 *
 * @return      実行結果を返します。
 * @retval      ResultSuccess             処理に成功しました。
 * @retval      ResultNotConnected            デバイスが接続されていません。
 *
 * @pre         - xcd ライブラリは初期化済である必要があります。
 *              - pattern < 0x10
 */
Result SetPlayerIndicatorPattern(nn::Bit8 pattern, DeviceHandle handle) NN_NOEXCEPT;

}} // namespace nn::xcd
