﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace wlan { namespace driver {

/*
 * mbuf pool types
 */
enum MbufType
{
    MbufType_TxData = 0,       // normal tx data
    MbufType_RxData,       // normal rx data
    MbufType_EventData,       // event data
    MbufType_IoctlCmdRes,  // ioctl response
    MbufType_Num
};

/*
 * 各mbuf poolのサイズ（mbuf個数）
 */
static const size_t MbufPoolCountTx    = 160;
static const size_t MbufPoolCountRx    = 304;
static const size_t MbufPoolCountEvent = 16;
static const size_t MbufPoolCountIoctl = 24;

}}}

