﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for framebuffer status queries.
 */

#pragma once

namespace nn { namespace vi {

    /**
     * @brief States for framebuffers used on the display.
     *
     * @details Before their first use, a framebuffer is in the uninitialized state.
     *          The framebuffer enters the acquired state after the application retrieves
     *          a surface for rendering through a graphics API call. Once the application
     *          is finished programming rendering commands and invokes a presentation API,
     *          then the framebuffer is enqueued for use on the display. When rendering is
     *          complete, then it will be presented to the display. After a second framebuffer
     *          is ready to be presented, then the current framebuffer will become available.
     */
    enum FramebufferStatus
    {
        FramebufferStatus_Uninitialized, //!< The framebuffer has never been used and may be acquired by the application.
        FramebufferStatus_Available,     //!< The framebuffer is not currently used and may be acquired by the application.
        FramebufferStatus_Acquired,      //!< The framebuffer has been acquired by the application for the purposes of rendering.
        FramebufferStatus_Enqueued,      //!< The framebuffer will be presented to the display after rendering is complete.
        FramebufferStatus_Presenting,    //!< The framebuffer is shown on the display.
    };
}}

