﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Functions to control content across all displays.
 */

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace vi {

    /**
     * @brief Sets visibility of all layers on all displays.
     *
     * @param[in] isVisible The requested visibility on all layers.
     *
     * @pre
     *       - VI library is initialized.
     * @post The visibility of all layers matches that of @a isVisible.
     */
    void SetContentVisibility(bool isVisible) NN_NOEXCEPT;

}}
