﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for aspect ratios.
 */

#pragma once

namespace nn { namespace vi {

    /**
     * @brief Common aspect ratios for displays.
     */
    enum AspectRatio
    {
        AspectRatio_Unknown, //!< Aspect ratio was not specified.
        AspectRatio_4_3,     //!< 4:3
        AspectRatio_16_9,    //!< 16:9
        AspectRatio_64_27,   //!< 64:27
        AspectRatio_256_135, //!< 256:135
    };

}}
