﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/vi_Types.h>
#include <nn/vi/vi_LayerSettings.h>
#include <nn/vi/vi_LayerStack.h>

namespace nn{ namespace vi{

    typedef uint64_t DisplayId;
    typedef uint64_t LayerId;

    typedef uint64_t IndirectLayerHandleType;
    typedef uint64_t IndirectProducerHandleType;
    typedef uint64_t IndirectConsumerHandleType;

    typedef uint32_t CmuModeType;
    typedef uint32_t ContentTypeType;
    typedef uint32_t HotplugStateType;
    typedef uint32_t LayerStackType;
    typedef uint32_t PixelFormatType;
    typedef uint32_t PowerStateType;
    typedef uint32_t RgbRangeType;
    typedef uint32_t ScalingModeType;
    typedef uint32_t StereoModeType;

    NN_STATIC_ASSERT(sizeof(LayerSettings) == sizeof(uint32_t));
    typedef uint32_t LayerSettingsType;

    struct DisplayName{
        char value[DisplayInfo::NameLengthMax];
    };

    struct ProxyName{
        char value[8];
    };

    struct ProxyNameSafe
    {
    public:
        void Set(const ProxyName& name) NN_NOEXCEPT
        {
            memset(value, 0, sizeof(value));
            memcpy(value, name.value, sizeof(ProxyName));
        }

        ProxyName Get() const NN_NOEXCEPT
        {
            ProxyName name = {};
            memcpy(&name, value, sizeof(name));
            return name;
        }
    public:
        char value[sizeof(ProxyName) + 1];
    };

    class LayerConfig
    {
    public:
        LayerConfig()
            : zOrder(0)
        {
            stacks.Reset();
            mask.Reset();
        }

        int zOrder;
        LayerStackSet stacks;
        LayerStackSet mask;
    };
}}
