﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/vi/fbshare/vi_SharedBufferHandle.h>
#include <nn/vi/fbshare/vi_SharedLayerHandle.h>
#include <nn/vi/fbshare/vi_SharedLayerTextureIndexList.h>
#include <nn/vi/fbshare/vi_SharedMemoryPoolLayout.h>
#include <nn/vi/fbshare/vi_SharedTextureOption.h>
#include <nn/vi/native/vi_NativeType.h>
#include <nn/vi/sf/hosbinder_IHOSBinderDriver.sfdl.h>
#include <nn/vi/sf/vi_PolicyLevel.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/vi/vi_CropRegion.h>
#include <nn/vi/vi_DisplayError.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include <nn/vi/vi_ImageTransform.h>
#include <nn/vi/vi_LayerStack.h>
#include <nn/vi/vi_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace visrv { namespace sf { // NOLINT(whitespace/braces)

class IApplicationDisplayService;

class IApplicationRootService;

class IManagerDisplayService;

class IManagerRootService;

class ISystemDisplayService;

class ISystemRootService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IApplicationDisplayService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IApplicationDisplayService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRelayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outRelayService))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::ISystemDisplayService>> outSystemService))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetManagerDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IManagerDisplayService>> outManagerService))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectDisplayTransactionService, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outService))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplays, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::DisplayInfo>& outInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDisplay, (::nn::sf::Out<::nn::vi::DisplayId> outDisplayId, const ::nn::vi::DisplayName& name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDefaultDisplay, (::nn::sf::Out<::nn::vi::DisplayId> outDisplayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseDisplay, (::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayEnabled, (::nn::vi::DisplayId displayId, bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayResolution, (::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenLayer, (::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::LayerId layerId, const ::nn::vi::DisplayName& displayName, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseLayer, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateStrayLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyStrayLayer, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerScalingMode, (::nn::vi::LayerId layerId, ::nn::vi::ScalingModeType mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConvertScalingMode, (::nn::sf::Out<::std::int64_t> outMode, ::nn::vi::ScalingModeType viMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageMap, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outStride, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t width, ::std::int64_t height, ::nn::vi::IndirectConsumerHandleType consumerHandle, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageCropMap, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outStride, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t width, ::std::int64_t height, float sourceRectX, float sourceRectY, float sourceRectWidth, float sourceRectHeight, ::nn::vi::IndirectConsumerHandleType consumerHandle, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageRequiredMemoryInfo, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outAlignment, ::std::int64_t width, ::std::int64_t height))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayVsyncEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayVsyncEventForDebug, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IApplicationDisplayService)

        ::nn::Result GetRelayService(::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outRelayService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRelayService, (outRelayService));
        }

        ::nn::Result GetSystemDisplayService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::ISystemDisplayService>> outSystemService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemDisplayService, (outSystemService));
        }

        ::nn::Result GetManagerDisplayService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IManagerDisplayService>> outManagerService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetManagerDisplayService, (outManagerService));
        }

        ::nn::Result GetIndirectDisplayTransactionService(::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetIndirectDisplayTransactionService, (outService));
        }

        ::nn::Result ListDisplays(::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::DisplayInfo>& outInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDisplays, (outCount, outInfo));
        }

        ::nn::Result OpenDisplay(::nn::sf::Out<::nn::vi::DisplayId> outDisplayId, const ::nn::vi::DisplayName& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDisplay, (outDisplayId, name));
        }

        ::nn::Result OpenDefaultDisplay(::nn::sf::Out<::nn::vi::DisplayId> outDisplayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDefaultDisplay, (outDisplayId));
        }

        ::nn::Result CloseDisplay(::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseDisplay, (displayId));
        }

        ::nn::Result SetDisplayEnabled(::nn::vi::DisplayId displayId, bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayEnabled, (displayId, isEnabled));
        }

        ::nn::Result GetDisplayResolution(::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayResolution, (outWidth, outHeight, displayId));
        }

        ::nn::Result OpenLayer(::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::LayerId layerId, const ::nn::vi::DisplayName& displayName, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenLayer, (outNativeWindowDataSize, outNativeWindowData, layerId, displayName, aruid));
        }

        ::nn::Result CloseLayer(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseLayer, (layerId));
        }

        ::nn::Result CreateStrayLayer(::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateStrayLayer, (outLayerId, outNativeWindowDataSize, outNativeWindowData, displayId, settings));
        }

        ::nn::Result DestroyStrayLayer(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyStrayLayer, (layerId));
        }

        ::nn::Result SetLayerScalingMode(::nn::vi::LayerId layerId, ::nn::vi::ScalingModeType mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLayerScalingMode, (layerId, mode));
        }

        ::nn::Result ConvertScalingMode(::nn::sf::Out<::std::int64_t> outMode, ::nn::vi::ScalingModeType viMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConvertScalingMode, (outMode, viMode));
        }

        ::nn::Result GetIndirectLayerImageMap(::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outStride, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t width, ::std::int64_t height, ::nn::vi::IndirectConsumerHandleType consumerHandle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetIndirectLayerImageMap, (outSize, outStride, outBuffer, width, height, consumerHandle, aruid));
        }

        ::nn::Result GetIndirectLayerImageCropMap(::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outStride, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t width, ::std::int64_t height, float sourceRectX, float sourceRectY, float sourceRectWidth, float sourceRectHeight, ::nn::vi::IndirectConsumerHandleType consumerHandle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetIndirectLayerImageCropMap, (outSize, outStride, outBuffer, width, height, sourceRectX, sourceRectY, sourceRectWidth, sourceRectHeight, consumerHandle, aruid));
        }

        ::nn::Result GetIndirectLayerImageRequiredMemoryInfo(::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outAlignment, ::std::int64_t width, ::std::int64_t height) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetIndirectLayerImageRequiredMemoryInfo, (outSize, outAlignment, width, height));
        }

        ::nn::Result GetDisplayVsyncEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayVsyncEvent, (outHandle, displayId));
        }

        ::nn::Result GetDisplayVsyncEventForDebug(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayVsyncEventForDebug, (outHandle, displayId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IApplicationDisplayService
    {
    public:
        nn::Result GetRelayService(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outRelayService) NN_NOEXCEPT;
        nn::Result GetSystemDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>> outSystemService) NN_NOEXCEPT;
        nn::Result GetManagerDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IManagerDisplayService>> outManagerService) NN_NOEXCEPT;
        nn::Result GetIndirectDisplayTransactionService(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outService) NN_NOEXCEPT;
        nn::Result ListDisplays(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayInfo>& outInfo) NN_NOEXCEPT;
        nn::Result OpenDisplay(nn::sf::Out<nn::vi::DisplayId> outDisplayId, const nn::vi::DisplayName& name) NN_NOEXCEPT;
        nn::Result OpenDefaultDisplay(nn::sf::Out<nn::vi::DisplayId> outDisplayId) NN_NOEXCEPT;
        nn::Result CloseDisplay(nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayEnabled(nn::vi::DisplayId displayId, bool isEnabled) NN_NOEXCEPT;
        nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result OpenLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CloseLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result CreateStrayLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings) NN_NOEXCEPT;
        nn::Result DestroyStrayLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result SetLayerScalingMode(nn::vi::LayerId layerId, nn::vi::ScalingModeType mode) NN_NOEXCEPT;
        nn::Result ConvertScalingMode(nn::sf::Out<std::int64_t> outMode, nn::vi::ScalingModeType viMode) NN_NOEXCEPT;
        nn::Result GetIndirectLayerImageMap(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outStride, const nn::sf::OutBuffer& outBuffer, std::int64_t width, std::int64_t height, nn::vi::IndirectConsumerHandleType consumerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result GetIndirectLayerImageCropMap(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outStride, const nn::sf::OutBuffer& outBuffer, std::int64_t width, std::int64_t height, float sourceRectX, float sourceRectY, float sourceRectWidth, float sourceRectHeight, nn::vi::IndirectConsumerHandleType consumerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result GetIndirectLayerImageRequiredMemoryInfo(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outAlignment, std::int64_t width, std::int64_t height) NN_NOEXCEPT;
        nn::Result GetDisplayVsyncEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetDisplayVsyncEventForDebug(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetRelayService(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outRelayService) NN_NOEXCEPT;
    nn::Result GetSystemDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>> outSystemService) NN_NOEXCEPT;
    nn::Result GetManagerDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IManagerDisplayService>> outManagerService) NN_NOEXCEPT;
    nn::Result GetIndirectDisplayTransactionService(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outService) NN_NOEXCEPT;
    nn::Result ListDisplays(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayInfo>& outInfo) NN_NOEXCEPT;
    nn::Result OpenDisplay(nn::sf::Out<nn::vi::DisplayId> outDisplayId, const nn::vi::DisplayName& name) NN_NOEXCEPT;
    nn::Result OpenDefaultDisplay(nn::sf::Out<nn::vi::DisplayId> outDisplayId) NN_NOEXCEPT;
    nn::Result CloseDisplay(nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayEnabled(nn::vi::DisplayId displayId, bool isEnabled) NN_NOEXCEPT;
    nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result OpenLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result CloseLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result CreateStrayLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings) NN_NOEXCEPT;
    nn::Result DestroyStrayLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result SetLayerScalingMode(nn::vi::LayerId layerId, nn::vi::ScalingModeType mode) NN_NOEXCEPT;
    nn::Result ConvertScalingMode(nn::sf::Out<std::int64_t> outMode, nn::vi::ScalingModeType viMode) NN_NOEXCEPT;
    nn::Result GetIndirectLayerImageMap(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outStride, const nn::sf::OutBuffer& outBuffer, std::int64_t width, std::int64_t height, nn::vi::IndirectConsumerHandleType consumerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result GetIndirectLayerImageCropMap(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outStride, const nn::sf::OutBuffer& outBuffer, std::int64_t width, std::int64_t height, float sourceRectX, float sourceRectY, float sourceRectWidth, float sourceRectHeight, nn::vi::IndirectConsumerHandleType consumerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result GetIndirectLayerImageRequiredMemoryInfo(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outAlignment, std::int64_t width, std::int64_t height) NN_NOEXCEPT;
    nn::Result GetDisplayVsyncEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result GetDisplayVsyncEventForDebug(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::visrv::sf::IApplicationDisplayService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRelayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outRelayService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRelayService, (outRelayService));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::ISystemDisplayService>> outSystemService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemDisplayService, (outSystemService));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetManagerDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IManagerDisplayService>> outManagerService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetManagerDisplayService, (outManagerService));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectDisplayTransactionService, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetIndirectDisplayTransactionService, (outService));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplays, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::DisplayInfo>& outInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDisplays, (outCount, outInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDisplay, (::nn::sf::Out<::nn::vi::DisplayId> outDisplayId, const ::nn::vi::DisplayName& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDisplay, (outDisplayId, name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDefaultDisplay, (::nn::sf::Out<::nn::vi::DisplayId> outDisplayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDefaultDisplay, (outDisplayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseDisplay, (::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseDisplay, (displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayEnabled, (::nn::vi::DisplayId displayId, bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayEnabled, (displayId, isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayResolution, (::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayResolution, (outWidth, outHeight, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenLayer, (::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::LayerId layerId, const ::nn::vi::DisplayName& displayName, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenLayer, (outNativeWindowDataSize, outNativeWindowData, layerId, displayName, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseLayer, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseLayer, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateStrayLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateStrayLayer, (outLayerId, outNativeWindowDataSize, outNativeWindowData, displayId, settings));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyStrayLayer, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyStrayLayer, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerScalingMode, (::nn::vi::LayerId layerId, ::nn::vi::ScalingModeType mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLayerScalingMode, (layerId, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConvertScalingMode, (::nn::sf::Out<::std::int64_t> outMode, ::nn::vi::ScalingModeType viMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConvertScalingMode, (outMode, viMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageMap, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outStride, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t width, ::std::int64_t height, ::nn::vi::IndirectConsumerHandleType consumerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetIndirectLayerImageMap, (outSize, outStride, outBuffer, width, height, consumerHandle, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageCropMap, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outStride, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t width, ::std::int64_t height, float sourceRectX, float sourceRectY, float sourceRectWidth, float sourceRectHeight, ::nn::vi::IndirectConsumerHandleType consumerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetIndirectLayerImageCropMap, (outSize, outStride, outBuffer, width, height, sourceRectX, sourceRectY, sourceRectWidth, sourceRectHeight, consumerHandle, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageRequiredMemoryInfo, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outAlignment, ::std::int64_t width, ::std::int64_t height))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetIndirectLayerImageRequiredMemoryInfo, (outSize, outAlignment, width, height));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayVsyncEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayVsyncEvent, (outHandle, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayVsyncEventForDebug, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayVsyncEventForDebug, (outHandle, displayId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::visrv::sf::IApplicationDisplayService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::visrv::sf::IApplicationDisplayService))

    // nn::Result GetRelayService(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outRelayService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRelayService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outRelayService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outRelayService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRelayService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRelayService)

    // nn::Result GetSystemDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>> outSystemService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemDisplayService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outSystemService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outSystemService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSystemService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemDisplayService)

    // nn::Result GetManagerDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IManagerDisplayService>> outManagerService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetManagerDisplayService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outManagerService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outManagerService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outManagerService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetManagerDisplayService)

    // nn::Result GetIndirectDisplayTransactionService(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIndirectDisplayTransactionService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIndirectDisplayTransactionService)

    // nn::Result ListDisplays(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayInfo>& outInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDisplays)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outInfo, 0, (const ::nn::sf::OutArray<::nn::vi::DisplayInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDisplays)

    // nn::Result OpenDisplay(nn::sf::Out<nn::vi::DisplayId> outDisplayId, const nn::vi::DisplayName& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDisplay)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, (::nn::vi::DisplayName), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (name))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outDisplayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outDisplayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDisplayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDisplay)

    // nn::Result OpenDefaultDisplay(nn::sf::Out<nn::vi::DisplayId> outDisplayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDefaultDisplay)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outDisplayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outDisplayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDisplayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDefaultDisplay)

    // nn::Result CloseDisplay(nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseDisplay)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1020)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseDisplay)

    // nn::Result SetDisplayEnabled(nn::vi::DisplayId displayId, bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isEnabled, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayEnabled)

    // nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayResolution)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayResolution)

    // nn::Result OpenLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2020)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outNativeWindowData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNativeWindowData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayName, (::nn::vi::DisplayName), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (displayName, layerId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNativeWindowDataSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNativeWindowDataSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNativeWindowDataSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNativeWindowData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenLayer)

    // nn::Result CloseLayer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2021)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseLayer)

    // nn::Result CreateStrayLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateStrayLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2030)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outNativeWindowData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNativeWindowData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(settings, (::nn::vi::LayerSettingsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (settings, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLayerId, (::nn::vi::LayerId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNativeWindowDataSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outLayerId, outNativeWindowDataSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLayerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNativeWindowDataSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNativeWindowData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(settings)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateStrayLayer)

    // nn::Result DestroyStrayLayer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyStrayLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2031)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyStrayLayer)

    // nn::Result SetLayerScalingMode(nn::vi::LayerId layerId, nn::vi::ScalingModeType mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLayerScalingMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::nn::vi::ScalingModeType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (mode, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLayerScalingMode)

    // nn::Result ConvertScalingMode(nn::sf::Out<std::int64_t> outMode, nn::vi::ScalingModeType viMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConvertScalingMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(viMode, (::nn::vi::ScalingModeType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (viMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMode, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(viMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConvertScalingMode)

    // nn::Result GetIndirectLayerImageMap(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outStride, const nn::sf::OutBuffer& outBuffer, std::int64_t width, std::int64_t height, nn::vi::IndirectConsumerHandleType consumerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIndirectLayerImageMap)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2450)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(consumerHandle, (::nn::vi::IndirectConsumerHandleType), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (width, height, consumerHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStride, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outSize, outStride))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStride), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(consumerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIndirectLayerImageMap)

    // nn::Result GetIndirectLayerImageCropMap(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outStride, const nn::sf::OutBuffer& outBuffer, std::int64_t width, std::int64_t height, float sourceRectX, float sourceRectY, float sourceRectWidth, float sourceRectHeight, nn::vi::IndirectConsumerHandleType consumerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIndirectLayerImageCropMap)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2451)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceRectX, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceRectY, (float), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceRectWidth, (float), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceRectHeight, (float), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(consumerHandle, (::nn::vi::IndirectConsumerHandleType), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(8, (sourceRectX, sourceRectY, sourceRectWidth, sourceRectHeight, width, height, consumerHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStride, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outSize, outStride))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStride), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceRectX), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceRectY), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceRectWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceRectHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(consumerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIndirectLayerImageCropMap)

    // nn::Result GetIndirectLayerImageRequiredMemoryInfo(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outAlignment, std::int64_t width, std::int64_t height) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIndirectLayerImageRequiredMemoryInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2460)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (width, height))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAlignment, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outSize, outAlignment))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAlignment), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIndirectLayerImageRequiredMemoryInfo)

    // nn::Result GetDisplayVsyncEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayVsyncEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayVsyncEvent)

    // nn::Result GetDisplayVsyncEventForDebug(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayVsyncEventForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayVsyncEventForDebug)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::DisplayInfo), 96, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::DisplayId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::DisplayName), 64, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerSettingsType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::ScalingModeType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::IndirectConsumerHandleType), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::visrv::sf::IApplicationDisplayService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::visrv::sf::IApplicationDisplayService))

    // nn::Result GetRelayService(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outRelayService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRelayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outRelayService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRelayService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRelayService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRelayService)
    }

    // nn::Result GetSystemDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>> outSystemService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::ISystemDisplayService>> outSystemService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemDisplayService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSystemService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemDisplayService)
    }

    // nn::Result GetManagerDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IManagerDisplayService>> outManagerService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetManagerDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IManagerDisplayService>> outManagerService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetManagerDisplayService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outManagerService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetManagerDisplayService)
    }

    // nn::Result GetIndirectDisplayTransactionService(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectDisplayTransactionService, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIndirectDisplayTransactionService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIndirectDisplayTransactionService)
    }

    // nn::Result ListDisplays(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayInfo>& outInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplays, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::DisplayInfo>& outInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDisplays)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDisplays)
    }

    // nn::Result OpenDisplay(nn::sf::Out<nn::vi::DisplayId> outDisplayId, const nn::vi::DisplayName& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDisplay, (::nn::sf::Out<::nn::vi::DisplayId> outDisplayId, const ::nn::vi::DisplayName& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDisplay)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDisplayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDisplay)
    }

    // nn::Result OpenDefaultDisplay(nn::sf::Out<nn::vi::DisplayId> outDisplayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDefaultDisplay, (::nn::sf::Out<::nn::vi::DisplayId> outDisplayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDefaultDisplay)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDisplayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDefaultDisplay)
    }

    // nn::Result CloseDisplay(nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseDisplay, (::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseDisplay)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseDisplay)
    }

    // nn::Result SetDisplayEnabled(nn::vi::DisplayId displayId, bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayEnabled, (::nn::vi::DisplayId displayId, bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayEnabled)
    }

    // nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayResolution, (::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayResolution)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayResolution)
    }

    // nn::Result OpenLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenLayer, (::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::LayerId layerId, const ::nn::vi::DisplayName& displayName, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNativeWindowDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNativeWindowData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenLayer)
    }

    // nn::Result CloseLayer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseLayer, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseLayer)
    }

    // nn::Result CreateStrayLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateStrayLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateStrayLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLayerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNativeWindowDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNativeWindowData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(settings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateStrayLayer)
    }

    // nn::Result DestroyStrayLayer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyStrayLayer, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyStrayLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyStrayLayer)
    }

    // nn::Result SetLayerScalingMode(nn::vi::LayerId layerId, nn::vi::ScalingModeType mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerScalingMode, (::nn::vi::LayerId layerId, ::nn::vi::ScalingModeType mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLayerScalingMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLayerScalingMode)
    }

    // nn::Result ConvertScalingMode(nn::sf::Out<std::int64_t> outMode, nn::vi::ScalingModeType viMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConvertScalingMode, (::nn::sf::Out<::std::int64_t> outMode, ::nn::vi::ScalingModeType viMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConvertScalingMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(viMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConvertScalingMode)
    }

    // nn::Result GetIndirectLayerImageMap(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outStride, const nn::sf::OutBuffer& outBuffer, std::int64_t width, std::int64_t height, nn::vi::IndirectConsumerHandleType consumerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageMap, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outStride, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t width, ::std::int64_t height, ::nn::vi::IndirectConsumerHandleType consumerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIndirectLayerImageMap)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStride)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(consumerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIndirectLayerImageMap)
    }

    // nn::Result GetIndirectLayerImageCropMap(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outStride, const nn::sf::OutBuffer& outBuffer, std::int64_t width, std::int64_t height, float sourceRectX, float sourceRectY, float sourceRectWidth, float sourceRectHeight, nn::vi::IndirectConsumerHandleType consumerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageCropMap, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outStride, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t width, ::std::int64_t height, float sourceRectX, float sourceRectY, float sourceRectWidth, float sourceRectHeight, ::nn::vi::IndirectConsumerHandleType consumerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIndirectLayerImageCropMap)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStride)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceRectX)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceRectY)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceRectWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceRectHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(consumerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIndirectLayerImageCropMap)
    }

    // nn::Result GetIndirectLayerImageRequiredMemoryInfo(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outAlignment, std::int64_t width, std::int64_t height) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndirectLayerImageRequiredMemoryInfo, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outAlignment, ::std::int64_t width, ::std::int64_t height))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIndirectLayerImageRequiredMemoryInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAlignment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIndirectLayerImageRequiredMemoryInfo)
    }

    // nn::Result GetDisplayVsyncEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayVsyncEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayVsyncEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayVsyncEvent)
    }

    // nn::Result GetDisplayVsyncEventForDebug(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayVsyncEventForDebug, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayVsyncEventForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayVsyncEventForDebug)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::visrv::sf::IApplicationDisplayService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::visrv::sf::IApplicationDisplayService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRelayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>), outRelayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRelayService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outRelayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outRelayService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::visrv::sf::ISystemDisplayService>), outSystemService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemDisplayService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outSystemService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outSystemService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetManagerDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::visrv::sf::IManagerDisplayService>), outManagerService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetManagerDisplayService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outManagerService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outManagerService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIndirectDisplayTransactionService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIndirectDisplayTransactionService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDisplays)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDisplays)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDisplay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDisplay)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outDisplayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDefaultDisplay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDefaultDisplay)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outDisplayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseDisplay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseDisplay)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayResolution)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayResolution)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNativeWindowData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNativeWindowDataSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNativeWindowData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateStrayLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNativeWindowData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateStrayLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLayerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNativeWindowDataSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNativeWindowData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(settings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyStrayLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyStrayLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLayerScalingMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLayerScalingMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConvertScalingMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConvertScalingMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(viMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIndirectLayerImageMap)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIndirectLayerImageMap)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStride),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(consumerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIndirectLayerImageCropMap)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIndirectLayerImageCropMap)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStride),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceRectX),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceRectY),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceRectWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceRectHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(consumerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIndirectLayerImageRequiredMemoryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIndirectLayerImageRequiredMemoryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAlignment),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayVsyncEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayVsyncEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayVsyncEventForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayVsyncEventForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRelayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetManagerDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIndirectDisplayTransactionService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDisplays)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDisplay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDefaultDisplay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseDisplay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayResolution)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateStrayLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyStrayLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLayerScalingMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConvertScalingMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIndirectLayerImageMap)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIndirectLayerImageCropMap)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIndirectLayerImageRequiredMemoryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayVsyncEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayVsyncEventForDebug)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::visrv::sf::IApplicationDisplayService))

namespace nn { namespace visrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IApplicationRootService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IApplicationRootService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IApplicationRootService)

        ::nn::Result GetDisplayService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayService, (outService, policyLevel));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IApplicationRootService
    {
    public:
        nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::visrv::sf::IApplicationRootService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayService, (outService, policyLevel));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::visrv::sf::IApplicationRootService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::visrv::sf::IApplicationRootService))

    // nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(policyLevel, (::nn::vi::PolicyLevelType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (policyLevel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policyLevel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayService)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::PolicyLevelType), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::visrv::sf::IApplicationRootService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::visrv::sf::IApplicationRootService))

    // nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policyLevel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayService)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::visrv::sf::IApplicationRootService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::visrv::sf::IApplicationRootService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(policyLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayService)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::visrv::sf::IApplicationRootService))

namespace nn { namespace visrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManagerDisplayService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManagerDisplayService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AllocateProcessHeapBlock, (::nn::sf::Out<::std::uint64_t> outBlockId, ::std::uint64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FreeProcessHeapBlock, (::std::uint64_t blockId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayResolution, (::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateManagedLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings, ::nn::applet::AppletResourceUserId userAruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyManagedLayer, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayer, (::nn::sf::Out<::nn::vi::IndirectLayerHandleType> outLayerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayer, (::nn::vi::IndirectLayerHandleType layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectProducerEndPoint, (::nn::sf::Out<::nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, ::nn::vi::IndirectLayerHandleType layerHandle, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectProducerEndPoint, (::nn::vi::IndirectLayerHandleType layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectConsumerEndPoint, (::nn::sf::Out<::nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, ::nn::vi::IndirectLayerHandleType layerHandle, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectConsumerEndPoint, (::nn::vi::IndirectLayerHandleType layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireLayerTexturePresentingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseLayerTexturePresentingEvent, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayHotplugEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayModeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayHotplugState, (::nn::sf::Out<::nn::vi::HotplugStateType> outState, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCompositorErrorInfo, (::nn::sf::Out<::nn::vi::CompositorError> outErrorInfo, ::nn::sf::Out<::std::int32_t> outLength, ::std::int64_t errorId, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayErrorEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayAlpha, (::nn::vi::DisplayId displayId, float alpha))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayLayerStack, (::nn::vi::DisplayId displayId, ::nn::vi::LayerStackType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayPowerState, (::nn::vi::DisplayId displayId, ::nn::vi::PowerStateType state))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultDisplay, (::nn::vi::DisplayId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddToLayerStack, (::nn::vi::LayerId layerId, ::nn::vi::LayerStackType stackId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RemoveFromLayerStack, (::nn::vi::LayerId layerId, ::nn::vi::LayerStackType stackId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerVisibility, (::nn::vi::LayerId layerId, bool isVisible))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerConfig, (::nn::vi::LayerId layerId, const ::nn::vi::LayerConfig& config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AttachLayerPresentationTracer, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DetachLayerPresentationTracer, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartLayerPresentationRecording, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopLayerPresentationRecording, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartLayerPresentationFenceWait, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopLayerPresentationFenceWait, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLayerPresentationAllFencesExpiredEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SetContentVisibility, (bool isVisible))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetConductorLayer, (::nn::vi::LayerId layerId, bool isConductor))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetIndirectProducerFlipOffset, (::nn::vi::IndirectLayerHandleType layerHandle, ::nn::vi::IndirectProducerHandleType producerHandle, ::nn::TimeSpan offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferStaticStorage, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::std::uint64_t storageKey, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferTransferMemory, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroySharedBuffer, (::nn::vi::fbshare::SharedBufferHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BindSharedLowLevelLayerToManagedLayer, (::nn::vi::LayerId layerId, const ::nn::vi::DisplayName& displayName, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BindSharedLowLevelLayerToIndirectLayer, (::nn::vi::IndirectProducerHandleType handle, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnbindSharedLowLevelLayer, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConnectSharedLowLevelLayerToSharedBuffer, (::nn::vi::LayerId layerId, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectSharedLowLevelLayerFromSharedBuffer, (::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedLayer, (::nn::sf::Out<::nn::vi::fbshare::SharedLayerHandle> outLayerHandle, ::nn::applet::AppletResourceUserId userAruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroySharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AttachSharedLayerToLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer, ::nn::vi::LayerId layerId, const ::nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ForceDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLayerDetachReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLowLevelLayerSynchronizedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckSharedLowLevelLayerSynchronized, (::nn::sf::Out<::std::int64_t> outDisplayedIndex, ::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSharedBufferImporterAruid, (::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId importerAruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterSharedBufferImporterAruid, (::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId importerAruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferProcessHeap, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::std::uint64_t blockId, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLayerLayerStacks, (::nn::sf::Out<::nn::vi::LayerStackFlagType> outStacks, ::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSharedLayerLayerStacks, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer, ::nn::vi::LayerStackFlagType stacks))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PresentDetachedSharedFrameBufferToLowLevelLayer, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::nn::vi::LayerId layerId, ::std::int64_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FillDetachedSharedFrameBufferColor, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, ::std::uint32_t color, const ::nn::vi::fbshare::SharedTextureOption& option))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDetachedSharedFrameBufferImage, (::nn::sf::Out<::std::uint64_t> outDataSize, const ::nn::sf::OutBuffer& data, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDetachedSharedFrameBufferImage, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, const ::nn::sf::InBuffer& data, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::ImageTransformType srcTransform))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CopyDetachedSharedFrameBufferImage, (::nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, ::std::int64_t dstIndex, ::nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, ::std::int64_t srcIndex, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::LayerStackFlagType maskStacks, ::nn::vi::LayerStackFlagType nullStacks))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDetachedSharedFrameBufferSubImage, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, ::std::int32_t x, ::std::int32_t y, ::std::int32_t w, ::std::int32_t h, ::std::uint32_t bgColor, const ::nn::sf::InBuffer& data, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::ImageTransformType srcTransform))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFrameBufferContentParameter, (::nn::sf::Out<::nn::vi::LayerStackFlagType> outLayerStacks, ::nn::sf::Out<::nn::vi::CropRegion> outCropRegion, ::nn::sf::Out<::std::int32_t> outScalingMode, ::nn::sf::Out<::std::uint32_t> outTransform, ::nn::sf::Out<::std::int32_t> outPresentInterval, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExpandStartupLogoOnSharedFrameBuffer, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t dstIndex, const ::nn::vi::fbshare::SharedTextureOption& option))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManagerDisplayService)

        ::nn::Result AllocateProcessHeapBlock(::nn::sf::Out<::std::uint64_t> outBlockId, ::std::uint64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AllocateProcessHeapBlock, (outBlockId, size));
        }

        ::nn::Result FreeProcessHeapBlock(::std::uint64_t blockId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FreeProcessHeapBlock, (blockId));
        }

        ::nn::Result GetDisplayResolution(::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayResolution, (outWidth, outHeight, displayId));
        }

        ::nn::Result CreateManagedLayer(::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings, ::nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateManagedLayer, (outLayerId, displayId, settings, userAruid));
        }

        ::nn::Result DestroyManagedLayer(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyManagedLayer, (layerId));
        }

        ::nn::Result CreateIndirectLayer(::nn::sf::Out<::nn::vi::IndirectLayerHandleType> outLayerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateIndirectLayer, (outLayerHandle));
        }

        ::nn::Result DestroyIndirectLayer(::nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyIndirectLayer, (layerHandle));
        }

        ::nn::Result CreateIndirectProducerEndPoint(::nn::sf::Out<::nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, ::nn::vi::IndirectLayerHandleType layerHandle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateIndirectProducerEndPoint, (outProducerEndPointHandle, layerHandle, aruid));
        }

        ::nn::Result DestroyIndirectProducerEndPoint(::nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyIndirectProducerEndPoint, (layerHandle));
        }

        ::nn::Result CreateIndirectConsumerEndPoint(::nn::sf::Out<::nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, ::nn::vi::IndirectLayerHandleType layerHandle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateIndirectConsumerEndPoint, (outConsumerEndPointHandle, layerHandle, aruid));
        }

        ::nn::Result DestroyIndirectConsumerEndPoint(::nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyIndirectConsumerEndPoint, (layerHandle));
        }

        ::nn::Result AcquireLayerTexturePresentingEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireLayerTexturePresentingEvent, (outHandle, layerId));
        }

        ::nn::Result ReleaseLayerTexturePresentingEvent(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReleaseLayerTexturePresentingEvent, (layerId));
        }

        ::nn::Result GetDisplayHotplugEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayHotplugEvent, (outHandle, displayId));
        }

        ::nn::Result GetDisplayModeChangedEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayModeChangedEvent, (outHandle, displayId));
        }

        ::nn::Result GetDisplayHotplugState(::nn::sf::Out<::nn::vi::HotplugStateType> outState, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayHotplugState, (outState, displayId));
        }

        ::nn::Result GetCompositorErrorInfo(::nn::sf::Out<::nn::vi::CompositorError> outErrorInfo, ::nn::sf::Out<::std::int32_t> outLength, ::std::int64_t errorId, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCompositorErrorInfo, (outErrorInfo, outLength, errorId, displayId));
        }

        ::nn::Result GetDisplayErrorEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayErrorEvent, (outHandle, displayId));
        }

        ::nn::Result SetDisplayAlpha(::nn::vi::DisplayId displayId, float alpha) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayAlpha, (displayId, alpha));
        }

        ::nn::Result SetDisplayLayerStack(::nn::vi::DisplayId displayId, ::nn::vi::LayerStackType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayLayerStack, (displayId, id));
        }

        ::nn::Result SetDisplayPowerState(::nn::vi::DisplayId displayId, ::nn::vi::PowerStateType state) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayPowerState, (displayId, state));
        }

        ::nn::Result SetDefaultDisplay(::nn::vi::DisplayId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDefaultDisplay, (id));
        }

        ::nn::Result AddToLayerStack(::nn::vi::LayerId layerId, ::nn::vi::LayerStackType stackId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddToLayerStack, (layerId, stackId));
        }

        ::nn::Result RemoveFromLayerStack(::nn::vi::LayerId layerId, ::nn::vi::LayerStackType stackId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RemoveFromLayerStack, (layerId, stackId));
        }

        ::nn::Result SetLayerVisibility(::nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLayerVisibility, (layerId, isVisible));
        }

        ::nn::Result SetLayerConfig(::nn::vi::LayerId layerId, const ::nn::vi::LayerConfig& config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLayerConfig, (layerId, config));
        }

        ::nn::Result AttachLayerPresentationTracer(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AttachLayerPresentationTracer, (layerId));
        }

        ::nn::Result DetachLayerPresentationTracer(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DetachLayerPresentationTracer, (layerId));
        }

        ::nn::Result StartLayerPresentationRecording(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartLayerPresentationRecording, (layerId));
        }

        ::nn::Result StopLayerPresentationRecording(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopLayerPresentationRecording, (layerId));
        }

        ::nn::Result StartLayerPresentationFenceWait(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartLayerPresentationFenceWait, (layerId));
        }

        ::nn::Result StopLayerPresentationFenceWait(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopLayerPresentationFenceWait, (layerId));
        }

        ::nn::Result GetLayerPresentationAllFencesExpiredEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLayerPresentationAllFencesExpiredEvent, (outHandle, layerId));
        }

        void SetContentVisibility(bool isVisible) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SetContentVisibility, (isVisible));
        }

        ::nn::Result SetConductorLayer(::nn::vi::LayerId layerId, bool isConductor) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetConductorLayer, (layerId, isConductor));
        }

        ::nn::Result SetIndirectProducerFlipOffset(::nn::vi::IndirectLayerHandleType layerHandle, ::nn::vi::IndirectProducerHandleType producerHandle, ::nn::TimeSpan offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetIndirectProducerFlipOffset, (layerHandle, producerHandle, offset));
        }

        ::nn::Result CreateSharedBufferStaticStorage(::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::std::uint64_t storageKey, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSharedBufferStaticStorage, (outHandle, storageKey, layout));
        }

        ::nn::Result CreateSharedBufferTransferMemory(::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSharedBufferTransferMemory, (outHandle, ::std::move(transferMemoryHandle), transferMemorySize, layout));
        }

        ::nn::Result DestroySharedBuffer(::nn::vi::fbshare::SharedBufferHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroySharedBuffer, (handle));
        }

        ::nn::Result BindSharedLowLevelLayerToManagedLayer(::nn::vi::LayerId layerId, const ::nn::vi::DisplayName& displayName, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BindSharedLowLevelLayerToManagedLayer, (layerId, displayName, aruid));
        }

        ::nn::Result BindSharedLowLevelLayerToIndirectLayer(::nn::vi::IndirectProducerHandleType handle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BindSharedLowLevelLayerToIndirectLayer, (handle, aruid));
        }

        ::nn::Result UnbindSharedLowLevelLayer(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnbindSharedLowLevelLayer, (layerId));
        }

        ::nn::Result ConnectSharedLowLevelLayerToSharedBuffer(::nn::vi::LayerId layerId, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConnectSharedLowLevelLayerToSharedBuffer, (layerId, hSharedBuffer));
        }

        ::nn::Result DisconnectSharedLowLevelLayerFromSharedBuffer(::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DisconnectSharedLowLevelLayerFromSharedBuffer, (layerId));
        }

        ::nn::Result CreateSharedLayer(::nn::sf::Out<::nn::vi::fbshare::SharedLayerHandle> outLayerHandle, ::nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSharedLayer, (outLayerHandle, userAruid));
        }

        ::nn::Result DestroySharedLayer(::nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroySharedLayer, (hLayer));
        }

        ::nn::Result AttachSharedLayerToLowLevelLayer(::nn::vi::fbshare::SharedLayerHandle hSharedLayer, ::nn::vi::LayerId layerId, const ::nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AttachSharedLayerToLowLevelLayer, (hSharedLayer, layerId, frameBufferIndexList));
        }

        ::nn::Result ForceDetachSharedLayerFromLowLevelLayer(::nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ForceDetachSharedLayerFromLowLevelLayer, (hSharedLayer));
        }

        ::nn::Result StartDetachSharedLayerFromLowLevelLayer(::nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartDetachSharedLayerFromLowLevelLayer, (hSharedLayer));
        }

        ::nn::Result FinishDetachSharedLayerFromLowLevelLayer(::nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishDetachSharedLayerFromLowLevelLayer, (hSharedLayer));
        }

        ::nn::Result GetSharedLayerDetachReadyEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedLayerDetachReadyEvent, (outHandle, hSharedLayer));
        }

        ::nn::Result GetSharedLowLevelLayerSynchronizedEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedLowLevelLayerSynchronizedEvent, (outHandle, layerId));
        }

        ::nn::Result CheckSharedLowLevelLayerSynchronized(::nn::sf::Out<::std::int64_t> outDisplayedIndex, ::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckSharedLowLevelLayerSynchronized, (outDisplayedIndex, layerId));
        }

        ::nn::Result RegisterSharedBufferImporterAruid(::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterSharedBufferImporterAruid, (hBuffer, importerAruid));
        }

        ::nn::Result UnregisterSharedBufferImporterAruid(::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterSharedBufferImporterAruid, (hBuffer, importerAruid));
        }

        ::nn::Result CreateSharedBufferProcessHeap(::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::std::uint64_t blockId, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSharedBufferProcessHeap, (outHandle, blockId, layout));
        }

        ::nn::Result GetSharedLayerLayerStacks(::nn::sf::Out<::nn::vi::LayerStackFlagType> outStacks, ::nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedLayerLayerStacks, (outStacks, hSharedLayer));
        }

        ::nn::Result SetSharedLayerLayerStacks(::nn::vi::fbshare::SharedLayerHandle hSharedLayer, ::nn::vi::LayerStackFlagType stacks) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSharedLayerLayerStacks, (hSharedLayer, stacks));
        }

        ::nn::Result PresentDetachedSharedFrameBufferToLowLevelLayer(::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::nn::vi::LayerId layerId, ::std::int64_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PresentDetachedSharedFrameBufferToLowLevelLayer, (hSharedBuffer, layerId, index));
        }

        ::nn::Result FillDetachedSharedFrameBufferColor(::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, ::std::uint32_t color, const ::nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FillDetachedSharedFrameBufferColor, (hSharedBuffer, index, color, option));
        }

        ::nn::Result GetDetachedSharedFrameBufferImage(::nn::sf::Out<::std::uint64_t> outDataSize, const ::nn::sf::OutBuffer& data, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDetachedSharedFrameBufferImage, (outDataSize, data, hSharedBuffer, index));
        }

        ::nn::Result SetDetachedSharedFrameBufferImage(::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, const ::nn::sf::InBuffer& data, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDetachedSharedFrameBufferImage, (hSharedBuffer, index, data, dstOption, srcTransform));
        }

        ::nn::Result CopyDetachedSharedFrameBufferImage(::nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, ::std::int64_t dstIndex, ::nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, ::std::int64_t srcIndex, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::LayerStackFlagType maskStacks, ::nn::vi::LayerStackFlagType nullStacks) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CopyDetachedSharedFrameBufferImage, (hDstSharedBuffer, dstIndex, hSrcSharedBuffer, srcIndex, dstOption, maskStacks, nullStacks));
        }

        ::nn::Result SetDetachedSharedFrameBufferSubImage(::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, ::std::int32_t x, ::std::int32_t y, ::std::int32_t w, ::std::int32_t h, ::std::uint32_t bgColor, const ::nn::sf::InBuffer& data, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDetachedSharedFrameBufferSubImage, (hSharedBuffer, index, x, y, w, h, bgColor, data, dstOption, srcTransform));
        }

        ::nn::Result GetSharedFrameBufferContentParameter(::nn::sf::Out<::nn::vi::LayerStackFlagType> outLayerStacks, ::nn::sf::Out<::nn::vi::CropRegion> outCropRegion, ::nn::sf::Out<::std::int32_t> outScalingMode, ::nn::sf::Out<::std::uint32_t> outTransform, ::nn::sf::Out<::std::int32_t> outPresentInterval, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedFrameBufferContentParameter, (outLayerStacks, outCropRegion, outScalingMode, outTransform, outPresentInterval, hSharedBuffer, index));
        }

        ::nn::Result ExpandStartupLogoOnSharedFrameBuffer(::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t dstIndex, const ::nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExpandStartupLogoOnSharedFrameBuffer, (hSharedBuffer, dstIndex, option));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManagerDisplayService
    {
    public:
        nn::Result AllocateProcessHeapBlock(nn::sf::Out<std::uint64_t> outBlockId, std::uint64_t size) NN_NOEXCEPT;
        nn::Result FreeProcessHeapBlock(std::uint64_t blockId) NN_NOEXCEPT;
        nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result CreateManagedLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT;
        nn::Result DestroyManagedLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result CreateIndirectLayer(nn::sf::Out<nn::vi::IndirectLayerHandleType> outLayerHandle) NN_NOEXCEPT;
        nn::Result DestroyIndirectLayer(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;
        nn::Result CreateIndirectProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DestroyIndirectProducerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;
        nn::Result CreateIndirectConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DestroyIndirectConsumerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;
        nn::Result AcquireLayerTexturePresentingEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result ReleaseLayerTexturePresentingEvent(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result GetDisplayHotplugEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetDisplayModeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetDisplayHotplugState(nn::sf::Out<nn::vi::HotplugStateType> outState, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetCompositorErrorInfo(nn::sf::Out<nn::vi::CompositorError> outErrorInfo, nn::sf::Out<std::int32_t> outLength, std::int64_t errorId, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetDisplayErrorEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayAlpha(nn::vi::DisplayId displayId, float alpha) NN_NOEXCEPT;
        nn::Result SetDisplayLayerStack(nn::vi::DisplayId displayId, nn::vi::LayerStackType id) NN_NOEXCEPT;
        nn::Result SetDisplayPowerState(nn::vi::DisplayId displayId, nn::vi::PowerStateType state) NN_NOEXCEPT;
        nn::Result SetDefaultDisplay(nn::vi::DisplayId id) NN_NOEXCEPT;
        nn::Result AddToLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT;
        nn::Result RemoveFromLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT;
        nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT;
        nn::Result SetLayerConfig(nn::vi::LayerId layerId, const nn::vi::LayerConfig& config) NN_NOEXCEPT;
        nn::Result AttachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result DetachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result StartLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result StopLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result StartLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result StopLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result GetLayerPresentationAllFencesExpiredEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;
        void SetContentVisibility(bool isVisible) NN_NOEXCEPT;
        nn::Result SetConductorLayer(nn::vi::LayerId layerId, bool isConductor) NN_NOEXCEPT;
        nn::Result SetIndirectProducerFlipOffset(nn::vi::IndirectLayerHandleType layerHandle, nn::vi::IndirectProducerHandleType producerHandle, nn::TimeSpan offset) NN_NOEXCEPT;
        nn::Result CreateSharedBufferStaticStorage(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t storageKey, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
        nn::Result CreateSharedBufferTransferMemory(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
        nn::Result DestroySharedBuffer(nn::vi::fbshare::SharedBufferHandle handle) NN_NOEXCEPT;
        nn::Result BindSharedLowLevelLayerToManagedLayer(nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result BindSharedLowLevelLayerToIndirectLayer(nn::vi::IndirectProducerHandleType handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result UnbindSharedLowLevelLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result ConnectSharedLowLevelLayerToSharedBuffer(nn::vi::LayerId layerId, nn::vi::fbshare::SharedBufferHandle hSharedBuffer) NN_NOEXCEPT;
        nn::Result DisconnectSharedLowLevelLayerFromSharedBuffer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result CreateSharedLayer(nn::sf::Out<nn::vi::fbshare::SharedLayerHandle> outLayerHandle, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT;
        nn::Result DestroySharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result AttachSharedLayerToLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerId layerId, const nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList) NN_NOEXCEPT;
        nn::Result ForceDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result StartDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result FinishDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result GetSharedLayerDetachReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result GetSharedLowLevelLayerSynchronizedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result CheckSharedLowLevelLayerSynchronized(nn::sf::Out<std::int64_t> outDisplayedIndex, nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result RegisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT;
        nn::Result UnregisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT;
        nn::Result CreateSharedBufferProcessHeap(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t blockId, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
        nn::Result GetSharedLayerLayerStacks(nn::sf::Out<nn::vi::LayerStackFlagType> outStacks, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result SetSharedLayerLayerStacks(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerStackFlagType stacks) NN_NOEXCEPT;
        nn::Result PresentDetachedSharedFrameBufferToLowLevelLayer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, nn::vi::LayerId layerId, std::int64_t index) NN_NOEXCEPT;
        nn::Result FillDetachedSharedFrameBufferColor(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::uint32_t color, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT;
        nn::Result GetDetachedSharedFrameBufferImage(nn::sf::Out<std::uint64_t> outDataSize, const nn::sf::OutBuffer& data, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT;
        nn::Result SetDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT;
        nn::Result CopyDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, std::int64_t dstIndex, nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, std::int64_t srcIndex, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::LayerStackFlagType maskStacks, nn::vi::LayerStackFlagType nullStacks) NN_NOEXCEPT;
        nn::Result SetDetachedSharedFrameBufferSubImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::int32_t x, std::int32_t y, std::int32_t w, std::int32_t h, std::uint32_t bgColor, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT;
        nn::Result GetSharedFrameBufferContentParameter(nn::sf::Out<nn::vi::LayerStackFlagType> outLayerStacks, nn::sf::Out<nn::vi::CropRegion> outCropRegion, nn::sf::Out<std::int32_t> outScalingMode, nn::sf::Out<std::uint32_t> outTransform, nn::sf::Out<std::int32_t> outPresentInterval, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT;
        nn::Result ExpandStartupLogoOnSharedFrameBuffer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t dstIndex, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result AllocateProcessHeapBlock(nn::sf::Out<std::uint64_t> outBlockId, std::uint64_t size) NN_NOEXCEPT;
    nn::Result FreeProcessHeapBlock(std::uint64_t blockId) NN_NOEXCEPT;
    nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result CreateManagedLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT;
    nn::Result DestroyManagedLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result CreateIndirectLayer(nn::sf::Out<nn::vi::IndirectLayerHandleType> outLayerHandle) NN_NOEXCEPT;
    nn::Result DestroyIndirectLayer(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;
    nn::Result CreateIndirectProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DestroyIndirectProducerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;
    nn::Result CreateIndirectConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DestroyIndirectConsumerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;
    nn::Result AcquireLayerTexturePresentingEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result ReleaseLayerTexturePresentingEvent(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result GetDisplayHotplugEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result GetDisplayModeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result GetDisplayHotplugState(nn::sf::Out<nn::vi::HotplugStateType> outState, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result GetCompositorErrorInfo(nn::sf::Out<nn::vi::CompositorError> outErrorInfo, nn::sf::Out<std::int32_t> outLength, std::int64_t errorId, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result GetDisplayErrorEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayAlpha(nn::vi::DisplayId displayId, float alpha) NN_NOEXCEPT;
    nn::Result SetDisplayLayerStack(nn::vi::DisplayId displayId, nn::vi::LayerStackType id) NN_NOEXCEPT;
    nn::Result SetDisplayPowerState(nn::vi::DisplayId displayId, nn::vi::PowerStateType state) NN_NOEXCEPT;
    nn::Result SetDefaultDisplay(nn::vi::DisplayId id) NN_NOEXCEPT;
    nn::Result AddToLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT;
    nn::Result RemoveFromLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT;
    nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT;
    nn::Result SetLayerConfig(nn::vi::LayerId layerId, const nn::vi::LayerConfig& config) NN_NOEXCEPT;
    nn::Result AttachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result DetachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result StartLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result StopLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result StartLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result StopLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result GetLayerPresentationAllFencesExpiredEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;
    void SetContentVisibility(bool isVisible) NN_NOEXCEPT;
    nn::Result SetConductorLayer(nn::vi::LayerId layerId, bool isConductor) NN_NOEXCEPT;
    nn::Result SetIndirectProducerFlipOffset(nn::vi::IndirectLayerHandleType layerHandle, nn::vi::IndirectProducerHandleType producerHandle, nn::TimeSpan offset) NN_NOEXCEPT;
    nn::Result CreateSharedBufferStaticStorage(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t storageKey, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
    nn::Result CreateSharedBufferTransferMemory(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
    nn::Result DestroySharedBuffer(nn::vi::fbshare::SharedBufferHandle handle) NN_NOEXCEPT;
    nn::Result BindSharedLowLevelLayerToManagedLayer(nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result BindSharedLowLevelLayerToIndirectLayer(nn::vi::IndirectProducerHandleType handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result UnbindSharedLowLevelLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result ConnectSharedLowLevelLayerToSharedBuffer(nn::vi::LayerId layerId, nn::vi::fbshare::SharedBufferHandle hSharedBuffer) NN_NOEXCEPT;
    nn::Result DisconnectSharedLowLevelLayerFromSharedBuffer(nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result CreateSharedLayer(nn::sf::Out<nn::vi::fbshare::SharedLayerHandle> outLayerHandle, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT;
    nn::Result DestroySharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
    nn::Result AttachSharedLayerToLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerId layerId, const nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList) NN_NOEXCEPT;
    nn::Result ForceDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
    nn::Result StartDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
    nn::Result FinishDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
    nn::Result GetSharedLayerDetachReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
    nn::Result GetSharedLowLevelLayerSynchronizedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result CheckSharedLowLevelLayerSynchronized(nn::sf::Out<std::int64_t> outDisplayedIndex, nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result RegisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT;
    nn::Result UnregisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT;
    nn::Result CreateSharedBufferProcessHeap(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t blockId, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
    nn::Result GetSharedLayerLayerStacks(nn::sf::Out<nn::vi::LayerStackFlagType> outStacks, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
    nn::Result SetSharedLayerLayerStacks(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerStackFlagType stacks) NN_NOEXCEPT;
    nn::Result PresentDetachedSharedFrameBufferToLowLevelLayer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, nn::vi::LayerId layerId, std::int64_t index) NN_NOEXCEPT;
    nn::Result FillDetachedSharedFrameBufferColor(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::uint32_t color, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT;
    nn::Result GetDetachedSharedFrameBufferImage(nn::sf::Out<std::uint64_t> outDataSize, const nn::sf::OutBuffer& data, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT;
    nn::Result SetDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT;
    nn::Result CopyDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, std::int64_t dstIndex, nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, std::int64_t srcIndex, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::LayerStackFlagType maskStacks, nn::vi::LayerStackFlagType nullStacks) NN_NOEXCEPT;
    nn::Result SetDetachedSharedFrameBufferSubImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::int32_t x, std::int32_t y, std::int32_t w, std::int32_t h, std::uint32_t bgColor, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT;
    nn::Result GetSharedFrameBufferContentParameter(nn::sf::Out<nn::vi::LayerStackFlagType> outLayerStacks, nn::sf::Out<nn::vi::CropRegion> outCropRegion, nn::sf::Out<std::int32_t> outScalingMode, nn::sf::Out<std::uint32_t> outTransform, nn::sf::Out<std::int32_t> outPresentInterval, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT;
    nn::Result ExpandStartupLogoOnSharedFrameBuffer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t dstIndex, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::visrv::sf::IManagerDisplayService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AllocateProcessHeapBlock, (::nn::sf::Out<::std::uint64_t> outBlockId, ::std::uint64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AllocateProcessHeapBlock, (outBlockId, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FreeProcessHeapBlock, (::std::uint64_t blockId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FreeProcessHeapBlock, (blockId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayResolution, (::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayResolution, (outWidth, outHeight, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateManagedLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings, ::nn::applet::AppletResourceUserId userAruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateManagedLayer, (outLayerId, displayId, settings, userAruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyManagedLayer, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyManagedLayer, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayer, (::nn::sf::Out<::nn::vi::IndirectLayerHandleType> outLayerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateIndirectLayer, (outLayerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayer, (::nn::vi::IndirectLayerHandleType layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyIndirectLayer, (layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectProducerEndPoint, (::nn::sf::Out<::nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, ::nn::vi::IndirectLayerHandleType layerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateIndirectProducerEndPoint, (outProducerEndPointHandle, layerHandle, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectProducerEndPoint, (::nn::vi::IndirectLayerHandleType layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyIndirectProducerEndPoint, (layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectConsumerEndPoint, (::nn::sf::Out<::nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, ::nn::vi::IndirectLayerHandleType layerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateIndirectConsumerEndPoint, (outConsumerEndPointHandle, layerHandle, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectConsumerEndPoint, (::nn::vi::IndirectLayerHandleType layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyIndirectConsumerEndPoint, (layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireLayerTexturePresentingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireLayerTexturePresentingEvent, (outHandle, layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseLayerTexturePresentingEvent, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReleaseLayerTexturePresentingEvent, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayHotplugEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayHotplugEvent, (outHandle, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayModeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayModeChangedEvent, (outHandle, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayHotplugState, (::nn::sf::Out<::nn::vi::HotplugStateType> outState, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayHotplugState, (outState, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCompositorErrorInfo, (::nn::sf::Out<::nn::vi::CompositorError> outErrorInfo, ::nn::sf::Out<::std::int32_t> outLength, ::std::int64_t errorId, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCompositorErrorInfo, (outErrorInfo, outLength, errorId, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayErrorEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayErrorEvent, (outHandle, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayAlpha, (::nn::vi::DisplayId displayId, float alpha))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayAlpha, (displayId, alpha));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayLayerStack, (::nn::vi::DisplayId displayId, ::nn::vi::LayerStackType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayLayerStack, (displayId, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayPowerState, (::nn::vi::DisplayId displayId, ::nn::vi::PowerStateType state))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayPowerState, (displayId, state));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultDisplay, (::nn::vi::DisplayId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDefaultDisplay, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddToLayerStack, (::nn::vi::LayerId layerId, ::nn::vi::LayerStackType stackId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddToLayerStack, (layerId, stackId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveFromLayerStack, (::nn::vi::LayerId layerId, ::nn::vi::LayerStackType stackId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RemoveFromLayerStack, (layerId, stackId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerVisibility, (::nn::vi::LayerId layerId, bool isVisible))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLayerVisibility, (layerId, isVisible));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerConfig, (::nn::vi::LayerId layerId, const ::nn::vi::LayerConfig& config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLayerConfig, (layerId, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachLayerPresentationTracer, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AttachLayerPresentationTracer, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DetachLayerPresentationTracer, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DetachLayerPresentationTracer, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartLayerPresentationRecording, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartLayerPresentationRecording, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopLayerPresentationRecording, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopLayerPresentationRecording, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartLayerPresentationFenceWait, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartLayerPresentationFenceWait, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopLayerPresentationFenceWait, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopLayerPresentationFenceWait, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLayerPresentationAllFencesExpiredEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLayerPresentationAllFencesExpiredEvent, (outHandle, layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetContentVisibility, (bool isVisible))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SetContentVisibility, (isVisible));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetConductorLayer, (::nn::vi::LayerId layerId, bool isConductor))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetConductorLayer, (layerId, isConductor));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIndirectProducerFlipOffset, (::nn::vi::IndirectLayerHandleType layerHandle, ::nn::vi::IndirectProducerHandleType producerHandle, ::nn::TimeSpan offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetIndirectProducerFlipOffset, (layerHandle, producerHandle, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferStaticStorage, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::std::uint64_t storageKey, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSharedBufferStaticStorage, (outHandle, storageKey, layout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferTransferMemory, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSharedBufferTransferMemory, (outHandle, ::std::move(transferMemoryHandle), transferMemorySize, layout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroySharedBuffer, (::nn::vi::fbshare::SharedBufferHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroySharedBuffer, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindSharedLowLevelLayerToManagedLayer, (::nn::vi::LayerId layerId, const ::nn::vi::DisplayName& displayName, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BindSharedLowLevelLayerToManagedLayer, (layerId, displayName, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindSharedLowLevelLayerToIndirectLayer, (::nn::vi::IndirectProducerHandleType handle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BindSharedLowLevelLayerToIndirectLayer, (handle, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnbindSharedLowLevelLayer, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnbindSharedLowLevelLayer, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConnectSharedLowLevelLayerToSharedBuffer, (::nn::vi::LayerId layerId, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConnectSharedLowLevelLayerToSharedBuffer, (layerId, hSharedBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectSharedLowLevelLayerFromSharedBuffer, (::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DisconnectSharedLowLevelLayerFromSharedBuffer, (layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedLayer, (::nn::sf::Out<::nn::vi::fbshare::SharedLayerHandle> outLayerHandle, ::nn::applet::AppletResourceUserId userAruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSharedLayer, (outLayerHandle, userAruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroySharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroySharedLayer, (hLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachSharedLayerToLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer, ::nn::vi::LayerId layerId, const ::nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AttachSharedLayerToLowLevelLayer, (hSharedLayer, layerId, frameBufferIndexList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ForceDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ForceDetachSharedLayerFromLowLevelLayer, (hSharedLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartDetachSharedLayerFromLowLevelLayer, (hSharedLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishDetachSharedLayerFromLowLevelLayer, (hSharedLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLayerDetachReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedLayerDetachReadyEvent, (outHandle, hSharedLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLowLevelLayerSynchronizedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedLowLevelLayerSynchronizedEvent, (outHandle, layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckSharedLowLevelLayerSynchronized, (::nn::sf::Out<::std::int64_t> outDisplayedIndex, ::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckSharedLowLevelLayerSynchronized, (outDisplayedIndex, layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSharedBufferImporterAruid, (::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId importerAruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterSharedBufferImporterAruid, (hBuffer, importerAruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterSharedBufferImporterAruid, (::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId importerAruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterSharedBufferImporterAruid, (hBuffer, importerAruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferProcessHeap, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::std::uint64_t blockId, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSharedBufferProcessHeap, (outHandle, blockId, layout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLayerLayerStacks, (::nn::sf::Out<::nn::vi::LayerStackFlagType> outStacks, ::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedLayerLayerStacks, (outStacks, hSharedLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSharedLayerLayerStacks, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer, ::nn::vi::LayerStackFlagType stacks))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSharedLayerLayerStacks, (hSharedLayer, stacks));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PresentDetachedSharedFrameBufferToLowLevelLayer, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::nn::vi::LayerId layerId, ::std::int64_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PresentDetachedSharedFrameBufferToLowLevelLayer, (hSharedBuffer, layerId, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FillDetachedSharedFrameBufferColor, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, ::std::uint32_t color, const ::nn::vi::fbshare::SharedTextureOption& option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FillDetachedSharedFrameBufferColor, (hSharedBuffer, index, color, option));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDetachedSharedFrameBufferImage, (::nn::sf::Out<::std::uint64_t> outDataSize, const ::nn::sf::OutBuffer& data, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDetachedSharedFrameBufferImage, (outDataSize, data, hSharedBuffer, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDetachedSharedFrameBufferImage, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, const ::nn::sf::InBuffer& data, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::ImageTransformType srcTransform))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDetachedSharedFrameBufferImage, (hSharedBuffer, index, data, dstOption, srcTransform));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CopyDetachedSharedFrameBufferImage, (::nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, ::std::int64_t dstIndex, ::nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, ::std::int64_t srcIndex, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::LayerStackFlagType maskStacks, ::nn::vi::LayerStackFlagType nullStacks))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CopyDetachedSharedFrameBufferImage, (hDstSharedBuffer, dstIndex, hSrcSharedBuffer, srcIndex, dstOption, maskStacks, nullStacks));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDetachedSharedFrameBufferSubImage, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, ::std::int32_t x, ::std::int32_t y, ::std::int32_t w, ::std::int32_t h, ::std::uint32_t bgColor, const ::nn::sf::InBuffer& data, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::ImageTransformType srcTransform))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDetachedSharedFrameBufferSubImage, (hSharedBuffer, index, x, y, w, h, bgColor, data, dstOption, srcTransform));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFrameBufferContentParameter, (::nn::sf::Out<::nn::vi::LayerStackFlagType> outLayerStacks, ::nn::sf::Out<::nn::vi::CropRegion> outCropRegion, ::nn::sf::Out<::std::int32_t> outScalingMode, ::nn::sf::Out<::std::uint32_t> outTransform, ::nn::sf::Out<::std::int32_t> outPresentInterval, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedFrameBufferContentParameter, (outLayerStacks, outCropRegion, outScalingMode, outTransform, outPresentInterval, hSharedBuffer, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExpandStartupLogoOnSharedFrameBuffer, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t dstIndex, const ::nn::vi::fbshare::SharedTextureOption& option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExpandStartupLogoOnSharedFrameBuffer, (hSharedBuffer, dstIndex, option));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::visrv::sf::IManagerDisplayService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::visrv::sf::IManagerDisplayService))

    // nn::Result AllocateProcessHeapBlock(nn::sf::Out<std::uint64_t> outBlockId, std::uint64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AllocateProcessHeapBlock)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outBlockId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outBlockId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBlockId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AllocateProcessHeapBlock)

    // nn::Result FreeProcessHeapBlock(std::uint64_t blockId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FreeProcessHeapBlock)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(blockId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (blockId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FreeProcessHeapBlock)

    // nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayResolution)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayResolution)

    // nn::Result CreateManagedLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateManagedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(settings, (::nn::vi::LayerSettingsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(userAruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (settings, displayId, userAruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLayerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outLayerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLayerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(settings), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userAruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateManagedLayer)

    // nn::Result DestroyManagedLayer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyManagedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyManagedLayer)

    // nn::Result CreateIndirectLayer(nn::sf::Out<nn::vi::IndirectLayerHandleType> outLayerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateIndirectLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2050)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLayerHandle, (::nn::vi::IndirectLayerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outLayerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLayerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateIndirectLayer)

    // nn::Result DestroyIndirectLayer(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyIndirectLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2051)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::nn::vi::IndirectLayerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyIndirectLayer)

    // nn::Result CreateIndirectProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateIndirectProducerEndPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2052)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::nn::vi::IndirectLayerHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (layerHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outProducerEndPointHandle, (::nn::vi::IndirectProducerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outProducerEndPointHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProducerEndPointHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateIndirectProducerEndPoint)

    // nn::Result DestroyIndirectProducerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyIndirectProducerEndPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2053)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::nn::vi::IndirectLayerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyIndirectProducerEndPoint)

    // nn::Result CreateIndirectConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateIndirectConsumerEndPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2054)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::nn::vi::IndirectLayerHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (layerHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outConsumerEndPointHandle, (::nn::vi::IndirectConsumerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outConsumerEndPointHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outConsumerEndPointHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateIndirectConsumerEndPoint)

    // nn::Result DestroyIndirectConsumerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyIndirectConsumerEndPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2055)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::nn::vi::IndirectLayerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyIndirectConsumerEndPoint)

    // nn::Result AcquireLayerTexturePresentingEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireLayerTexturePresentingEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireLayerTexturePresentingEvent)

    // nn::Result ReleaseLayerTexturePresentingEvent(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReleaseLayerTexturePresentingEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReleaseLayerTexturePresentingEvent)

    // nn::Result GetDisplayHotplugEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayHotplugEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayHotplugEvent)

    // nn::Result GetDisplayModeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayModeChangedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2303)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayModeChangedEvent)

    // nn::Result GetDisplayHotplugState(nn::sf::Out<nn::vi::HotplugStateType> outState, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayHotplugState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outState, (::nn::vi::HotplugStateType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayHotplugState)

    // nn::Result GetCompositorErrorInfo(nn::sf::Out<nn::vi::CompositorError> outErrorInfo, nn::sf::Out<std::int32_t> outLength, std::int64_t errorId, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCompositorErrorInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outErrorInfo, 0, (::nn::sf::Out<::nn::vi::CompositorError>), 4096, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outErrorInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(errorId, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (errorId, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLength, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outErrorInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(errorId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCompositorErrorInfo)

    // nn::Result GetDisplayErrorEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayErrorEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2601)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayErrorEvent)

    // nn::Result SetDisplayAlpha(nn::vi::DisplayId displayId, float alpha) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayAlpha)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(alpha, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (alpha, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(alpha)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayAlpha)

    // nn::Result SetDisplayLayerStack(nn::vi::DisplayId displayId, nn::vi::LayerStackType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayLayerStack)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::vi::LayerStackType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayLayerStack)

    // nn::Result SetDisplayPowerState(nn::vi::DisplayId displayId, nn::vi::PowerStateType state) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayPowerState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(state, (::nn::vi::PowerStateType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (state, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayPowerState)

    // nn::Result SetDefaultDisplay(nn::vi::DisplayId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDefaultDisplay)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDefaultDisplay)

    // nn::Result AddToLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddToLayerStack)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(stackId, (::nn::vi::LayerStackType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (stackId, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stackId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddToLayerStack)

    // nn::Result RemoveFromLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveFromLayerStack)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(stackId, (::nn::vi::LayerStackType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (stackId, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stackId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveFromLayerStack)

    // nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLayerVisibility)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isVisible, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isVisible, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isVisible)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLayerVisibility)

    // nn::Result SetLayerConfig(nn::vi::LayerId layerId, const nn::vi::LayerConfig& config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLayerConfig)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::vi::LayerConfig), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (config, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLayerConfig)

    // nn::Result AttachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AttachLayerPresentationTracer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AttachLayerPresentationTracer)

    // nn::Result DetachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DetachLayerPresentationTracer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6005)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DetachLayerPresentationTracer)

    // nn::Result StartLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartLayerPresentationRecording)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6006)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartLayerPresentationRecording)

    // nn::Result StopLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopLayerPresentationRecording)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6007)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopLayerPresentationRecording)

    // nn::Result StartLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartLayerPresentationFenceWait)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6008)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartLayerPresentationFenceWait)

    // nn::Result StopLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopLayerPresentationFenceWait)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6009)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopLayerPresentationFenceWait)

    // nn::Result GetLayerPresentationAllFencesExpiredEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLayerPresentationAllFencesExpiredEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLayerPresentationAllFencesExpiredEvent)

    // void SetContentVisibility(bool isVisible) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetContentVisibility)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isVisible, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isVisible))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isVisible)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetContentVisibility)

    // nn::Result SetConductorLayer(nn::vi::LayerId layerId, bool isConductor) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetConductorLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isConductor, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isConductor, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isConductor)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetConductorLayer)

    // nn::Result SetIndirectProducerFlipOffset(nn::vi::IndirectLayerHandleType layerHandle, nn::vi::IndirectProducerHandleType producerHandle, nn::TimeSpan offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetIndirectProducerFlipOffset)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::nn::vi::IndirectLayerHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(producerHandle, (::nn::vi::IndirectProducerHandleType), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::nn::TimeSpan), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (layerHandle, producerHandle, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(producerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetIndirectProducerFlipOffset)

    // nn::Result CreateSharedBufferStaticStorage(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t storageKey, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSharedBufferStaticStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(layout, 0, (const ::nn::vi::fbshare::SharedMemoryPoolLayout&), 392, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (layout))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageKey, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::vi::fbshare::SharedBufferHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSharedBufferStaticStorage)

    // nn::Result CreateSharedBufferTransferMemory(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSharedBufferTransferMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(layout, 0, (const ::nn::vi::fbshare::SharedMemoryPoolLayout&), 392, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (layout))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transferMemorySize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (transferMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::vi::fbshare::SharedBufferHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemorySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSharedBufferTransferMemory)

    // nn::Result DestroySharedBuffer(nn::vi::fbshare::SharedBufferHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroySharedBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::vi::fbshare::SharedBufferHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroySharedBuffer)

    // nn::Result BindSharedLowLevelLayerToManagedLayer(nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BindSharedLowLevelLayerToManagedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayName, (::nn::vi::DisplayName), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (displayName, layerId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BindSharedLowLevelLayerToManagedLayer)

    // nn::Result BindSharedLowLevelLayerToIndirectLayer(nn::vi::IndirectProducerHandleType handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BindSharedLowLevelLayerToIndirectLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::vi::IndirectProducerHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BindSharedLowLevelLayerToIndirectLayer)

    // nn::Result UnbindSharedLowLevelLayer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnbindSharedLowLevelLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnbindSharedLowLevelLayer)

    // nn::Result ConnectSharedLowLevelLayerToSharedBuffer(nn::vi::LayerId layerId, nn::vi::fbshare::SharedBufferHandle hSharedBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConnectSharedLowLevelLayerToSharedBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8208)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (layerId, hSharedBuffer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConnectSharedLowLevelLayerToSharedBuffer)

    // nn::Result DisconnectSharedLowLevelLayerFromSharedBuffer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisconnectSharedLowLevelLayerFromSharedBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8209)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisconnectSharedLowLevelLayerFromSharedBuffer)

    // nn::Result CreateSharedLayer(nn::sf::Out<nn::vi::fbshare::SharedLayerHandle> outLayerHandle, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSharedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(userAruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (userAruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLayerHandle, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outLayerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLayerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userAruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSharedLayer)

    // nn::Result DestroySharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroySharedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8211)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroySharedLayer)

    // nn::Result AttachSharedLayerToLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerId layerId, const nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AttachSharedLayerToLowLevelLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8216)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(frameBufferIndexList, (::nn::vi::fbshare::SharedLayerTextureIndexList), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedLayer, (::nn::vi::fbshare::SharedLayerHandle), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (frameBufferIndexList, hSharedLayer, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedLayer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(frameBufferIndexList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AttachSharedLayerToLowLevelLayer)

    // nn::Result ForceDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ForceDetachSharedLayerFromLowLevelLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8217)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hSharedLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ForceDetachSharedLayerFromLowLevelLayer)

    // nn::Result StartDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartDetachSharedLayerFromLowLevelLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8218)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hSharedLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartDetachSharedLayerFromLowLevelLayer)

    // nn::Result FinishDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishDetachSharedLayerFromLowLevelLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8219)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hSharedLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishDetachSharedLayerFromLowLevelLayer)

    // nn::Result GetSharedLayerDetachReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedLayerDetachReadyEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8220)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hSharedLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedLayerDetachReadyEvent)

    // nn::Result GetSharedLowLevelLayerSynchronizedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedLowLevelLayerSynchronizedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8221)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedLowLevelLayerSynchronizedEvent)

    // nn::Result CheckSharedLowLevelLayerSynchronized(nn::sf::Out<std::int64_t> outDisplayedIndex, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckSharedLowLevelLayerSynchronized)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8222)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outDisplayedIndex, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outDisplayedIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDisplayedIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckSharedLowLevelLayerSynchronized)

    // nn::Result RegisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterSharedBufferImporterAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8223)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hBuffer, (::nn::vi::fbshare::SharedBufferHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(importerAruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (hBuffer, importerAruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(importerAruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterSharedBufferImporterAruid)

    // nn::Result UnregisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterSharedBufferImporterAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8224)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hBuffer, (::nn::vi::fbshare::SharedBufferHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(importerAruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (hBuffer, importerAruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(importerAruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterSharedBufferImporterAruid)

    // nn::Result CreateSharedBufferProcessHeap(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t blockId, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSharedBufferProcessHeap)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8227)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(layout, 0, (const ::nn::vi::fbshare::SharedMemoryPoolLayout&), 392, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (layout))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(blockId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (blockId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::vi::fbshare::SharedBufferHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSharedBufferProcessHeap)

    // nn::Result GetSharedLayerLayerStacks(nn::sf::Out<nn::vi::LayerStackFlagType> outStacks, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedLayerLayerStacks)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8228)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hSharedLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStacks, (::nn::vi::LayerStackFlagType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outStacks))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStacks), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedLayerLayerStacks)

    // nn::Result SetSharedLayerLayerStacks(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerStackFlagType stacks) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSharedLayerLayerStacks)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8229)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(stacks, (::nn::vi::LayerStackFlagType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedLayer, (::nn::vi::fbshare::SharedLayerHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (stacks, hSharedLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedLayer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stacks)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSharedLayerLayerStacks)

    // nn::Result PresentDetachedSharedFrameBufferToLowLevelLayer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, nn::vi::LayerId layerId, std::int64_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PresentDetachedSharedFrameBufferToLowLevelLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8291)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (hSharedBuffer, layerId, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PresentDetachedSharedFrameBufferToLowLevelLayer)

    // nn::Result FillDetachedSharedFrameBufferColor(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::uint32_t color, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FillDetachedSharedFrameBufferColor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8292)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(color, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::vi::fbshare::SharedTextureOption), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (color, option, hSharedBuffer, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(color), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FillDetachedSharedFrameBufferColor)

    // nn::Result GetDetachedSharedFrameBufferImage(nn::sf::Out<std::uint64_t> outDataSize, const nn::sf::OutBuffer& data, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDetachedSharedFrameBufferImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8293)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (hSharedBuffer, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outDataSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outDataSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDataSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDetachedSharedFrameBufferImage)

    // nn::Result SetDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDetachedSharedFrameBufferImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8294)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstOption, (::nn::vi::fbshare::SharedTextureOption), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcTransform, (::nn::vi::ImageTransformType), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (dstOption, srcTransform, hSharedBuffer, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstOption), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcTransform)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDetachedSharedFrameBufferImage)

    // nn::Result CopyDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, std::int64_t dstIndex, nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, std::int64_t srcIndex, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::LayerStackFlagType maskStacks, nn::vi::LayerStackFlagType nullStacks) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CopyDetachedSharedFrameBufferImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8295)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstOption, (::nn::vi::fbshare::SharedTextureOption), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maskStacks, (::nn::vi::LayerStackFlagType), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(nullStacks, (::nn::vi::LayerStackFlagType), 20)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hDstSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstIndex, (::std::int64_t), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSrcSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 40)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcIndex, (::std::int64_t), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(7, (dstOption, maskStacks, nullStacks, hDstSharedBuffer, dstIndex, hSrcSharedBuffer, srcIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hDstSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSrcSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstOption), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maskStacks), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nullStacks)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CopyDetachedSharedFrameBufferImage)

    // nn::Result SetDetachedSharedFrameBufferSubImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::int32_t x, std::int32_t y, std::int32_t w, std::int32_t h, std::uint32_t bgColor, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDetachedSharedFrameBufferSubImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8296)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(y, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(w, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(h, (::std::int32_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bgColor, (::std::uint32_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstOption, (::nn::vi::fbshare::SharedTextureOption), 20)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcTransform, (::nn::vi::ImageTransformType), 36)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 40)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(9, (x, y, w, h, bgColor, dstOption, srcTransform, hSharedBuffer, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(y), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(w), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(h), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bgColor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstOption), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcTransform)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDetachedSharedFrameBufferSubImage)

    // nn::Result GetSharedFrameBufferContentParameter(nn::sf::Out<nn::vi::LayerStackFlagType> outLayerStacks, nn::sf::Out<nn::vi::CropRegion> outCropRegion, nn::sf::Out<std::int32_t> outScalingMode, nn::sf::Out<std::uint32_t> outTransform, nn::sf::Out<std::int32_t> outPresentInterval, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedFrameBufferContentParameter)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8297)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (hSharedBuffer, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLayerStacks, (::nn::vi::LayerStackFlagType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCropRegion, (::nn::vi::CropRegion), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outScalingMode, (::std::int32_t), 20)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTransform, (::std::uint32_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outPresentInterval, (::std::int32_t), 28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(5, (outLayerStacks, outCropRegion, outScalingMode, outTransform, outPresentInterval))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLayerStacks), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCropRegion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outScalingMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTransform), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPresentInterval), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedFrameBufferContentParameter)

    // nn::Result ExpandStartupLogoOnSharedFrameBuffer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t dstIndex, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExpandStartupLogoOnSharedFrameBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8298)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::vi::fbshare::SharedTextureOption), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hSharedBuffer, (::nn::vi::fbshare::SharedBufferHandle), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstIndex, (::std::int64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (option, hSharedBuffer, dstIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hSharedBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExpandStartupLogoOnSharedFrameBuffer)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::DisplayId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerSettingsType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::IndirectLayerHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::IndirectProducerHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::IndirectConsumerHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::HotplugStateType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerStackType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::PowerStateType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerConfig), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpan), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedBufferHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedMemoryPoolLayout), 392, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::DisplayName), 64, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedLayerHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedLayerTextureIndexList), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerStackFlagType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedTextureOption), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::ImageTransformType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::CropRegion), 16, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::visrv::sf::IManagerDisplayService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::visrv::sf::IManagerDisplayService))

    // nn::Result AllocateProcessHeapBlock(nn::sf::Out<std::uint64_t> outBlockId, std::uint64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AllocateProcessHeapBlock, (::nn::sf::Out<::std::uint64_t> outBlockId, ::std::uint64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AllocateProcessHeapBlock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBlockId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AllocateProcessHeapBlock)
    }

    // nn::Result FreeProcessHeapBlock(std::uint64_t blockId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FreeProcessHeapBlock, (::std::uint64_t blockId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FreeProcessHeapBlock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FreeProcessHeapBlock)
    }

    // nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayResolution, (::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayResolution)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayResolution)
    }

    // nn::Result CreateManagedLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateManagedLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings, ::nn::applet::AppletResourceUserId userAruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateManagedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLayerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(settings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userAruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateManagedLayer)
    }

    // nn::Result DestroyManagedLayer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyManagedLayer, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyManagedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyManagedLayer)
    }

    // nn::Result CreateIndirectLayer(nn::sf::Out<nn::vi::IndirectLayerHandleType> outLayerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayer, (::nn::sf::Out<::nn::vi::IndirectLayerHandleType> outLayerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateIndirectLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLayerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateIndirectLayer)
    }

    // nn::Result DestroyIndirectLayer(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayer, (::nn::vi::IndirectLayerHandleType layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyIndirectLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyIndirectLayer)
    }

    // nn::Result CreateIndirectProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectProducerEndPoint, (::nn::sf::Out<::nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, ::nn::vi::IndirectLayerHandleType layerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateIndirectProducerEndPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProducerEndPointHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateIndirectProducerEndPoint)
    }

    // nn::Result DestroyIndirectProducerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectProducerEndPoint, (::nn::vi::IndirectLayerHandleType layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyIndirectProducerEndPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyIndirectProducerEndPoint)
    }

    // nn::Result CreateIndirectConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectConsumerEndPoint, (::nn::sf::Out<::nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, ::nn::vi::IndirectLayerHandleType layerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateIndirectConsumerEndPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outConsumerEndPointHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateIndirectConsumerEndPoint)
    }

    // nn::Result DestroyIndirectConsumerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectConsumerEndPoint, (::nn::vi::IndirectLayerHandleType layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyIndirectConsumerEndPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyIndirectConsumerEndPoint)
    }

    // nn::Result AcquireLayerTexturePresentingEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireLayerTexturePresentingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireLayerTexturePresentingEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireLayerTexturePresentingEvent)
    }

    // nn::Result ReleaseLayerTexturePresentingEvent(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseLayerTexturePresentingEvent, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReleaseLayerTexturePresentingEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReleaseLayerTexturePresentingEvent)
    }

    // nn::Result GetDisplayHotplugEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayHotplugEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayHotplugEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayHotplugEvent)
    }

    // nn::Result GetDisplayModeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayModeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayModeChangedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayModeChangedEvent)
    }

    // nn::Result GetDisplayHotplugState(nn::sf::Out<nn::vi::HotplugStateType> outState, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayHotplugState, (::nn::sf::Out<::nn::vi::HotplugStateType> outState, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayHotplugState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayHotplugState)
    }

    // nn::Result GetCompositorErrorInfo(nn::sf::Out<nn::vi::CompositorError> outErrorInfo, nn::sf::Out<std::int32_t> outLength, std::int64_t errorId, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCompositorErrorInfo, (::nn::sf::Out<::nn::vi::CompositorError> outErrorInfo, ::nn::sf::Out<::std::int32_t> outLength, ::std::int64_t errorId, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCompositorErrorInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outErrorInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(errorId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCompositorErrorInfo)
    }

    // nn::Result GetDisplayErrorEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayErrorEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayErrorEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayErrorEvent)
    }

    // nn::Result SetDisplayAlpha(nn::vi::DisplayId displayId, float alpha) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayAlpha, (::nn::vi::DisplayId displayId, float alpha))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayAlpha)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(alpha)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayAlpha)
    }

    // nn::Result SetDisplayLayerStack(nn::vi::DisplayId displayId, nn::vi::LayerStackType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayLayerStack, (::nn::vi::DisplayId displayId, ::nn::vi::LayerStackType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayLayerStack)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayLayerStack)
    }

    // nn::Result SetDisplayPowerState(nn::vi::DisplayId displayId, nn::vi::PowerStateType state) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayPowerState, (::nn::vi::DisplayId displayId, ::nn::vi::PowerStateType state))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayPowerState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayPowerState)
    }

    // nn::Result SetDefaultDisplay(nn::vi::DisplayId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultDisplay, (::nn::vi::DisplayId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDefaultDisplay)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDefaultDisplay)
    }

    // nn::Result AddToLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddToLayerStack, (::nn::vi::LayerId layerId, ::nn::vi::LayerStackType stackId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddToLayerStack)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stackId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddToLayerStack)
    }

    // nn::Result RemoveFromLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveFromLayerStack, (::nn::vi::LayerId layerId, ::nn::vi::LayerStackType stackId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveFromLayerStack)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stackId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveFromLayerStack)
    }

    // nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerVisibility, (::nn::vi::LayerId layerId, bool isVisible))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLayerVisibility)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isVisible)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLayerVisibility)
    }

    // nn::Result SetLayerConfig(nn::vi::LayerId layerId, const nn::vi::LayerConfig& config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerConfig, (::nn::vi::LayerId layerId, const ::nn::vi::LayerConfig& config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLayerConfig)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLayerConfig)
    }

    // nn::Result AttachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachLayerPresentationTracer, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AttachLayerPresentationTracer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AttachLayerPresentationTracer)
    }

    // nn::Result DetachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DetachLayerPresentationTracer, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DetachLayerPresentationTracer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DetachLayerPresentationTracer)
    }

    // nn::Result StartLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartLayerPresentationRecording, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartLayerPresentationRecording)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartLayerPresentationRecording)
    }

    // nn::Result StopLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopLayerPresentationRecording, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopLayerPresentationRecording)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopLayerPresentationRecording)
    }

    // nn::Result StartLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartLayerPresentationFenceWait, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartLayerPresentationFenceWait)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartLayerPresentationFenceWait)
    }

    // nn::Result StopLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopLayerPresentationFenceWait, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopLayerPresentationFenceWait)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopLayerPresentationFenceWait)
    }

    // nn::Result GetLayerPresentationAllFencesExpiredEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLayerPresentationAllFencesExpiredEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLayerPresentationAllFencesExpiredEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLayerPresentationAllFencesExpiredEvent)
    }

    // void SetContentVisibility(bool isVisible) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetContentVisibility, (bool isVisible))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetContentVisibility)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isVisible)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetContentVisibility)
    }

    // nn::Result SetConductorLayer(nn::vi::LayerId layerId, bool isConductor) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetConductorLayer, (::nn::vi::LayerId layerId, bool isConductor))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetConductorLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isConductor)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetConductorLayer)
    }

    // nn::Result SetIndirectProducerFlipOffset(nn::vi::IndirectLayerHandleType layerHandle, nn::vi::IndirectProducerHandleType producerHandle, nn::TimeSpan offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIndirectProducerFlipOffset, (::nn::vi::IndirectLayerHandleType layerHandle, ::nn::vi::IndirectProducerHandleType producerHandle, ::nn::TimeSpan offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetIndirectProducerFlipOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(producerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetIndirectProducerFlipOffset)
    }

    // nn::Result CreateSharedBufferStaticStorage(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t storageKey, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferStaticStorage, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::std::uint64_t storageKey, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSharedBufferStaticStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSharedBufferStaticStorage)
    }

    // nn::Result CreateSharedBufferTransferMemory(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferTransferMemory, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSharedBufferTransferMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemorySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSharedBufferTransferMemory)
    }

    // nn::Result DestroySharedBuffer(nn::vi::fbshare::SharedBufferHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroySharedBuffer, (::nn::vi::fbshare::SharedBufferHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroySharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroySharedBuffer)
    }

    // nn::Result BindSharedLowLevelLayerToManagedLayer(nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindSharedLowLevelLayerToManagedLayer, (::nn::vi::LayerId layerId, const ::nn::vi::DisplayName& displayName, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BindSharedLowLevelLayerToManagedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BindSharedLowLevelLayerToManagedLayer)
    }

    // nn::Result BindSharedLowLevelLayerToIndirectLayer(nn::vi::IndirectProducerHandleType handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindSharedLowLevelLayerToIndirectLayer, (::nn::vi::IndirectProducerHandleType handle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BindSharedLowLevelLayerToIndirectLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BindSharedLowLevelLayerToIndirectLayer)
    }

    // nn::Result UnbindSharedLowLevelLayer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnbindSharedLowLevelLayer, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnbindSharedLowLevelLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnbindSharedLowLevelLayer)
    }

    // nn::Result ConnectSharedLowLevelLayerToSharedBuffer(nn::vi::LayerId layerId, nn::vi::fbshare::SharedBufferHandle hSharedBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConnectSharedLowLevelLayerToSharedBuffer, (::nn::vi::LayerId layerId, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConnectSharedLowLevelLayerToSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConnectSharedLowLevelLayerToSharedBuffer)
    }

    // nn::Result DisconnectSharedLowLevelLayerFromSharedBuffer(nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectSharedLowLevelLayerFromSharedBuffer, (::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisconnectSharedLowLevelLayerFromSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisconnectSharedLowLevelLayerFromSharedBuffer)
    }

    // nn::Result CreateSharedLayer(nn::sf::Out<nn::vi::fbshare::SharedLayerHandle> outLayerHandle, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedLayer, (::nn::sf::Out<::nn::vi::fbshare::SharedLayerHandle> outLayerHandle, ::nn::applet::AppletResourceUserId userAruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSharedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLayerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userAruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSharedLayer)
    }

    // nn::Result DestroySharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroySharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroySharedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroySharedLayer)
    }

    // nn::Result AttachSharedLayerToLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerId layerId, const nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachSharedLayerToLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer, ::nn::vi::LayerId layerId, const ::nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AttachSharedLayerToLowLevelLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(frameBufferIndexList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AttachSharedLayerToLowLevelLayer)
    }

    // nn::Result ForceDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ForceDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ForceDetachSharedLayerFromLowLevelLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ForceDetachSharedLayerFromLowLevelLayer)
    }

    // nn::Result StartDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartDetachSharedLayerFromLowLevelLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartDetachSharedLayerFromLowLevelLayer)
    }

    // nn::Result FinishDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishDetachSharedLayerFromLowLevelLayer, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishDetachSharedLayerFromLowLevelLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishDetachSharedLayerFromLowLevelLayer)
    }

    // nn::Result GetSharedLayerDetachReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLayerDetachReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedLayerDetachReadyEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedLayerDetachReadyEvent)
    }

    // nn::Result GetSharedLowLevelLayerSynchronizedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLowLevelLayerSynchronizedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedLowLevelLayerSynchronizedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedLowLevelLayerSynchronizedEvent)
    }

    // nn::Result CheckSharedLowLevelLayerSynchronized(nn::sf::Out<std::int64_t> outDisplayedIndex, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckSharedLowLevelLayerSynchronized, (::nn::sf::Out<::std::int64_t> outDisplayedIndex, ::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckSharedLowLevelLayerSynchronized)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDisplayedIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckSharedLowLevelLayerSynchronized)
    }

    // nn::Result RegisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSharedBufferImporterAruid, (::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId importerAruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterSharedBufferImporterAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(importerAruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterSharedBufferImporterAruid)
    }

    // nn::Result UnregisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterSharedBufferImporterAruid, (::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId importerAruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterSharedBufferImporterAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(importerAruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterSharedBufferImporterAruid)
    }

    // nn::Result CreateSharedBufferProcessHeap(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t blockId, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSharedBufferProcessHeap, (::nn::sf::Out<::nn::vi::fbshare::SharedBufferHandle> outHandle, ::std::uint64_t blockId, const ::nn::vi::fbshare::SharedMemoryPoolLayout& layout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSharedBufferProcessHeap)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSharedBufferProcessHeap)
    }

    // nn::Result GetSharedLayerLayerStacks(nn::sf::Out<nn::vi::LayerStackFlagType> outStacks, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedLayerLayerStacks, (::nn::sf::Out<::nn::vi::LayerStackFlagType> outStacks, ::nn::vi::fbshare::SharedLayerHandle hSharedLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedLayerLayerStacks)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStacks)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedLayerLayerStacks)
    }

    // nn::Result SetSharedLayerLayerStacks(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerStackFlagType stacks) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSharedLayerLayerStacks, (::nn::vi::fbshare::SharedLayerHandle hSharedLayer, ::nn::vi::LayerStackFlagType stacks))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSharedLayerLayerStacks)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stacks)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSharedLayerLayerStacks)
    }

    // nn::Result PresentDetachedSharedFrameBufferToLowLevelLayer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, nn::vi::LayerId layerId, std::int64_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PresentDetachedSharedFrameBufferToLowLevelLayer, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::nn::vi::LayerId layerId, ::std::int64_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PresentDetachedSharedFrameBufferToLowLevelLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PresentDetachedSharedFrameBufferToLowLevelLayer)
    }

    // nn::Result FillDetachedSharedFrameBufferColor(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::uint32_t color, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FillDetachedSharedFrameBufferColor, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, ::std::uint32_t color, const ::nn::vi::fbshare::SharedTextureOption& option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FillDetachedSharedFrameBufferColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(color)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FillDetachedSharedFrameBufferColor)
    }

    // nn::Result GetDetachedSharedFrameBufferImage(nn::sf::Out<std::uint64_t> outDataSize, const nn::sf::OutBuffer& data, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDetachedSharedFrameBufferImage, (::nn::sf::Out<::std::uint64_t> outDataSize, const ::nn::sf::OutBuffer& data, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDetachedSharedFrameBufferImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDetachedSharedFrameBufferImage)
    }

    // nn::Result SetDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDetachedSharedFrameBufferImage, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, const ::nn::sf::InBuffer& data, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::ImageTransformType srcTransform))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDetachedSharedFrameBufferImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstOption)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcTransform)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDetachedSharedFrameBufferImage)
    }

    // nn::Result CopyDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, std::int64_t dstIndex, nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, std::int64_t srcIndex, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::LayerStackFlagType maskStacks, nn::vi::LayerStackFlagType nullStacks) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CopyDetachedSharedFrameBufferImage, (::nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, ::std::int64_t dstIndex, ::nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, ::std::int64_t srcIndex, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::LayerStackFlagType maskStacks, ::nn::vi::LayerStackFlagType nullStacks))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CopyDetachedSharedFrameBufferImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hDstSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSrcSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstOption)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maskStacks)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nullStacks)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CopyDetachedSharedFrameBufferImage)
    }

    // nn::Result SetDetachedSharedFrameBufferSubImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::int32_t x, std::int32_t y, std::int32_t w, std::int32_t h, std::uint32_t bgColor, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDetachedSharedFrameBufferSubImage, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index, ::std::int32_t x, ::std::int32_t y, ::std::int32_t w, ::std::int32_t h, ::std::uint32_t bgColor, const ::nn::sf::InBuffer& data, const ::nn::vi::fbshare::SharedTextureOption& dstOption, ::nn::vi::ImageTransformType srcTransform))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDetachedSharedFrameBufferSubImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(y)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(w)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(h)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bgColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstOption)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcTransform)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDetachedSharedFrameBufferSubImage)
    }

    // nn::Result GetSharedFrameBufferContentParameter(nn::sf::Out<nn::vi::LayerStackFlagType> outLayerStacks, nn::sf::Out<nn::vi::CropRegion> outCropRegion, nn::sf::Out<std::int32_t> outScalingMode, nn::sf::Out<std::uint32_t> outTransform, nn::sf::Out<std::int32_t> outPresentInterval, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFrameBufferContentParameter, (::nn::sf::Out<::nn::vi::LayerStackFlagType> outLayerStacks, ::nn::sf::Out<::nn::vi::CropRegion> outCropRegion, ::nn::sf::Out<::std::int32_t> outScalingMode, ::nn::sf::Out<::std::uint32_t> outTransform, ::nn::sf::Out<::std::int32_t> outPresentInterval, ::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedFrameBufferContentParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLayerStacks)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCropRegion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outScalingMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTransform)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPresentInterval)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedFrameBufferContentParameter)
    }

    // nn::Result ExpandStartupLogoOnSharedFrameBuffer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t dstIndex, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExpandStartupLogoOnSharedFrameBuffer, (::nn::vi::fbshare::SharedBufferHandle hSharedBuffer, ::std::int64_t dstIndex, const ::nn::vi::fbshare::SharedTextureOption& option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExpandStartupLogoOnSharedFrameBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExpandStartupLogoOnSharedFrameBuffer)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::visrv::sf::IManagerDisplayService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::visrv::sf::IManagerDisplayService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AllocateProcessHeapBlock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AllocateProcessHeapBlock)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outBlockId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FreeProcessHeapBlock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FreeProcessHeapBlock)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(blockId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayResolution)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayResolution)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateManagedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateManagedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLayerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(settings),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(userAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyManagedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyManagedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateIndirectLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLayerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyIndirectLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateIndirectProducerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateIndirectProducerEndPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outProducerEndPointHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyIndirectProducerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyIndirectProducerEndPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateIndirectConsumerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateIndirectConsumerEndPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outConsumerEndPointHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyIndirectConsumerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyIndirectConsumerEndPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireLayerTexturePresentingEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireLayerTexturePresentingEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReleaseLayerTexturePresentingEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReleaseLayerTexturePresentingEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayHotplugEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayHotplugEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayModeChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayModeChangedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayHotplugState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayHotplugState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCompositorErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outErrorInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCompositorErrorInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outErrorInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(errorId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayErrorEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayErrorEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayAlpha)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayAlpha)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(alpha)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayLayerStack)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayLayerStack)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayPowerState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayPowerState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(state)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDefaultDisplay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDefaultDisplay)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddToLayerStack)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddToLayerStack)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(stackId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveFromLayerStack)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveFromLayerStack)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(stackId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLayerVisibility)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLayerVisibility)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isVisible)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLayerConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLayerConfig)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AttachLayerPresentationTracer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AttachLayerPresentationTracer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DetachLayerPresentationTracer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DetachLayerPresentationTracer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartLayerPresentationRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartLayerPresentationRecording)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopLayerPresentationRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopLayerPresentationRecording)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartLayerPresentationFenceWait)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartLayerPresentationFenceWait)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopLayerPresentationFenceWait)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopLayerPresentationFenceWait)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLayerPresentationAllFencesExpiredEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLayerPresentationAllFencesExpiredEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetContentVisibility)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetContentVisibility)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isVisible)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetConductorLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetConductorLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isConductor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetIndirectProducerFlipOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetIndirectProducerFlipOffset)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(producerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSharedBufferStaticStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(layout)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSharedBufferStaticStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(layout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSharedBufferTransferMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(layout)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSharedBufferTransferMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transferMemorySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(layout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroySharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroySharedBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BindSharedLowLevelLayerToManagedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BindSharedLowLevelLayerToManagedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BindSharedLowLevelLayerToIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BindSharedLowLevelLayerToIndirectLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnbindSharedLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnbindSharedLowLevelLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConnectSharedLowLevelLayerToSharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConnectSharedLowLevelLayerToSharedBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisconnectSharedLowLevelLayerFromSharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisconnectSharedLowLevelLayerFromSharedBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSharedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLayerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(userAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroySharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroySharedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AttachSharedLayerToLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AttachSharedLayerToLowLevelLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedLayer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(frameBufferIndexList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ForceDetachSharedLayerFromLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ForceDetachSharedLayerFromLowLevelLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartDetachSharedLayerFromLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartDetachSharedLayerFromLowLevelLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishDetachSharedLayerFromLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishDetachSharedLayerFromLowLevelLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedLayerDetachReadyEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedLayerDetachReadyEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedLowLevelLayerSynchronizedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedLowLevelLayerSynchronizedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckSharedLowLevelLayerSynchronized)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckSharedLowLevelLayerSynchronized)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outDisplayedIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterSharedBufferImporterAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterSharedBufferImporterAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(importerAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterSharedBufferImporterAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterSharedBufferImporterAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(importerAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSharedBufferProcessHeap)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(layout)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSharedBufferProcessHeap)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(blockId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(layout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedLayerLayerStacks)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedLayerLayerStacks)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStacks),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSharedLayerLayerStacks)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSharedLayerLayerStacks)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedLayer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(stacks)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PresentDetachedSharedFrameBufferToLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PresentDetachedSharedFrameBufferToLowLevelLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FillDetachedSharedFrameBufferColor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FillDetachedSharedFrameBufferColor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(color),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDetachedSharedFrameBufferImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDetachedSharedFrameBufferImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outDataSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDetachedSharedFrameBufferImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDetachedSharedFrameBufferImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstOption),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcTransform)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CopyDetachedSharedFrameBufferImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CopyDetachedSharedFrameBufferImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hDstSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSrcSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstOption),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maskStacks),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(nullStacks)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDetachedSharedFrameBufferSubImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDetachedSharedFrameBufferSubImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(y),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(w),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(h),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bgColor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstOption),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcTransform)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedFrameBufferContentParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedFrameBufferContentParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLayerStacks),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCropRegion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outScalingMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTransform),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outPresentInterval),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExpandStartupLogoOnSharedFrameBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExpandStartupLogoOnSharedFrameBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hSharedBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AllocateProcessHeapBlock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FreeProcessHeapBlock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayResolution)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateManagedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyManagedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateIndirectProducerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyIndirectProducerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateIndirectConsumerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyIndirectConsumerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireLayerTexturePresentingEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReleaseLayerTexturePresentingEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayHotplugEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayModeChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayHotplugState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCompositorErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayErrorEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayAlpha)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayLayerStack)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayPowerState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDefaultDisplay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddToLayerStack)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveFromLayerStack)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLayerVisibility)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLayerConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AttachLayerPresentationTracer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DetachLayerPresentationTracer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartLayerPresentationRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopLayerPresentationRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartLayerPresentationFenceWait)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopLayerPresentationFenceWait)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLayerPresentationAllFencesExpiredEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetContentVisibility)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetConductorLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetIndirectProducerFlipOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSharedBufferStaticStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSharedBufferTransferMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroySharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BindSharedLowLevelLayerToManagedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BindSharedLowLevelLayerToIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnbindSharedLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConnectSharedLowLevelLayerToSharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisconnectSharedLowLevelLayerFromSharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroySharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AttachSharedLayerToLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ForceDetachSharedLayerFromLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartDetachSharedLayerFromLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishDetachSharedLayerFromLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedLayerDetachReadyEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedLowLevelLayerSynchronizedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckSharedLowLevelLayerSynchronized)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterSharedBufferImporterAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterSharedBufferImporterAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSharedBufferProcessHeap)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedLayerLayerStacks)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSharedLayerLayerStacks)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PresentDetachedSharedFrameBufferToLowLevelLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FillDetachedSharedFrameBufferColor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDetachedSharedFrameBufferImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDetachedSharedFrameBufferImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CopyDetachedSharedFrameBufferImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDetachedSharedFrameBufferSubImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedFrameBufferContentParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExpandStartupLogoOnSharedFrameBuffer)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::visrv::sf::IManagerDisplayService))

namespace nn { namespace visrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManagerRootService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManagerRootService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel, ::nn::vi::ProxyName proxyName))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManagerRootService)

        ::nn::Result GetDisplayService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayService, (outService, policyLevel));
        }

        ::nn::Result GetDisplayServiceWithProxyNameExchange(::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel, ::nn::vi::ProxyName proxyName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (outService, policyLevel, proxyName));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManagerRootService
    {
    public:
        nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT;
        nn::Result GetDisplayServiceWithProxyNameExchange(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel, nn::vi::ProxyName proxyName) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT;
    nn::Result GetDisplayServiceWithProxyNameExchange(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel, nn::vi::ProxyName proxyName) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::visrv::sf::IManagerRootService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayService, (outService, policyLevel));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel, ::nn::vi::ProxyName proxyName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (outService, policyLevel, proxyName));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::visrv::sf::IManagerRootService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::visrv::sf::IManagerRootService))

    // nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(policyLevel, (::nn::vi::PolicyLevelType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (policyLevel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policyLevel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayService)

    // nn::Result GetDisplayServiceWithProxyNameExchange(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel, nn::vi::ProxyName proxyName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayServiceWithProxyNameExchange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(proxyName, (::nn::vi::ProxyName), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(policyLevel, (::nn::vi::PolicyLevelType), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (proxyName, policyLevel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policyLevel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(proxyName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayServiceWithProxyNameExchange)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::PolicyLevelType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::ProxyName), 8, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::visrv::sf::IManagerRootService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::visrv::sf::IManagerRootService))

    // nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policyLevel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayService)
    }

    // nn::Result GetDisplayServiceWithProxyNameExchange(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel, nn::vi::ProxyName proxyName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel, ::nn::vi::ProxyName proxyName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayServiceWithProxyNameExchange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policyLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(proxyName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayServiceWithProxyNameExchange)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::visrv::sf::IManagerRootService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::visrv::sf::IManagerRootService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(policyLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayServiceWithProxyNameExchange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayServiceWithProxyNameExchange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(policyLevel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(proxyName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayServiceWithProxyNameExchange)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::visrv::sf::IManagerRootService))

namespace nn { namespace visrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemDisplayService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemDisplayService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetZOrderCountMin, (::nn::sf::Out<::std::int64_t> outValue, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetZOrderCountMax, (::nn::sf::Out<::std::int64_t> outValue, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayLogicalResolution, (::nn::sf::Out<::std::int32_t> outWidth, ::nn::sf::Out<::std::int32_t> outHeight, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayMagnification, (::nn::vi::DisplayId displayId, ::std::int32_t x, ::std::int32_t y, ::std::int32_t width, ::std::int32_t height))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerPosition, (::nn::vi::LayerId layerId, float x, float y))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerSize, (::nn::vi::LayerId layerId, ::std::int64_t width, ::std::int64_t height))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLayerZ, (::nn::sf::Out<::std::int64_t> outZ, ::nn::vi::LayerId layerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerZ, (::nn::vi::LayerId layerId, ::std::int64_t z))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerVisibility, (::nn::vi::LayerId layerId, bool isVisible))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerAlpha, (::nn::vi::LayerId layerId, float alpha))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateStrayLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenIndirectLayer, (::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::IndirectProducerHandleType producerHandle, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseIndirectLayer, (::nn::vi::IndirectProducerHandleType producerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FlipIndirectLayer, (::nn::vi::IndirectProducerHandleType producerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayModes, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::DisplayModeInfo>& outModes, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayRgbRanges, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::RgbRangeType>& outRanges, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayContentTypes, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::ContentTypeType>& outTypes, ::nn::vi::DisplayId dispayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayMode, (::nn::sf::Out<::nn::vi::DisplayModeInfo> outMode, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayMode, (::nn::vi::DisplayId displayId, const ::nn::vi::DisplayModeInfo& mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayUnderscan, (::nn::sf::Out<::std::int64_t> outUnderscan, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayUnderscan, (::nn::vi::DisplayId displayId, ::std::int64_t underscan))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayContentType, (::nn::sf::Out<::nn::vi::ContentTypeType> outType, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayContentType, (::nn::vi::DisplayId displayId, ::nn::vi::ContentTypeType type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayRgbRange, (::nn::sf::Out<::nn::vi::RgbRangeType> outRange, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayRgbRange, (::nn::vi::DisplayId displayId, ::nn::vi::RgbRangeType range))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayCmuMode, (::nn::sf::Out<::nn::vi::CmuModeType> outMode, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayCmuMode, (::nn::vi::DisplayId displayId, ::nn::vi::CmuModeType mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayContrastRatio, (::nn::sf::Out<float> outRatio, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayContrastRatio, (::nn::vi::DisplayId displayId, float ratio))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayGamma, (::nn::sf::Out<float> outGamma, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayGamma, (::nn::vi::DisplayId displayId, float gamma))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayCmuLuma, (::nn::sf::Out<float> outValue, ::nn::vi::DisplayId displayId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayCmuLuma, (::nn::vi::DisplayId displayId, float value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedBufferMemoryHandleId, (::nn::sf::Out<::nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, ::nn::sf::Out<::std::uint64_t> outMemorySize, ::nn::sf::Out<::nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, ::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConnectSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireSharedFrameBuffer, (::nn::sf::Out<::std::int64_t> outIndex, ::nn::sf::Out<::nn::vi::native::NativeSync> outSync, ::nn::sf::Out<::nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, ::nn::vi::fbshare::SharedLayerHandle hLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PresentSharedFrameBuffer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index, const ::nn::vi::native::NativeSync& sync, const ::nn::vi::CropRegion& crop, ::nn::vi::ImageTransformType transform, ::std::int32_t presentInterval))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFrameBufferAcquirableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::fbshare::SharedLayerHandle hLayer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FillSharedFrameBufferColor, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index, ::std::int32_t r, ::std::int32_t g, ::std::int32_t b, ::std::int32_t a))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelSharedFrameBuffer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemDisplayService)

        ::nn::Result GetZOrderCountMin(::nn::sf::Out<::std::int64_t> outValue, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetZOrderCountMin, (outValue, displayId));
        }

        ::nn::Result GetZOrderCountMax(::nn::sf::Out<::std::int64_t> outValue, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetZOrderCountMax, (outValue, displayId));
        }

        ::nn::Result GetDisplayLogicalResolution(::nn::sf::Out<::std::int32_t> outWidth, ::nn::sf::Out<::std::int32_t> outHeight, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayLogicalResolution, (outWidth, outHeight, displayId));
        }

        ::nn::Result SetDisplayMagnification(::nn::vi::DisplayId displayId, ::std::int32_t x, ::std::int32_t y, ::std::int32_t width, ::std::int32_t height) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayMagnification, (displayId, x, y, width, height));
        }

        ::nn::Result SetLayerPosition(::nn::vi::LayerId layerId, float x, float y) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLayerPosition, (layerId, x, y));
        }

        ::nn::Result SetLayerSize(::nn::vi::LayerId layerId, ::std::int64_t width, ::std::int64_t height) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLayerSize, (layerId, width, height));
        }

        ::nn::Result GetLayerZ(::nn::sf::Out<::std::int64_t> outZ, ::nn::vi::LayerId layerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLayerZ, (outZ, layerId));
        }

        ::nn::Result SetLayerZ(::nn::vi::LayerId layerId, ::std::int64_t z) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLayerZ, (layerId, z));
        }

        ::nn::Result SetLayerVisibility(::nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLayerVisibility, (layerId, isVisible));
        }

        ::nn::Result SetLayerAlpha(::nn::vi::LayerId layerId, float alpha) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLayerAlpha, (layerId, alpha));
        }

        ::nn::Result CreateStrayLayer(::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateStrayLayer, (outLayerId, outNativeWindowDataSize, outNativeWindowData, displayId, settings));
        }

        ::nn::Result OpenIndirectLayer(::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::IndirectProducerHandleType producerHandle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenIndirectLayer, (outNativeWindowDataSize, outNativeWindowData, producerHandle, aruid));
        }

        ::nn::Result CloseIndirectLayer(::nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseIndirectLayer, (producerHandle));
        }

        ::nn::Result FlipIndirectLayer(::nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FlipIndirectLayer, (producerHandle));
        }

        ::nn::Result ListDisplayModes(::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::DisplayModeInfo>& outModes, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDisplayModes, (outCount, outModes, displayId));
        }

        ::nn::Result ListDisplayRgbRanges(::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::RgbRangeType>& outRanges, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDisplayRgbRanges, (outCount, outRanges, displayId));
        }

        ::nn::Result ListDisplayContentTypes(::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::ContentTypeType>& outTypes, ::nn::vi::DisplayId dispayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDisplayContentTypes, (outCount, outTypes, dispayId));
        }

        ::nn::Result GetDisplayMode(::nn::sf::Out<::nn::vi::DisplayModeInfo> outMode, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayMode, (outMode, displayId));
        }

        ::nn::Result SetDisplayMode(::nn::vi::DisplayId displayId, const ::nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayMode, (displayId, mode));
        }

        ::nn::Result GetDisplayUnderscan(::nn::sf::Out<::std::int64_t> outUnderscan, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayUnderscan, (outUnderscan, displayId));
        }

        ::nn::Result SetDisplayUnderscan(::nn::vi::DisplayId displayId, ::std::int64_t underscan) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayUnderscan, (displayId, underscan));
        }

        ::nn::Result GetDisplayContentType(::nn::sf::Out<::nn::vi::ContentTypeType> outType, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayContentType, (outType, displayId));
        }

        ::nn::Result SetDisplayContentType(::nn::vi::DisplayId displayId, ::nn::vi::ContentTypeType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayContentType, (displayId, type));
        }

        ::nn::Result GetDisplayRgbRange(::nn::sf::Out<::nn::vi::RgbRangeType> outRange, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayRgbRange, (outRange, displayId));
        }

        ::nn::Result SetDisplayRgbRange(::nn::vi::DisplayId displayId, ::nn::vi::RgbRangeType range) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayRgbRange, (displayId, range));
        }

        ::nn::Result GetDisplayCmuMode(::nn::sf::Out<::nn::vi::CmuModeType> outMode, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayCmuMode, (outMode, displayId));
        }

        ::nn::Result SetDisplayCmuMode(::nn::vi::DisplayId displayId, ::nn::vi::CmuModeType mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayCmuMode, (displayId, mode));
        }

        ::nn::Result GetDisplayContrastRatio(::nn::sf::Out<float> outRatio, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayContrastRatio, (outRatio, displayId));
        }

        ::nn::Result SetDisplayContrastRatio(::nn::vi::DisplayId displayId, float ratio) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayContrastRatio, (displayId, ratio));
        }

        ::nn::Result GetDisplayGamma(::nn::sf::Out<float> outGamma, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayGamma, (outGamma, displayId));
        }

        ::nn::Result SetDisplayGamma(::nn::vi::DisplayId displayId, float gamma) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayGamma, (displayId, gamma));
        }

        ::nn::Result GetDisplayCmuLuma(::nn::sf::Out<float> outValue, ::nn::vi::DisplayId displayId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayCmuLuma, (outValue, displayId));
        }

        ::nn::Result SetDisplayCmuLuma(::nn::vi::DisplayId displayId, float value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDisplayCmuLuma, (displayId, value));
        }

        ::nn::Result GetSharedBufferMemoryHandleId(::nn::sf::Out<::nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, ::nn::sf::Out<::std::uint64_t> outMemorySize, ::nn::sf::Out<::nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, ::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedBufferMemoryHandleId, (outMemoryHandleId, outMemorySize, outLayout, hBuffer, aruid));
        }

        ::nn::Result OpenSharedLayer(::nn::vi::fbshare::SharedLayerHandle hLayer, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSharedLayer, (hLayer, aruid));
        }

        ::nn::Result CloseSharedLayer(::nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseSharedLayer, (hLayer));
        }

        ::nn::Result ConnectSharedLayer(::nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConnectSharedLayer, (hLayer));
        }

        ::nn::Result DisconnectSharedLayer(::nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DisconnectSharedLayer, (hLayer));
        }

        ::nn::Result AcquireSharedFrameBuffer(::nn::sf::Out<::std::int64_t> outIndex, ::nn::sf::Out<::nn::vi::native::NativeSync> outSync, ::nn::sf::Out<::nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, ::nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireSharedFrameBuffer, (outIndex, outSync, outIndexList, hLayer));
        }

        ::nn::Result PresentSharedFrameBuffer(::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index, const ::nn::vi::native::NativeSync& sync, const ::nn::vi::CropRegion& crop, ::nn::vi::ImageTransformType transform, ::std::int32_t presentInterval) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PresentSharedFrameBuffer, (hLayer, index, sync, crop, transform, presentInterval));
        }

        ::nn::Result GetSharedFrameBufferAcquirableEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedFrameBufferAcquirableEvent, (outHandle, hLayer));
        }

        ::nn::Result FillSharedFrameBufferColor(::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index, ::std::int32_t r, ::std::int32_t g, ::std::int32_t b, ::std::int32_t a) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FillSharedFrameBufferColor, (hLayer, index, r, g, b, a));
        }

        ::nn::Result CancelSharedFrameBuffer(::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelSharedFrameBuffer, (hLayer, index));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemDisplayService
    {
    public:
        nn::Result GetZOrderCountMin(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetZOrderCountMax(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetDisplayLogicalResolution(nn::sf::Out<std::int32_t> outWidth, nn::sf::Out<std::int32_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayMagnification(nn::vi::DisplayId displayId, std::int32_t x, std::int32_t y, std::int32_t width, std::int32_t height) NN_NOEXCEPT;
        nn::Result SetLayerPosition(nn::vi::LayerId layerId, float x, float y) NN_NOEXCEPT;
        nn::Result SetLayerSize(nn::vi::LayerId layerId, std::int64_t width, std::int64_t height) NN_NOEXCEPT;
        nn::Result GetLayerZ(nn::sf::Out<std::int64_t> outZ, nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result SetLayerZ(nn::vi::LayerId layerId, std::int64_t z) NN_NOEXCEPT;
        nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT;
        nn::Result SetLayerAlpha(nn::vi::LayerId layerId, float alpha) NN_NOEXCEPT;
        nn::Result CreateStrayLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings) NN_NOEXCEPT;
        nn::Result OpenIndirectLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::IndirectProducerHandleType producerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CloseIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT;
        nn::Result FlipIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT;
        nn::Result ListDisplayModes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayModeInfo>& outModes, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result ListDisplayRgbRanges(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::RgbRangeType>& outRanges, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result ListDisplayContentTypes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::ContentTypeType>& outTypes, nn::vi::DisplayId dispayId) NN_NOEXCEPT;
        nn::Result GetDisplayMode(nn::sf::Out<nn::vi::DisplayModeInfo> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayMode(nn::vi::DisplayId displayId, const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT;
        nn::Result GetDisplayUnderscan(nn::sf::Out<std::int64_t> outUnderscan, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayUnderscan(nn::vi::DisplayId displayId, std::int64_t underscan) NN_NOEXCEPT;
        nn::Result GetDisplayContentType(nn::sf::Out<nn::vi::ContentTypeType> outType, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayContentType(nn::vi::DisplayId displayId, nn::vi::ContentTypeType type) NN_NOEXCEPT;
        nn::Result GetDisplayRgbRange(nn::sf::Out<nn::vi::RgbRangeType> outRange, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayRgbRange(nn::vi::DisplayId displayId, nn::vi::RgbRangeType range) NN_NOEXCEPT;
        nn::Result GetDisplayCmuMode(nn::sf::Out<nn::vi::CmuModeType> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayCmuMode(nn::vi::DisplayId displayId, nn::vi::CmuModeType mode) NN_NOEXCEPT;
        nn::Result GetDisplayContrastRatio(nn::sf::Out<float> outRatio, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayContrastRatio(nn::vi::DisplayId displayId, float ratio) NN_NOEXCEPT;
        nn::Result GetDisplayGamma(nn::sf::Out<float> outGamma, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayGamma(nn::vi::DisplayId displayId, float gamma) NN_NOEXCEPT;
        nn::Result GetDisplayCmuLuma(nn::sf::Out<float> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayCmuLuma(nn::vi::DisplayId displayId, float value) NN_NOEXCEPT;
        nn::Result GetSharedBufferMemoryHandleId(nn::sf::Out<nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, nn::sf::Out<std::uint64_t> outMemorySize, nn::sf::Out<nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result OpenSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CloseSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result ConnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result DisconnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result AcquireSharedFrameBuffer(nn::sf::Out<std::int64_t> outIndex, nn::sf::Out<nn::vi::native::NativeSync> outSync, nn::sf::Out<nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result PresentSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, const nn::vi::native::NativeSync& sync, const nn::vi::CropRegion& crop, nn::vi::ImageTransformType transform, std::int32_t presentInterval) NN_NOEXCEPT;
        nn::Result GetSharedFrameBufferAcquirableEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result FillSharedFrameBufferColor(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, std::int32_t r, std::int32_t g, std::int32_t b, std::int32_t a) NN_NOEXCEPT;
        nn::Result CancelSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetZOrderCountMin(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result GetZOrderCountMax(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result GetDisplayLogicalResolution(nn::sf::Out<std::int32_t> outWidth, nn::sf::Out<std::int32_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayMagnification(nn::vi::DisplayId displayId, std::int32_t x, std::int32_t y, std::int32_t width, std::int32_t height) NN_NOEXCEPT;
    nn::Result SetLayerPosition(nn::vi::LayerId layerId, float x, float y) NN_NOEXCEPT;
    nn::Result SetLayerSize(nn::vi::LayerId layerId, std::int64_t width, std::int64_t height) NN_NOEXCEPT;
    nn::Result GetLayerZ(nn::sf::Out<std::int64_t> outZ, nn::vi::LayerId layerId) NN_NOEXCEPT;
    nn::Result SetLayerZ(nn::vi::LayerId layerId, std::int64_t z) NN_NOEXCEPT;
    nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT;
    nn::Result SetLayerAlpha(nn::vi::LayerId layerId, float alpha) NN_NOEXCEPT;
    nn::Result CreateStrayLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings) NN_NOEXCEPT;
    nn::Result OpenIndirectLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::IndirectProducerHandleType producerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result CloseIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT;
    nn::Result FlipIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT;
    nn::Result ListDisplayModes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayModeInfo>& outModes, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result ListDisplayRgbRanges(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::RgbRangeType>& outRanges, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result ListDisplayContentTypes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::ContentTypeType>& outTypes, nn::vi::DisplayId dispayId) NN_NOEXCEPT;
    nn::Result GetDisplayMode(nn::sf::Out<nn::vi::DisplayModeInfo> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayMode(nn::vi::DisplayId displayId, const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT;
    nn::Result GetDisplayUnderscan(nn::sf::Out<std::int64_t> outUnderscan, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayUnderscan(nn::vi::DisplayId displayId, std::int64_t underscan) NN_NOEXCEPT;
    nn::Result GetDisplayContentType(nn::sf::Out<nn::vi::ContentTypeType> outType, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayContentType(nn::vi::DisplayId displayId, nn::vi::ContentTypeType type) NN_NOEXCEPT;
    nn::Result GetDisplayRgbRange(nn::sf::Out<nn::vi::RgbRangeType> outRange, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayRgbRange(nn::vi::DisplayId displayId, nn::vi::RgbRangeType range) NN_NOEXCEPT;
    nn::Result GetDisplayCmuMode(nn::sf::Out<nn::vi::CmuModeType> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayCmuMode(nn::vi::DisplayId displayId, nn::vi::CmuModeType mode) NN_NOEXCEPT;
    nn::Result GetDisplayContrastRatio(nn::sf::Out<float> outRatio, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayContrastRatio(nn::vi::DisplayId displayId, float ratio) NN_NOEXCEPT;
    nn::Result GetDisplayGamma(nn::sf::Out<float> outGamma, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayGamma(nn::vi::DisplayId displayId, float gamma) NN_NOEXCEPT;
    nn::Result GetDisplayCmuLuma(nn::sf::Out<float> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
    nn::Result SetDisplayCmuLuma(nn::vi::DisplayId displayId, float value) NN_NOEXCEPT;
    nn::Result GetSharedBufferMemoryHandleId(nn::sf::Out<nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, nn::sf::Out<std::uint64_t> outMemorySize, nn::sf::Out<nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result OpenSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result CloseSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
    nn::Result ConnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
    nn::Result DisconnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
    nn::Result AcquireSharedFrameBuffer(nn::sf::Out<std::int64_t> outIndex, nn::sf::Out<nn::vi::native::NativeSync> outSync, nn::sf::Out<nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
    nn::Result PresentSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, const nn::vi::native::NativeSync& sync, const nn::vi::CropRegion& crop, nn::vi::ImageTransformType transform, std::int32_t presentInterval) NN_NOEXCEPT;
    nn::Result GetSharedFrameBufferAcquirableEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
    nn::Result FillSharedFrameBufferColor(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, std::int32_t r, std::int32_t g, std::int32_t b, std::int32_t a) NN_NOEXCEPT;
    nn::Result CancelSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::visrv::sf::ISystemDisplayService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetZOrderCountMin, (::nn::sf::Out<::std::int64_t> outValue, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetZOrderCountMin, (outValue, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetZOrderCountMax, (::nn::sf::Out<::std::int64_t> outValue, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetZOrderCountMax, (outValue, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayLogicalResolution, (::nn::sf::Out<::std::int32_t> outWidth, ::nn::sf::Out<::std::int32_t> outHeight, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayLogicalResolution, (outWidth, outHeight, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayMagnification, (::nn::vi::DisplayId displayId, ::std::int32_t x, ::std::int32_t y, ::std::int32_t width, ::std::int32_t height))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayMagnification, (displayId, x, y, width, height));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerPosition, (::nn::vi::LayerId layerId, float x, float y))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLayerPosition, (layerId, x, y));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerSize, (::nn::vi::LayerId layerId, ::std::int64_t width, ::std::int64_t height))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLayerSize, (layerId, width, height));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLayerZ, (::nn::sf::Out<::std::int64_t> outZ, ::nn::vi::LayerId layerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLayerZ, (outZ, layerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerZ, (::nn::vi::LayerId layerId, ::std::int64_t z))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLayerZ, (layerId, z));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerVisibility, (::nn::vi::LayerId layerId, bool isVisible))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLayerVisibility, (layerId, isVisible));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerAlpha, (::nn::vi::LayerId layerId, float alpha))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLayerAlpha, (layerId, alpha));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateStrayLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateStrayLayer, (outLayerId, outNativeWindowDataSize, outNativeWindowData, displayId, settings));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenIndirectLayer, (::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::IndirectProducerHandleType producerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenIndirectLayer, (outNativeWindowDataSize, outNativeWindowData, producerHandle, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseIndirectLayer, (::nn::vi::IndirectProducerHandleType producerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseIndirectLayer, (producerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FlipIndirectLayer, (::nn::vi::IndirectProducerHandleType producerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FlipIndirectLayer, (producerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayModes, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::DisplayModeInfo>& outModes, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDisplayModes, (outCount, outModes, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayRgbRanges, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::RgbRangeType>& outRanges, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDisplayRgbRanges, (outCount, outRanges, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayContentTypes, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::ContentTypeType>& outTypes, ::nn::vi::DisplayId dispayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDisplayContentTypes, (outCount, outTypes, dispayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayMode, (::nn::sf::Out<::nn::vi::DisplayModeInfo> outMode, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayMode, (outMode, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayMode, (::nn::vi::DisplayId displayId, const ::nn::vi::DisplayModeInfo& mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayMode, (displayId, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayUnderscan, (::nn::sf::Out<::std::int64_t> outUnderscan, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayUnderscan, (outUnderscan, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayUnderscan, (::nn::vi::DisplayId displayId, ::std::int64_t underscan))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayUnderscan, (displayId, underscan));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayContentType, (::nn::sf::Out<::nn::vi::ContentTypeType> outType, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayContentType, (outType, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayContentType, (::nn::vi::DisplayId displayId, ::nn::vi::ContentTypeType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayContentType, (displayId, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayRgbRange, (::nn::sf::Out<::nn::vi::RgbRangeType> outRange, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayRgbRange, (outRange, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayRgbRange, (::nn::vi::DisplayId displayId, ::nn::vi::RgbRangeType range))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayRgbRange, (displayId, range));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayCmuMode, (::nn::sf::Out<::nn::vi::CmuModeType> outMode, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayCmuMode, (outMode, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayCmuMode, (::nn::vi::DisplayId displayId, ::nn::vi::CmuModeType mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayCmuMode, (displayId, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayContrastRatio, (::nn::sf::Out<float> outRatio, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayContrastRatio, (outRatio, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayContrastRatio, (::nn::vi::DisplayId displayId, float ratio))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayContrastRatio, (displayId, ratio));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayGamma, (::nn::sf::Out<float> outGamma, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayGamma, (outGamma, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayGamma, (::nn::vi::DisplayId displayId, float gamma))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayGamma, (displayId, gamma));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayCmuLuma, (::nn::sf::Out<float> outValue, ::nn::vi::DisplayId displayId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayCmuLuma, (outValue, displayId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayCmuLuma, (::nn::vi::DisplayId displayId, float value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDisplayCmuLuma, (displayId, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedBufferMemoryHandleId, (::nn::sf::Out<::nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, ::nn::sf::Out<::std::uint64_t> outMemorySize, ::nn::sf::Out<::nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, ::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedBufferMemoryHandleId, (outMemoryHandleId, outMemorySize, outLayout, hBuffer, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSharedLayer, (hLayer, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseSharedLayer, (hLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConnectSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConnectSharedLayer, (hLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DisconnectSharedLayer, (hLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireSharedFrameBuffer, (::nn::sf::Out<::std::int64_t> outIndex, ::nn::sf::Out<::nn::vi::native::NativeSync> outSync, ::nn::sf::Out<::nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, ::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireSharedFrameBuffer, (outIndex, outSync, outIndexList, hLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PresentSharedFrameBuffer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index, const ::nn::vi::native::NativeSync& sync, const ::nn::vi::CropRegion& crop, ::nn::vi::ImageTransformType transform, ::std::int32_t presentInterval))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PresentSharedFrameBuffer, (hLayer, index, sync, crop, transform, presentInterval));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFrameBufferAcquirableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedFrameBufferAcquirableEvent, (outHandle, hLayer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FillSharedFrameBufferColor, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index, ::std::int32_t r, ::std::int32_t g, ::std::int32_t b, ::std::int32_t a))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FillSharedFrameBufferColor, (hLayer, index, r, g, b, a));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelSharedFrameBuffer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelSharedFrameBuffer, (hLayer, index));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::visrv::sf::ISystemDisplayService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::visrv::sf::ISystemDisplayService))

    // nn::Result GetZOrderCountMin(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetZOrderCountMin)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetZOrderCountMin)

    // nn::Result GetZOrderCountMax(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetZOrderCountMax)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetZOrderCountMax)

    // nn::Result GetDisplayLogicalResolution(nn::sf::Out<std::int32_t> outWidth, nn::sf::Out<std::int32_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayLogicalResolution)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayLogicalResolution)

    // nn::Result SetDisplayMagnification(nn::vi::DisplayId displayId, std::int32_t x, std::int32_t y, std::int32_t width, std::int32_t height) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayMagnification)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(y, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int32_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (x, y, width, height, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(y), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayMagnification)

    // nn::Result SetLayerPosition(nn::vi::LayerId layerId, float x, float y) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLayerPosition)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(y, (float), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (x, y, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(y)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLayerPosition)

    // nn::Result SetLayerSize(nn::vi::LayerId layerId, std::int64_t width, std::int64_t height) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLayerSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (layerId, width, height))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLayerSize)

    // nn::Result GetLayerZ(nn::sf::Out<std::int64_t> outZ, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLayerZ)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outZ, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outZ))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outZ), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLayerZ)

    // nn::Result SetLayerZ(nn::vi::LayerId layerId, std::int64_t z) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLayerZ)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(z, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (layerId, z))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(z)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLayerZ)

    // nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLayerVisibility)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isVisible, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isVisible, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isVisible)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLayerVisibility)

    // nn::Result SetLayerAlpha(nn::vi::LayerId layerId, float alpha) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLayerAlpha)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2209)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(alpha, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerId, (::nn::vi::LayerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (alpha, layerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(alpha)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLayerAlpha)

    // nn::Result CreateStrayLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateStrayLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2312)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outNativeWindowData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNativeWindowData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(settings, (::nn::vi::LayerSettingsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (settings, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLayerId, (::nn::vi::LayerId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNativeWindowDataSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outLayerId, outNativeWindowDataSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLayerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNativeWindowDataSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNativeWindowData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(settings)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateStrayLayer)

    // nn::Result OpenIndirectLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::IndirectProducerHandleType producerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenIndirectLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outNativeWindowData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNativeWindowData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(producerHandle, (::nn::vi::IndirectProducerHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (producerHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNativeWindowDataSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNativeWindowDataSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNativeWindowDataSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNativeWindowData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(producerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenIndirectLayer)

    // nn::Result CloseIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseIndirectLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(producerHandle, (::nn::vi::IndirectProducerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (producerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(producerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseIndirectLayer)

    // nn::Result FlipIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FlipIndirectLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(producerHandle, (::nn::vi::IndirectProducerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (producerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(producerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FlipIndirectLayer)

    // nn::Result ListDisplayModes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayModeInfo>& outModes, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDisplayModes)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outModes, 0, (const ::nn::sf::OutArray<::nn::vi::DisplayModeInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outModes))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outModes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDisplayModes)

    // nn::Result ListDisplayRgbRanges(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::RgbRangeType>& outRanges, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDisplayRgbRanges)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outRanges, 0, (const ::nn::sf::OutArray<::nn::vi::RgbRangeType>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outRanges))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRanges), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDisplayRgbRanges)

    // nn::Result ListDisplayContentTypes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::ContentTypeType>& outTypes, nn::vi::DisplayId dispayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDisplayContentTypes)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outTypes, 0, (const ::nn::sf::OutArray<::nn::vi::ContentTypeType>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outTypes))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dispayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (dispayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTypes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dispayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDisplayContentTypes)

    // nn::Result GetDisplayMode(nn::sf::Out<nn::vi::DisplayModeInfo> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMode, (::nn::vi::DisplayModeInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayMode)

    // nn::Result SetDisplayMode(nn::vi::DisplayId displayId, const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::nn::vi::DisplayModeInfo), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (displayId, mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayMode)

    // nn::Result GetDisplayUnderscan(nn::sf::Out<std::int64_t> outUnderscan, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayUnderscan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outUnderscan, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outUnderscan))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUnderscan), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayUnderscan)

    // nn::Result SetDisplayUnderscan(nn::vi::DisplayId displayId, std::int64_t underscan) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayUnderscan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(underscan, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (displayId, underscan))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(underscan)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayUnderscan)

    // nn::Result GetDisplayContentType(nn::sf::Out<nn::vi::ContentTypeType> outType, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayContentType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outType, (::nn::vi::ContentTypeType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayContentType)

    // nn::Result SetDisplayContentType(nn::vi::DisplayId displayId, nn::vi::ContentTypeType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayContentType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::vi::ContentTypeType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayContentType)

    // nn::Result GetDisplayRgbRange(nn::sf::Out<nn::vi::RgbRangeType> outRange, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayRgbRange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRange, (::nn::vi::RgbRangeType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outRange))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRange), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayRgbRange)

    // nn::Result SetDisplayRgbRange(nn::vi::DisplayId displayId, nn::vi::RgbRangeType range) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayRgbRange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(range, (::nn::vi::RgbRangeType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (range, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(range)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayRgbRange)

    // nn::Result GetDisplayCmuMode(nn::sf::Out<nn::vi::CmuModeType> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayCmuMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3208)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMode, (::nn::vi::CmuModeType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayCmuMode)

    // nn::Result SetDisplayCmuMode(nn::vi::DisplayId displayId, nn::vi::CmuModeType mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayCmuMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3209)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::nn::vi::CmuModeType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (mode, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayCmuMode)

    // nn::Result GetDisplayContrastRatio(nn::sf::Out<float> outRatio, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayContrastRatio)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRatio, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outRatio))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRatio), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayContrastRatio)

    // nn::Result SetDisplayContrastRatio(nn::vi::DisplayId displayId, float ratio) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayContrastRatio)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3211)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ratio, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (ratio, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ratio)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayContrastRatio)

    // nn::Result GetDisplayGamma(nn::sf::Out<float> outGamma, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayGamma)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3214)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outGamma, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outGamma))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outGamma), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayGamma)

    // nn::Result SetDisplayGamma(nn::vi::DisplayId displayId, float gamma) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayGamma)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3215)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(gamma, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (gamma, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(gamma)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayGamma)

    // nn::Result GetDisplayCmuLuma(nn::sf::Out<float> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayCmuLuma)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3216)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayCmuLuma)

    // nn::Result SetDisplayCmuLuma(nn::vi::DisplayId displayId, float value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDisplayCmuLuma)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3217)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(displayId, (::nn::vi::DisplayId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (value, displayId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(displayId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDisplayCmuLuma)

    // nn::Result GetSharedBufferMemoryHandleId(nn::sf::Out<nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, nn::sf::Out<std::uint64_t> outMemorySize, nn::sf::Out<nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedBufferMemoryHandleId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8225)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outLayout, 0, (::nn::sf::Out<::nn::vi::fbshare::SharedMemoryPoolLayout>), 392, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outLayout))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hBuffer, (::nn::vi::fbshare::SharedBufferHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (hBuffer, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMemoryHandleId, (::nn::vi::native::NativeMemoryHandleId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMemorySize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outMemoryHandleId, outMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMemoryHandleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMemorySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLayout), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedBufferMemoryHandleId)

    // nn::Result OpenSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSharedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8250)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (hLayer, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSharedLayer)

    // nn::Result CloseSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseSharedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8251)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseSharedLayer)

    // nn::Result ConnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConnectSharedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8252)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConnectSharedLayer)

    // nn::Result DisconnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisconnectSharedLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8253)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisconnectSharedLayer)

    // nn::Result AcquireSharedFrameBuffer(nn::sf::Out<std::int64_t> outIndex, nn::sf::Out<nn::vi::native::NativeSync> outSync, nn::sf::Out<nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireSharedFrameBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8254)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSync, (::nn::vi::native::NativeSync), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIndexList, (::nn::vi::fbshare::SharedLayerTextureIndexList), 36)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIndex, (::std::int64_t), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outSync, outIndexList, outIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIndexList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireSharedFrameBuffer)

    // nn::Result PresentSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, const nn::vi::native::NativeSync& sync, const nn::vi::CropRegion& crop, nn::vi::ImageTransformType transform, std::int32_t presentInterval) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PresentSharedFrameBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8255)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sync, (::nn::vi::native::NativeSync), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(crop, (::nn::vi::CropRegion), 36)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transform, (::nn::vi::ImageTransformType), 52)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(presentInterval, (::std::int32_t), 56)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (sync, crop, transform, presentInterval, hLayer, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(crop), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transform), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(presentInterval)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PresentSharedFrameBuffer)

    // nn::Result GetSharedFrameBufferAcquirableEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedFrameBufferAcquirableEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8256)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hLayer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedFrameBufferAcquirableEvent)

    // nn::Result FillSharedFrameBufferColor(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, std::int32_t r, std::int32_t g, std::int32_t b, std::int32_t a) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FillSharedFrameBufferColor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8257)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(r, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(g, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(b, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(a, (::std::int32_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (r, g, b, a, hLayer, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(r), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(g), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(b), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(a)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FillSharedFrameBufferColor)

    // nn::Result CancelSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelSharedFrameBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8258)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hLayer, (::nn::vi::fbshare::SharedLayerHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (hLayer, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hLayer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelSharedFrameBuffer)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::DisplayId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::LayerSettingsType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::IndirectProducerHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::DisplayModeInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::RgbRangeType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::ContentTypeType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::CmuModeType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::native::NativeMemoryHandleId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedMemoryPoolLayout), 392, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedBufferHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedLayerHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::native::NativeSync), 36, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedLayerTextureIndexList), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::CropRegion), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::ImageTransformType), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::visrv::sf::ISystemDisplayService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::visrv::sf::ISystemDisplayService))

    // nn::Result GetZOrderCountMin(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetZOrderCountMin, (::nn::sf::Out<::std::int64_t> outValue, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetZOrderCountMin)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetZOrderCountMin)
    }

    // nn::Result GetZOrderCountMax(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetZOrderCountMax, (::nn::sf::Out<::std::int64_t> outValue, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetZOrderCountMax)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetZOrderCountMax)
    }

    // nn::Result GetDisplayLogicalResolution(nn::sf::Out<std::int32_t> outWidth, nn::sf::Out<std::int32_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayLogicalResolution, (::nn::sf::Out<::std::int32_t> outWidth, ::nn::sf::Out<::std::int32_t> outHeight, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayLogicalResolution)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayLogicalResolution)
    }

    // nn::Result SetDisplayMagnification(nn::vi::DisplayId displayId, std::int32_t x, std::int32_t y, std::int32_t width, std::int32_t height) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayMagnification, (::nn::vi::DisplayId displayId, ::std::int32_t x, ::std::int32_t y, ::std::int32_t width, ::std::int32_t height))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayMagnification)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(y)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayMagnification)
    }

    // nn::Result SetLayerPosition(nn::vi::LayerId layerId, float x, float y) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerPosition, (::nn::vi::LayerId layerId, float x, float y))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLayerPosition)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(y)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLayerPosition)
    }

    // nn::Result SetLayerSize(nn::vi::LayerId layerId, std::int64_t width, std::int64_t height) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerSize, (::nn::vi::LayerId layerId, ::std::int64_t width, ::std::int64_t height))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLayerSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLayerSize)
    }

    // nn::Result GetLayerZ(nn::sf::Out<std::int64_t> outZ, nn::vi::LayerId layerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLayerZ, (::nn::sf::Out<::std::int64_t> outZ, ::nn::vi::LayerId layerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLayerZ)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outZ)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLayerZ)
    }

    // nn::Result SetLayerZ(nn::vi::LayerId layerId, std::int64_t z) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerZ, (::nn::vi::LayerId layerId, ::std::int64_t z))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLayerZ)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(z)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLayerZ)
    }

    // nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerVisibility, (::nn::vi::LayerId layerId, bool isVisible))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLayerVisibility)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isVisible)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLayerVisibility)
    }

    // nn::Result SetLayerAlpha(nn::vi::LayerId layerId, float alpha) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLayerAlpha, (::nn::vi::LayerId layerId, float alpha))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLayerAlpha)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(alpha)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLayerAlpha)
    }

    // nn::Result CreateStrayLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateStrayLayer, (::nn::sf::Out<::nn::vi::LayerId> outLayerId, ::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::DisplayId displayId, ::nn::vi::LayerSettingsType settings))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateStrayLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLayerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNativeWindowDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNativeWindowData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(settings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateStrayLayer)
    }

    // nn::Result OpenIndirectLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::IndirectProducerHandleType producerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenIndirectLayer, (::nn::sf::Out<::std::int64_t> outNativeWindowDataSize, const ::nn::sf::OutBuffer& outNativeWindowData, ::nn::vi::IndirectProducerHandleType producerHandle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenIndirectLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNativeWindowDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNativeWindowData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(producerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenIndirectLayer)
    }

    // nn::Result CloseIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseIndirectLayer, (::nn::vi::IndirectProducerHandleType producerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseIndirectLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(producerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseIndirectLayer)
    }

    // nn::Result FlipIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FlipIndirectLayer, (::nn::vi::IndirectProducerHandleType producerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FlipIndirectLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(producerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FlipIndirectLayer)
    }

    // nn::Result ListDisplayModes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayModeInfo>& outModes, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayModes, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::DisplayModeInfo>& outModes, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDisplayModes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outModes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDisplayModes)
    }

    // nn::Result ListDisplayRgbRanges(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::RgbRangeType>& outRanges, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayRgbRanges, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::RgbRangeType>& outRanges, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDisplayRgbRanges)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRanges)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDisplayRgbRanges)
    }

    // nn::Result ListDisplayContentTypes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::ContentTypeType>& outTypes, nn::vi::DisplayId dispayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDisplayContentTypes, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::vi::ContentTypeType>& outTypes, ::nn::vi::DisplayId dispayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDisplayContentTypes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTypes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dispayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDisplayContentTypes)
    }

    // nn::Result GetDisplayMode(nn::sf::Out<nn::vi::DisplayModeInfo> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayMode, (::nn::sf::Out<::nn::vi::DisplayModeInfo> outMode, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayMode)
    }

    // nn::Result SetDisplayMode(nn::vi::DisplayId displayId, const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayMode, (::nn::vi::DisplayId displayId, const ::nn::vi::DisplayModeInfo& mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayMode)
    }

    // nn::Result GetDisplayUnderscan(nn::sf::Out<std::int64_t> outUnderscan, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayUnderscan, (::nn::sf::Out<::std::int64_t> outUnderscan, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayUnderscan)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUnderscan)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayUnderscan)
    }

    // nn::Result SetDisplayUnderscan(nn::vi::DisplayId displayId, std::int64_t underscan) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayUnderscan, (::nn::vi::DisplayId displayId, ::std::int64_t underscan))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayUnderscan)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(underscan)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayUnderscan)
    }

    // nn::Result GetDisplayContentType(nn::sf::Out<nn::vi::ContentTypeType> outType, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayContentType, (::nn::sf::Out<::nn::vi::ContentTypeType> outType, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayContentType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayContentType)
    }

    // nn::Result SetDisplayContentType(nn::vi::DisplayId displayId, nn::vi::ContentTypeType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayContentType, (::nn::vi::DisplayId displayId, ::nn::vi::ContentTypeType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayContentType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayContentType)
    }

    // nn::Result GetDisplayRgbRange(nn::sf::Out<nn::vi::RgbRangeType> outRange, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayRgbRange, (::nn::sf::Out<::nn::vi::RgbRangeType> outRange, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayRgbRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayRgbRange)
    }

    // nn::Result SetDisplayRgbRange(nn::vi::DisplayId displayId, nn::vi::RgbRangeType range) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayRgbRange, (::nn::vi::DisplayId displayId, ::nn::vi::RgbRangeType range))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayRgbRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(range)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayRgbRange)
    }

    // nn::Result GetDisplayCmuMode(nn::sf::Out<nn::vi::CmuModeType> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayCmuMode, (::nn::sf::Out<::nn::vi::CmuModeType> outMode, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayCmuMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayCmuMode)
    }

    // nn::Result SetDisplayCmuMode(nn::vi::DisplayId displayId, nn::vi::CmuModeType mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayCmuMode, (::nn::vi::DisplayId displayId, ::nn::vi::CmuModeType mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayCmuMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayCmuMode)
    }

    // nn::Result GetDisplayContrastRatio(nn::sf::Out<float> outRatio, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayContrastRatio, (::nn::sf::Out<float> outRatio, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayContrastRatio)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRatio)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayContrastRatio)
    }

    // nn::Result SetDisplayContrastRatio(nn::vi::DisplayId displayId, float ratio) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayContrastRatio, (::nn::vi::DisplayId displayId, float ratio))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayContrastRatio)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ratio)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayContrastRatio)
    }

    // nn::Result GetDisplayGamma(nn::sf::Out<float> outGamma, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayGamma, (::nn::sf::Out<float> outGamma, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayGamma)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outGamma)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayGamma)
    }

    // nn::Result SetDisplayGamma(nn::vi::DisplayId displayId, float gamma) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayGamma, (::nn::vi::DisplayId displayId, float gamma))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayGamma)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(gamma)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayGamma)
    }

    // nn::Result GetDisplayCmuLuma(nn::sf::Out<float> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayCmuLuma, (::nn::sf::Out<float> outValue, ::nn::vi::DisplayId displayId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayCmuLuma)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayCmuLuma)
    }

    // nn::Result SetDisplayCmuLuma(nn::vi::DisplayId displayId, float value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDisplayCmuLuma, (::nn::vi::DisplayId displayId, float value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDisplayCmuLuma)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(displayId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDisplayCmuLuma)
    }

    // nn::Result GetSharedBufferMemoryHandleId(nn::sf::Out<nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, nn::sf::Out<std::uint64_t> outMemorySize, nn::sf::Out<nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedBufferMemoryHandleId, (::nn::sf::Out<::nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, ::nn::sf::Out<::std::uint64_t> outMemorySize, ::nn::sf::Out<::nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, ::nn::vi::fbshare::SharedBufferHandle hBuffer, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedBufferMemoryHandleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMemoryHandleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMemorySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLayout)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedBufferMemoryHandleId)
    }

    // nn::Result OpenSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSharedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSharedLayer)
    }

    // nn::Result CloseSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseSharedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseSharedLayer)
    }

    // nn::Result ConnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConnectSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConnectSharedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConnectSharedLayer)
    }

    // nn::Result DisconnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectSharedLayer, (::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisconnectSharedLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisconnectSharedLayer)
    }

    // nn::Result AcquireSharedFrameBuffer(nn::sf::Out<std::int64_t> outIndex, nn::sf::Out<nn::vi::native::NativeSync> outSync, nn::sf::Out<nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireSharedFrameBuffer, (::nn::sf::Out<::std::int64_t> outIndex, ::nn::sf::Out<::nn::vi::native::NativeSync> outSync, ::nn::sf::Out<::nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, ::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireSharedFrameBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIndexList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireSharedFrameBuffer)
    }

    // nn::Result PresentSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, const nn::vi::native::NativeSync& sync, const nn::vi::CropRegion& crop, nn::vi::ImageTransformType transform, std::int32_t presentInterval) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PresentSharedFrameBuffer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index, const ::nn::vi::native::NativeSync& sync, const ::nn::vi::CropRegion& crop, ::nn::vi::ImageTransformType transform, ::std::int32_t presentInterval))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PresentSharedFrameBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(crop)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transform)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(presentInterval)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PresentSharedFrameBuffer)
    }

    // nn::Result GetSharedFrameBufferAcquirableEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFrameBufferAcquirableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::vi::fbshare::SharedLayerHandle hLayer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedFrameBufferAcquirableEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedFrameBufferAcquirableEvent)
    }

    // nn::Result FillSharedFrameBufferColor(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, std::int32_t r, std::int32_t g, std::int32_t b, std::int32_t a) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FillSharedFrameBufferColor, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index, ::std::int32_t r, ::std::int32_t g, ::std::int32_t b, ::std::int32_t a))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FillSharedFrameBufferColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(r)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(g)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(b)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(a)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FillSharedFrameBufferColor)
    }

    // nn::Result CancelSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelSharedFrameBuffer, (::nn::vi::fbshare::SharedLayerHandle hLayer, ::std::int64_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelSharedFrameBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelSharedFrameBuffer)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::visrv::sf::ISystemDisplayService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::visrv::sf::ISystemDisplayService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetZOrderCountMin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetZOrderCountMin)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetZOrderCountMax)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetZOrderCountMax)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayLogicalResolution)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayLogicalResolution)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayMagnification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayMagnification)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(y),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLayerPosition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLayerPosition)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(y)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLayerSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLayerSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLayerZ)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLayerZ)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outZ),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLayerZ)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLayerZ)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(z)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLayerVisibility)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLayerVisibility)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isVisible)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLayerAlpha)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLayerAlpha)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(alpha)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateStrayLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNativeWindowData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateStrayLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLayerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNativeWindowDataSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNativeWindowData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(settings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNativeWindowData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenIndirectLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNativeWindowDataSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNativeWindowData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(producerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseIndirectLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(producerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FlipIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FlipIndirectLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(producerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDisplayModes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outModes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDisplayModes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outModes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDisplayRgbRanges)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outRanges)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDisplayRgbRanges)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outRanges),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDisplayContentTypes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outTypes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDisplayContentTypes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outTypes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dispayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayUnderscan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayUnderscan)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outUnderscan),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayUnderscan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayUnderscan)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(underscan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayContentType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayContentType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayContentType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayContentType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayRgbRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayRgbRange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRange),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayRgbRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayRgbRange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(range)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayCmuMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayCmuMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayCmuMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayCmuMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayContrastRatio)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayContrastRatio)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRatio),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayContrastRatio)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayContrastRatio)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ratio)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayGamma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayGamma)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outGamma),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayGamma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayGamma)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(gamma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayCmuLuma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayCmuLuma)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDisplayCmuLuma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDisplayCmuLuma)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(displayId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedBufferMemoryHandleId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outLayout)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedBufferMemoryHandleId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMemoryHandleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMemorySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outLayout),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSharedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseSharedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConnectSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConnectSharedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisconnectSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisconnectSharedLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireSharedFrameBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireSharedFrameBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIndexList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PresentSharedFrameBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PresentSharedFrameBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(crop),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transform),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(presentInterval)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedFrameBufferAcquirableEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedFrameBufferAcquirableEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FillSharedFrameBufferColor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FillSharedFrameBufferColor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(r),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(g),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(b),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(a)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelSharedFrameBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelSharedFrameBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hLayer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetZOrderCountMin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetZOrderCountMax)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayLogicalResolution)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayMagnification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLayerPosition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLayerSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLayerZ)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLayerZ)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLayerVisibility)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLayerAlpha)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateStrayLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FlipIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDisplayModes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDisplayRgbRanges)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDisplayContentTypes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayUnderscan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayUnderscan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayContentType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayContentType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayRgbRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayRgbRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayCmuMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayCmuMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayContrastRatio)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayContrastRatio)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayGamma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayGamma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayCmuLuma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDisplayCmuLuma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedBufferMemoryHandleId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConnectSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisconnectSharedLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireSharedFrameBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PresentSharedFrameBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedFrameBufferAcquirableEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FillSharedFrameBufferColor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelSharedFrameBuffer)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::visrv::sf::ISystemDisplayService))

namespace nn { namespace visrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemRootService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemRootService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel, ::nn::vi::ProxyName proxyName))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemRootService)

        ::nn::Result GetDisplayService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayService, (outService, policyLevel));
        }

        ::nn::Result GetDisplayServiceWithProxyNameExchange(::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel, ::nn::vi::ProxyName proxyName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (outService, policyLevel, proxyName));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemRootService
    {
    public:
        nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT;
        nn::Result GetDisplayServiceWithProxyNameExchange(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel, nn::vi::ProxyName proxyName) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT;
    nn::Result GetDisplayServiceWithProxyNameExchange(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel, nn::vi::ProxyName proxyName) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::visrv::sf::ISystemRootService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayService, (outService, policyLevel));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel, ::nn::vi::ProxyName proxyName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (outService, policyLevel, proxyName));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::visrv::sf::ISystemRootService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::visrv::sf::ISystemRootService))

    // nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(policyLevel, (::nn::vi::PolicyLevelType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (policyLevel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policyLevel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayService)

    // nn::Result GetDisplayServiceWithProxyNameExchange(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel, nn::vi::ProxyName proxyName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisplayServiceWithProxyNameExchange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(proxyName, (::nn::vi::ProxyName), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(policyLevel, (::nn::vi::PolicyLevelType), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (proxyName, policyLevel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policyLevel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(proxyName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisplayServiceWithProxyNameExchange)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::PolicyLevelType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::ProxyName), 8, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::visrv::sf::ISystemRootService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::visrv::sf::ISystemRootService))

    // nn::Result GetDisplayService(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policyLevel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayService)
    }

    // nn::Result GetDisplayServiceWithProxyNameExchange(nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService, nn::vi::PolicyLevelType policyLevel, nn::vi::ProxyName proxyName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisplayServiceWithProxyNameExchange, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>> outService, ::nn::vi::PolicyLevelType policyLevel, ::nn::vi::ProxyName proxyName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisplayServiceWithProxyNameExchange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policyLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(proxyName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisplayServiceWithProxyNameExchange)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::visrv::sf::ISystemRootService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::visrv::sf::ISystemRootService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(policyLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisplayServiceWithProxyNameExchange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisplayServiceWithProxyNameExchange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(policyLevel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(proxyName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisplayServiceWithProxyNameExchange)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::visrv::sf::ISystemRootService))
