﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/fbshare/vi_SharedBufferConfig.h>
#include <nn/vi/fbshare/vi_SharedTextureMemoryPool.h>
#include <nn/vi/fbshare/vi_SharedMemoryPoolLayout.h>

namespace nn{ namespace vi{ namespace fbshare{

    enum SharedTexturePoolState
    {
        SharedTexturePoolState_Invalid = 0,
        SharedTexturePoolState_Initialized,
    };

    enum SharedTextureState
    {
        SharedTextureState_Invalid = 0,
        SharedTextureState_Initialized,
    };

    class SharedTexturePool
    {
    public:
        static const int TextureCountMax = SharedBufferTextureCountMax;
    public:
        SharedTexturePool() NN_NOEXCEPT;

        static void SetupTextureBuilder(NVNtextureBuilder& texBuilder, NVNdevice* pDevice, int width, int height, NVNformat format, bool isCompressible) NN_NOEXCEPT;

        // @pre true
        bool IsInitialized() const NN_NOEXCEPT;

        // @pre pDevice != nullptr
        // @pre !IsInitialized
        // @pre memoryPool.IsInitialized()
        nn::Result Initialize(NVNdevice* pDevice, SharedTextureMemoryPool* pMemoryPool, const SharedMemoryPoolLayout& layout, NVNformat format) NN_NOEXCEPT;

        // @pre IsInitialized
        void Finalize() NN_NOEXCEPT;

        // @pre IsInitialized
        // index に対する初回呼び出しの際にテクスチャを初期化する。
        // 結果的に、使用中の SharedLayer にアタッチされているテクスチャだけ初期化される。
        nn::Result AcquireTexture(NVNtexture** pOutTexture, int index) NN_NOEXCEPT;

        // @pre IsInitialized
        // @pre index >= 0 && index < TextureCount
        // AcquireTexture() に対応して呼び出す。
        // 何もしない。
        void ReleaseTexture(int index) NN_NOEXCEPT;

        // @pre IsInitialized
        // テクスチャのインデックス(iBuf)を取得する。
        nn::Result GetTexutureIndex(int* pOutValue, const NVNtexture* pTexture) const NN_NOEXCEPT;

    private:
        // @pre TextureStateList[index] == Invalid
        // @post TextureStateList[index] == Initialized
        nn::Result CreateTextureImpl(int index) NN_NOEXCEPT;

        // @pre TextureStateList[index] == Initialized
        // @post TextureStateList[index] == Invalid
        void DestroyTextureImpl(int index) NN_NOEXCEPT;

    public:
        SharedTexturePoolState m_State;

        NVNdevice* m_pDevice;
        NVNformat m_Format;
        SharedTextureMemoryPool* m_pMemoryPool;
        SharedMemoryPoolLayout m_Layout;

        SharedTextureState m_TextureStateList[TextureCountMax];
        NVNtexture m_TextureList[TextureCountMax];


    };

}}}
