﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "vi_SharedBufferConfig.h"

namespace nn{ namespace vi{ namespace fbshare{

    typedef int32_t SharedLayerTextureIndexType;

    // アタッチ済のテクスチャインデックスのリスト。
    // 値は 0 番から順に書き込む。
    struct SharedLayerTextureIndexList
    {
    public:
        static const int IndexCountMax = NativeWindowTextureCountMax;

        typedef SharedLayerTextureIndexType IndexType;

    public:
        static IndexType GetInvalidIndex() NN_NOEXCEPT
        {
            return -1;
        }

        static SharedLayerTextureIndexList GetInvalidValue() NN_NOEXCEPT
        {
            SharedLayerTextureIndexList value;
            value.Reset();
            return value;
        }

        static SharedLayerTextureIndexList Get(IndexType index0, IndexType index1) NN_NOEXCEPT
        {
            auto value = GetInvalidValue();
            value[0] = index0;
            value[1] = index1;
            return value;
        }

        static SharedLayerTextureIndexList Get(IndexType index0, IndexType index1, IndexType index2) NN_NOEXCEPT
        {
            auto value = GetInvalidValue();
            value[0] = index0;
            value[1] = index1;
            value[2] = index2;
            return value;
        }

        static SharedLayerTextureIndexList Get(IndexType index0, IndexType index1, IndexType index2, IndexType index3) NN_NOEXCEPT
        {
            auto value = GetInvalidValue();
            value[0] = index0;
            value[1] = index1;
            value[2] = index2;
            value[3] = index3;
            return value;
        }

        void Reset() NN_NOEXCEPT
        {
            for(int iWin = 0; iWin < IndexCountMax; iWin++)
            {
                value[iWin] = GetInvalidIndex();
            }
        }

        int GetCount() const NN_NOEXCEPT
        {
            int count = 0;
            for(int iWin = 0; iWin < IndexCountMax; iWin++)
            {
                if(value[iWin] != GetInvalidIndex())
                {
                    count++;
                }
                else
                {
                    // 前詰めでなければならない
                    break;
                }
            }
            return count;
        }

        IndexType& operator[](int i) NN_NOEXCEPT
        {
            return value[i];
        }

        IndexType operator[](int i) const NN_NOEXCEPT
        {
            return value[i];
        }

    public:
        IndexType value[IndexCountMax];
    };

}}}
