﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/vi_Result.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>

#define NN_VI_GET_APPLICATION_SERVICE(var) \
    ::nn::sf::SharedPointer<::nn::visrv::sf::IApplicationDisplayService> var; \
    NN_RESULT_DO(::nn::vi::detail::ServiceReferenceHolder::GetApplicationService(&var));
#define NN_VI_GET_SYSTEM_SERVICE(var) \
    ::nn::sf::SharedPointer<::nn::visrv::sf::ISystemDisplayService> var; \
    NN_RESULT_DO(::nn::vi::detail::ServiceReferenceHolder::GetSystemService(&var));
#define NN_VI_GET_INDIRECT_LAYER_TABLE(var) \
    ::nn::vi::detail::IndirectLayerTable* var; \
    NN_RESULT_DO(::nn::vi::detail::ServiceReferenceHolder::GetIndirectLayerTable(&var));

namespace nn{ namespace vi{ namespace detail{
    class IndirectLayerTable;
}}}

namespace nn{ namespace vi{ namespace detail{

    class ServiceReferenceHolder
    {
    public:
        // Get
        static nn::Result GetApplicationService(nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>* pOutService) NN_NOEXCEPT;
        static nn::Result GetSystemService(nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>* pOutService) NN_NOEXCEPT;
        static nn::Result GetIndirectLayerTable(IndirectLayerTable** pOutTable) NN_NOEXCEPT;

        // Set
        static void SetApplicationService(const nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>& pService) NN_NOEXCEPT;
        static void SetSystemService(const nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>& pService) NN_NOEXCEPT;
        static void SetIndirectLayerTable(IndirectLayerTable* pTable) NN_NOEXCEPT;

        // Reset
        static void ResetApplicationService() NN_NOEXCEPT;
        static void ResetSystemService() NN_NOEXCEPT;
        static void ResetIndirectLayerTable() NN_NOEXCEPT;

    };

}}}
