﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_PmTypes.h
 * @brief   USB Port Manager Public Data Types
 */

#include <nn/usb/usb_Types.h>
#include <nn/usb/pd/usb_PdPdoRdo.h>

namespace nn {
namespace usb {

/**
 * @brief USB Power Role
 */
enum UsbPowerRole
{
    UsbPowerRole_Unknown,
    UsbPowerRole_Sink,
    UsbPowerRole_Source
};

enum UsbChargerType
{
    UsbChargerType_Unknown,       //< Unrecognized charger

    // Power Delivery
    UsbChargerType_Pd,            //< Type-C Power Delivery Port

    // Type-C Current
    UsbChargerType_TypeC15,       //< Type-C Current 1.5A
    UsbChargerType_TypeC30,       //< Type-C Current 3.0A

    // Bettery Charging
    UsbChargerType_Dcp,           //< Dedicated Charging Port
    UsbChargerType_Cdp,           //< Charging Downstream Port
    UsbChargerType_Sdp,           //< Standard Downstream port

    // Vendor
    UsbChargerType_Apple500ma,    //< Apple Charger 500ma
    UsbChargerType_Apple1000ma,   //< Apple Charger 1000ma
    UsbChargerType_Apple2000ma,   //< APple Charger 2000ma
};

/**
 * @brief USB Power State
 */
struct UsbPowerState
{
    UsbPowerRole          role;

    // valid only if role==UsbPowerRole_Sink
    UsbChargerType        charger;

    // valid only if charger!=UsbChargerType_Pd
    uint32_t              voltage;
    uint32_t              current;

    // valid only if charger==UsbChargerType_Pd
    nn::usb::pd::Pdo      pdo;
    nn::usb::pd::Rdo      rdo;
};

/**
 * @brief USB Data Role
 */
enum UsbDataRole
{
    UsbDataRole_Unknown,
    UsbDataRole_Host,
    UsbDataRole_Device
};

} // end of namespace usb
} // end of namespace nn
