﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_DiagTypes.h
 * @brief   USB Diagnostic Public Data Types
 */

namespace nn {
namespace usb {

enum LogLevel
{
    LogLevel_Trace = 0,
    LogLevel_Info,
    LogLevel_Warn,
    LogLevel_Error,

    LogLevel_Max
};

enum LogModule
{
    LogModule_Generic,
    LogModule_Shim,
    LogModule_HsXhci,
    LogModule_HsFsmHub,
    LogModule_HsFsmDevice,
    LogModule_HsFsmDeviceManager,
    LogModule_HsFsmCtrlXfer,

    LogModule_Max
};
static_assert(LogModule_Max < 32, "Support only 32 log modules");

enum DiagData
{
    DiagData_Debug,
    DiagData_LogLevel,
    DiagData_LogModule,

    DiagData_Max
};

} // end of namespace usb
} // end of namespace nn
