﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   UART ライブラリの初期化・終了機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace uart {

//! @name ライブラリの初期化・終了
//! @{

/**
 * @brief   UART ライブラリを初期化します。
 *
 * @post
 *  ライブラリは初期化済の状態になります。
 *
 * @details
 *  UART ライブラリを初期化します。@n
 *  本関数は二度以上呼ぶことができます。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief   UART ライブラリが初期化されているかどうかを返します。
 *
 * @return  ライブラリが初期化済かどうかを返します。
 * @retval  true    ライブラリは初期化済の状態です。
 * @retval  false   ライブラリは初期化されていません。
 *
 * @details
 *  UART ライブラリが初期化されているかどうかを返します。
 */
bool IsInitialized() NN_NOEXCEPT;

/**
 * @brief UART ライブラリを終了します。
 *
 * @pre
 *  ライブラリは 1 度以上初期化された状態である必要があります。@n
 *  Initialize() と同数だけ本関数が呼ばれた時、すべてのポートがクローズ状態である必要があります。
 *
 * @details
 *  UART ライブラリを終了します。@n
 *  @ref nn::uart::Initialize() と同数だけ本関数が呼ばれたとき、本関数はライブラリの終了処理を実行します。@n
 */
void Finalize() NN_NOEXCEPT;

//! @}

} // uart
} // nn


