﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/uart/uart_IPortSession.sfdl.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace uart { // NOLINT(whitespace/braces)

class IManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasPort, (::nn::sf::Out<bool> hasPort, ::std::int32_t name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasPortForDev, (::nn::sf::Out<bool> hasPort, ::std::int32_t portIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedBaudRate, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t baudRate))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedBaudRateForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t baudRate))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedFlowControlMode, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t flowControlMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedFlowControlModeForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t flowControlMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreatePortSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::uart::IPortSession>> outSession))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedPortEvent, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t portEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedPortEventForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t portEvent))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManager)

        ::nn::Result HasPort(::nn::sf::Out<bool> hasPort, ::std::int32_t name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasPort, (hasPort, name));
        }

        ::nn::Result HasPortForDev(::nn::sf::Out<bool> hasPort, ::std::int32_t portIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasPortForDev, (hasPort, portIndex));
        }

        ::nn::Result IsSupportedBaudRate(::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t baudRate) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSupportedBaudRate, (isSupported, name, baudRate));
        }

        ::nn::Result IsSupportedBaudRateForDev(::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t baudRate) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSupportedBaudRateForDev, (isSupported, portIndex, baudRate));
        }

        ::nn::Result IsSupportedFlowControlMode(::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t flowControlMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSupportedFlowControlMode, (isSupported, name, flowControlMode));
        }

        ::nn::Result IsSupportedFlowControlModeForDev(::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t flowControlMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSupportedFlowControlModeForDev, (isSupported, portIndex, flowControlMode));
        }

        ::nn::Result CreatePortSession(::nn::sf::Out<::nn::sf::SharedPointer<::nn::uart::IPortSession>> outSession) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreatePortSession, (outSession));
        }

        ::nn::Result IsSupportedPortEvent(::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t portEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSupportedPortEvent, (isSupported, name, portEvent));
        }

        ::nn::Result IsSupportedPortEventForDev(::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t portEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSupportedPortEventForDev, (isSupported, portIndex, portEvent));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManager
    {
    public:
        nn::Result HasPort(nn::sf::Out<bool> hasPort, std::int32_t name) NN_NOEXCEPT;
        nn::Result HasPortForDev(nn::sf::Out<bool> hasPort, std::int32_t portIndex) NN_NOEXCEPT;
        nn::Result IsSupportedBaudRate(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t baudRate) NN_NOEXCEPT;
        nn::Result IsSupportedBaudRateForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t baudRate) NN_NOEXCEPT;
        nn::Result IsSupportedFlowControlMode(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t flowControlMode) NN_NOEXCEPT;
        nn::Result IsSupportedFlowControlModeForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t flowControlMode) NN_NOEXCEPT;
        nn::Result CreatePortSession(nn::sf::Out<nn::sf::SharedPointer<nn::uart::IPortSession>> outSession) NN_NOEXCEPT;
        nn::Result IsSupportedPortEvent(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t portEvent) NN_NOEXCEPT;
        nn::Result IsSupportedPortEventForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t portEvent) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result HasPort(nn::sf::Out<bool> hasPort, std::int32_t name) NN_NOEXCEPT;
    nn::Result HasPortForDev(nn::sf::Out<bool> hasPort, std::int32_t portIndex) NN_NOEXCEPT;
    nn::Result IsSupportedBaudRate(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t baudRate) NN_NOEXCEPT;
    nn::Result IsSupportedBaudRateForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t baudRate) NN_NOEXCEPT;
    nn::Result IsSupportedFlowControlMode(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t flowControlMode) NN_NOEXCEPT;
    nn::Result IsSupportedFlowControlModeForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t flowControlMode) NN_NOEXCEPT;
    nn::Result CreatePortSession(nn::sf::Out<nn::sf::SharedPointer<nn::uart::IPortSession>> outSession) NN_NOEXCEPT;
    nn::Result IsSupportedPortEvent(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t portEvent) NN_NOEXCEPT;
    nn::Result IsSupportedPortEventForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t portEvent) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::uart::IManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasPort, (::nn::sf::Out<bool> hasPort, ::std::int32_t name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasPort, (hasPort, name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasPortForDev, (::nn::sf::Out<bool> hasPort, ::std::int32_t portIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasPortForDev, (hasPort, portIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedBaudRate, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t baudRate))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSupportedBaudRate, (isSupported, name, baudRate));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedBaudRateForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t baudRate))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSupportedBaudRateForDev, (isSupported, portIndex, baudRate));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedFlowControlMode, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t flowControlMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSupportedFlowControlMode, (isSupported, name, flowControlMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedFlowControlModeForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t flowControlMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSupportedFlowControlModeForDev, (isSupported, portIndex, flowControlMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreatePortSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::uart::IPortSession>> outSession))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreatePortSession, (outSession));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedPortEvent, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t portEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSupportedPortEvent, (isSupported, name, portEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedPortEventForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t portEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSupportedPortEventForDev, (isSupported, portIndex, portEvent));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::uart::IManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::uart::IManager))

    // nn::Result HasPort(nn::sf::Out<bool> hasPort, std::int32_t name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasPort)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (name))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(hasPort, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (hasPort))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hasPort), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasPort)

    // nn::Result HasPortForDev(nn::sf::Out<bool> hasPort, std::int32_t portIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasPortForDev)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portIndex, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (portIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(hasPort, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (hasPort))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hasPort), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasPortForDev)

    // nn::Result IsSupportedBaudRate(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t baudRate) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSupportedBaudRate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(baudRate, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (name, baudRate))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isSupported, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isSupported))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSupported), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(baudRate)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSupportedBaudRate)

    // nn::Result IsSupportedBaudRateForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t baudRate) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSupportedBaudRateForDev)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portIndex, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(baudRate, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (portIndex, baudRate))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isSupported, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isSupported))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSupported), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(baudRate)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSupportedBaudRateForDev)

    // nn::Result IsSupportedFlowControlMode(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t flowControlMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSupportedFlowControlMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flowControlMode, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (name, flowControlMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isSupported, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isSupported))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSupported), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flowControlMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSupportedFlowControlMode)

    // nn::Result IsSupportedFlowControlModeForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t flowControlMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSupportedFlowControlModeForDev)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portIndex, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flowControlMode, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (portIndex, flowControlMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isSupported, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isSupported))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSupported), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flowControlMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSupportedFlowControlModeForDev)

    // nn::Result CreatePortSession(nn::sf::Out<nn::sf::SharedPointer<nn::uart::IPortSession>> outSession) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreatePortSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSession)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreatePortSession)

    // nn::Result IsSupportedPortEvent(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t portEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSupportedPortEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portEvent, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (name, portEvent))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isSupported, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isSupported))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSupported), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSupportedPortEvent)

    // nn::Result IsSupportedPortEventForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t portEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSupportedPortEventForDev)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portIndex, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portEvent, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (portIndex, portEvent))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isSupported, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isSupported))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSupported), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSupportedPortEventForDev)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::uart::IManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::uart::IManager))

    // nn::Result HasPort(nn::sf::Out<bool> hasPort, std::int32_t name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasPort, (::nn::sf::Out<bool> hasPort, ::std::int32_t name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasPort)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hasPort)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasPort)
    }

    // nn::Result HasPortForDev(nn::sf::Out<bool> hasPort, std::int32_t portIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasPortForDev, (::nn::sf::Out<bool> hasPort, ::std::int32_t portIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasPortForDev)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hasPort)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasPortForDev)
    }

    // nn::Result IsSupportedBaudRate(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t baudRate) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedBaudRate, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t baudRate))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSupportedBaudRate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSupported)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(baudRate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSupportedBaudRate)
    }

    // nn::Result IsSupportedBaudRateForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t baudRate) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedBaudRateForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t baudRate))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSupportedBaudRateForDev)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSupported)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(baudRate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSupportedBaudRateForDev)
    }

    // nn::Result IsSupportedFlowControlMode(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t flowControlMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedFlowControlMode, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t flowControlMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSupportedFlowControlMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSupported)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flowControlMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSupportedFlowControlMode)
    }

    // nn::Result IsSupportedFlowControlModeForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t flowControlMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedFlowControlModeForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t flowControlMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSupportedFlowControlModeForDev)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSupported)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flowControlMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSupportedFlowControlModeForDev)
    }

    // nn::Result CreatePortSession(nn::sf::Out<nn::sf::SharedPointer<nn::uart::IPortSession>> outSession) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreatePortSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::uart::IPortSession>> outSession))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreatePortSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSession)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreatePortSession)
    }

    // nn::Result IsSupportedPortEvent(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t portEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedPortEvent, (::nn::sf::Out<bool> isSupported, ::std::int32_t name, ::std::int32_t portEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSupportedPortEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSupported)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSupportedPortEvent)
    }

    // nn::Result IsSupportedPortEventForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t portEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSupportedPortEventForDev, (::nn::sf::Out<bool> isSupported, ::std::int32_t portIndex, ::std::int32_t portEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSupportedPortEventForDev)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSupported)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSupportedPortEventForDev)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::uart::IManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::uart::IManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasPort)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasPort)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(hasPort),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasPortForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasPortForDev)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(hasPort),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSupportedBaudRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSupportedBaudRate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isSupported),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(baudRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSupportedBaudRateForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSupportedBaudRateForDev)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isSupported),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(baudRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSupportedFlowControlMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSupportedFlowControlMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isSupported),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flowControlMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSupportedFlowControlModeForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSupportedFlowControlModeForDev)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isSupported),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flowControlMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreatePortSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::uart::IPortSession>), outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreatePortSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSupportedPortEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSupportedPortEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isSupported),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSupportedPortEventForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSupportedPortEventForDev)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isSupported),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasPort)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasPortForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSupportedBaudRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSupportedBaudRateForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSupportedFlowControlMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSupportedFlowControlModeForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreatePortSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSupportedPortEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSupportedPortEventForDev)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::uart::IManager))
