﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include <nn/uart/uart_IManager.sfdl.h>
#include <nn/uart/uart_IPortSession.sfdl.h>

namespace nn { namespace uart { namespace server {

// IManager 実装クラス
class ManagerImpl
    : public nn::sf::ISharedObject
{

public:

    ManagerImpl() NN_NOEXCEPT;
    ~ManagerImpl() NN_NOEXCEPT;

    nn::Result HasPort(nn::sf::Out<bool> hasPort, std::int32_t name) NN_NOEXCEPT;
    nn::Result HasPortForDev(nn::sf::Out<bool> hasPort, std::int32_t portIndex) NN_NOEXCEPT;
    nn::Result IsSupportedBaudRate(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t baudRate) NN_NOEXCEPT;
    nn::Result IsSupportedBaudRateForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t baudRate) NN_NOEXCEPT;
    nn::Result IsSupportedFlowControlMode(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t flowControlMode) NN_NOEXCEPT;
    nn::Result IsSupportedFlowControlModeForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t flowControlMode) NN_NOEXCEPT;
    nn::Result IsSupportedPortEvent(nn::sf::Out<bool> isSupported, std::int32_t name, std::int32_t portEvent) NN_NOEXCEPT;
    nn::Result IsSupportedPortEventForDev(nn::sf::Out<bool> isSupported, std::int32_t portIndex, std::int32_t portEvent) NN_NOEXCEPT;
    nn::Result CreatePortSession(nn::sf::Out<nn::sf::SharedPointer<nn::uart::IPortSession>> outSession) NN_NOEXCEPT;

private:

    // OpenSession / OpenSessionForDev 用アロケータとして、
    // stateful な nn::sf::ExpHeapAllocator を使用する。
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    std::aligned_storage<8 * 1024>::type m_HeapBuffer;

    nn::lmem::HeapHandle m_HeapHandle;

};

}}}
