﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_StaticServiceServer.h>
#include <nn/timesrv/detail/util/timesrv_SfExpHeapAllocator.h>

#include <nn/sf/sf_HipcSimpleAllInOneServerManager.h>
#include <nn/sf/sf_ObjectFactory.h>


namespace nn
{
namespace timesrv
{
namespace detail
{
namespace service
{

class ServiceProvider;

const int SessionCountMax = 32;

// 1プロセスが
//  - 1 サブドメイン
//  - サブドメイン配下に 2 サービスオブジェクト
// を利用する想定で、同時に SessionCountMax 個のプロセスを許容できるようにする.
struct HipcSimpleAllInOneServerManagerOptions
{
    static const size_t PointerTransferBufferSize = 512; // 最大は nn::time::LocationName の 36 byte
    static const int SubDomainCountMax = SessionCountMax; // サブドメインの最大数
    static const int ObjectInSubDomainCountMax = SessionCountMax * 3; // 各サブドメインが登録できるサービスオブジェクトの合計最大数
};

// HipcSimpleAllInOneServerManager の SessionCountMax は実際に必要となる HIPC の2倍あれば足りる
class HipcServerManager : public ::nn::sf::HipcSimpleAllInOneServerManager<SessionCountMax * 2, 4, HipcSimpleAllInOneServerManagerOptions>
{
private:
    nn::timesrv::detail::util::SfExpHeapAllocator<4 * 1024> m_SfExpHeapAllocator;

    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceServer> m_UserStaticService;
    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceServer> m_AdminStaticService;
    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceServer> m_SystemStaticService;
    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceServer> m_RepairStaticService;

public:
    explicit HipcServerManager(ServiceProvider* pServiceProvider) NN_NOEXCEPT;
    ~HipcServerManager() NN_NOEXCEPT;
};

}
}
}
}
