﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  TIME内部実装のバイナリパスを扱う構造体の宣言
*/

#pragma once

#include <nn/time/time_Common.h>
#include <nn/util/util_StringUtil.h>

namespace nn { namespace timesrv { namespace detail { namespace fs {


/**
 * @brief   バイナリのパスを表す型
 * @details
 */
struct BinaryPath
{
    static const size_t Size = 256; //!< バイナリパスのサイズ
    char value[Size];

    friend bool operator == (const BinaryPath& lhs, const BinaryPath& rhs) NN_NOEXCEPT
    {
        return nn::util::Strncmp(lhs.value, rhs.value, Size) == 0;
    }

    friend bool operator != (const BinaryPath& lhs, const BinaryPath& rhs) NN_NOEXCEPT
    {
        return !(lhs == rhs);
    }
};

}}}} // nn::timesrv::detail::fs
