﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/timesrv/detail/core/timesrv_SystemClockCore.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

class SteadyClockCore;

/**
 * @brief   ローカルシステム時計のコア実装
 * @details
 *  本クラスはスレッドアンセーフです。
 *
 *  本クラスは永続データの Read/Write は行いません。
 *
 *  Initialize 実行後に利用可能になります。
 */
class StandardLocalSystemClockCore : public SystemClockCore
{
public:
    explicit StandardLocalSystemClockCore(SteadyClockCore* pSteadyClockCore) NN_NOEXCEPT;
    virtual ~StandardLocalSystemClockCore() NN_NOEXCEPT;

    /**
     * @brief   クロックの初期化
     * @param[in]   systemClockContext  前回起動時の SystemClockContext
     * @details
     *  systemClockContext のソース ID と、コンストラクタで指定した SteadyClockCore のソース ID が異なる場合、
     *  本時計は GetInitialPosixTime() の時刻に設定され、 SystemClockContext が更新されます。
     */
    void Initialize(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;

    static const nn::time::PosixTime SettablePosixTimeMin;
    static const nn::time::PosixTime SettablePosixTimeMax;
    static nn::time::PosixTime GetInitialPosixTime() NN_NOEXCEPT; // テスト用に公開
};

}
}
}
}
