﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/time/time_SystemClockContext.h>
#include <nn/time/detail/time_CommonDetail.h>
#include <nn/time/detail/time_SharedMemoryType.h>

namespace nn { namespace timesrv { namespace detail { namespace core {

class SharedMemoryManager
{
public:
    SharedMemoryManager() NN_NOEXCEPT;

    nn::os::NativeHandle GetHandle() const NN_NOEXCEPT
    {
        return m_SharedMemory.GetHandle();
    }

    void SetStandardSteadyClockTimePoint(const nn::time::SourceId& sourceId, const nn::TimeSpan& value) NN_NOEXCEPT;
    void SetStandardSteadyClockTimePointValue(const nn::TimeSpan& value) NN_NOEXCEPT;
    void SetStandardLocalSystemClockContext(const nn::time::SystemClockContext& value) NN_NOEXCEPT;
    void SetStandardNetworkSystemClockContext(const nn::time::SystemClockContext& value) NN_NOEXCEPT;
    void SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT;

private:
    nn::os::SharedMemory m_SharedMemory;
    nn::time::detail::SharedMemoryClockSettings* m_pSharedMemoryClockSettings;
};

}}}}
