﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  SteadyClock プライベート API の宣言
*/

#pragma once

#include <nn/time.h>
#include <nn/nn_TimeSpan.h>

namespace nn
{
namespace time
{

//! @name 一般権限で利用可能な SteadyClock プライベート API
//! @{

/**
 * @brief   StandardSteadyClock のセットアップ時の Result 値を取得します。
 * @return  Result の値
 * @pre
 *  - TIME ライブラリが初期化されている
 *
 * @details
 *  システム起動時に行われる StandardSteadyClock のセットアップ処理内部で発生した Result の、
 *  nn::Result::GetInnerValueForDebug() で得られる値を返します。
 */
uint32_t GetStandardSteadyClockSetupResultValue() NN_NOEXCEPT;

/**
 * @brief   StandardSteadyClock の内部オフセットを取得します。
 * @return  内部オフセット
 * @pre
 *  - TIME ライブラリが初期化されている
 */
nn::TimeSpan GetStandardSteadyClockInternalOffset() NN_NOEXCEPT;

/**
 * @brief   StandardSteadyClock のテスト用オフセットを取得します。
 * @return  テスト用オフセット
 * @pre
 *  - TIME ライブラリが初期化されている
 */
nn::TimeSpan GetStandardSteadyClockTestOffset() NN_NOEXCEPT;

/**
 * @brief   StandardSteadyClock の RTC の値を取得します。(デバッグ用)
 * @return  RTC の値
 * @pre
 *  - TIME ライブラリが初期化されている
 *
 * @details
 *  この関数は RTC デバイスへアクセスするため数十msecかかり、
 *  その間 Time IPC スレッドをブロックします。
 */
int64_t GetStandardSteadyClockRtcValue() NN_NOEXCEPT;

//! @}

}
}

