﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief システム電源状態に関連して TC ライブラリの挙動を TC サーバから変更するための API 宣言。
 */

#pragma once

#include "tc_PowerModeTypes.h"

namespace nn { namespace tc { namespace impl {

//! @name TC ライブラリの挙動を TC サーバから変更するための API。
//! @{

/**
 * @brief       TC ライブラリにシステム電源状態の遷移を通知します。
 *
 * @param[in]   powerMode システム電源状態を表します。
 *
 * @details     TC ライブラリにシステム電源状態の遷移を通知します。@n
 *              この関数の完了を以て TC ライブラリがシステム電源状態に対応した状態であることを保証します。
 */
void SetPowerMode(PowerMode powerMode) NN_NOEXCEPT;

//! @}
// ~TC ライブラリの挙動を TC サーバから変更するための API。

}}} // namepsace nn::tc::impl
