﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

// ------------------------------------------------------------------------------------------------
// Build environment
// ------------------------------------------------------------------------------------------------
// Enable Nintendo Service Discovery
#define NN_DETAIL_SSL_BUILD_ENABLE_NINTENDO_SERVICE_DISCOVERY

// [Device unique private key decryption]
// This is for SIGLONTD-7745, use the same key to decrypt the device unique private key
#define NN_DETAIL_SSL_USE_DEV_KEY_FOR_PROD_DEVICE_PRIVATE_KEY_DECRYPTION

// [Session cache handling]
// Flush session cache when the connection is closed
//#define NN_DETAIL_SSL_BUILD_FORCE_SESSION_CACHE_FLUSH_UPON_CONN_CLOSE

// [CRL testing]
//#define NN_DETAIL_DEBUG_CRL_WITH_NTD_TEST_SERVER

// ------------------------------------------------------------------------------------------------
// Debug print flags
// NN_DETAIL_SSL_ENABLE_DEBUG_PRINT    : Prints normal debug information
// NN_DETAIL_SSL_ENABLE_DEBUG_PRINT_IO : Prints debug information for I/O requests too
// NN_DETAIL_SSL_ENABLE_ERROR_PRINT    : Prints errors details when converting between NSPR errors and SSL
// NN_DETAIL_SSL_DBG_PRINT_CERTSTORE   : Prints debug information regarding certstore manipulation
// NN_DETAIL_SSL_DBG_PRINT_PEER_CERT_INFO  : Dump the peer cert info
// NN_DETAIL_SSL_DBG_PRINT_PEER_CERT       : Dump the public key inside peer cert
// NN_DETAIL_SSL_DBG_PRINT_PEER_PUBLIC_KEY : Dump the peer cert data
// NN_DETAIL_SSL_DBG_PRINT_CERT_CHAIN_UPON_VERIFY_FAILURE : Dump detailed validation failure
// ------------------------------------------------------------------------------------------------
//#define NN_DETAIL_SSL_ENABLE_DEBUG_PRINT
//#define NN_DETAIL_SSL_ENABLE_DEBUG_PRINT_IO
//#define NN_DETAIL_SSL_ENABLE_ERROR_PRINT
//#define NN_DETAIL_SSL_DBG_PRINT_CERTSTORE
//#define NN_DETAIL_SSL_DBG_PRINT_PEER_CERT_INFO
//#define NN_DETAIL_SSL_DBG_PRINT_PEER_CERT
//#define NN_DETAIL_SSL_DBG_PRINT_PEER_PUBLIC_KEY
//#define NN_DETAIL_SSL_DBG_PRINT_CERT_CHAIN_UPON_VERIFY_FAILURE
//#define NN_DETAIL_SSL_DBG_PRINT_NSS

// ------------------------------------------------------------------------------------------------
// TODO: Temporally
// ------------------------------------------------------------------------------------------------
#ifdef NN_BUILD_CONFIG_OS_WIN32
#pragma warning( disable:4668) // C4668: '__GNUC__' is not defined as a preprocessor
#endif

// ------------------------------------------------------------------------------------------------
// Build parameters
// ------------------------------------------------------------------------------------------------
#ifdef __cplusplus
namespace nn { namespace ssl { namespace detail {

enum BuildParameter
{
    BuildParameter_MemoryManagerHeapSizeHorizonProcess = 1024 * 64,
    BuildParameter_MemoryManagerHeapSizeHorizonLibrary = 1024 * 8,
    BuildParameter_MemoryManagerHeapSizeWindows        = 1024 * 64,
};

}}}
#endif // #ifdef __cplusplus
