﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_ApplicationId.h>
#include <nn/account/account_Types.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/srepo/srepo_Types.h>
#include <nn/srepo/srepo_Result.h>

namespace nn { namespace srepo {

/*!
    @name   レポートデータ取得
    @{
*/

/*!
    @brief      バッファに保存されたレポートデータを 1 個取り出します。

    @param[out] outCategory             取り出した分類。
    @param[out] outUid                  取り出したユーザーアカウント。
    @param[out] outEventIdBuffer        取り出したイベント ID。
    @param[out] outAppId                取り出したアプリケーション ID。
    @param[out] outDataSize             取り出したデータのサイズ。
    @param[out] outDataBuffer           取り出したデータ。
    @param[in]  outEventIdBufferSize    @a outEventIdBuffer のサイズ。
    @param[in]  outDataBufferSize       @a outDataBuffer のサイズ。

    @return     処理結果。

    @pre
        - outCategory != nullptr
        - outUid != nullptr
        - outEventIdBuffer != nullptr
        - outAppId != nullptr
        - outDataSize != nullptr
        - outDataBuffer != nullptr
        - outEventIdBufferSize > 0
        - outDataBufferSize > 0

    @details
                取り出したレポートはバッファから削除されます。
*/
nn::Result PopReport(ReportCategory* outCategory, nn::account::Uid* outUid, char* outEventIdBuffer, nn::ApplicationId* outAppId, size_t* outDataSize, void* outDataBuffer, size_t outEventIdBufferSize, size_t outDataBufferSize) NN_NOEXCEPT;


/*!
    @brief      レポートデータが追加されたときにシグナルされるシステムイベントを登録します。

    @param[out] pEvent      登録するシステムイベント。
    @param[out] clearMode   登録するシステムイベントのクリアモード。

    @return     処理結果。

    @pre
        - pEvent != nullptr

    @details
                システム全体でひとつだけ登録することができます。
*/
nn::Result RegisterPushEvent(nn::os::SystemEvent* pEvent, nn::os::EventClearMode clearMode) NN_NOEXCEPT;

/*!
    @}
*/

}}
