﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       タイムゾーン設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/time/time_LocationName.h>
#include <nn/time/time_SteadyClockTimePoint.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       デバイスの地域名(タイムゾーン名)を取得します。
 *
 * @param[out]  pOutValue                   地域名を読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetDeviceTimeZoneLocationName(nn::time::LocationName* pOutValue
                                 ) NN_NOEXCEPT;

/**
 * @brief       デバイスの地域名(タイムゾーン名)を変更します。
 *
 * @param[in]   value                       地域名
 */
void SetDeviceTimeZoneLocationName(const nn::time::LocationName& value
                                 ) NN_NOEXCEPT;

/**
 * @brief       デバイスの地域更新時間を取得します。
 *
 * @param[out]  pOutValue                   更新時間を読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetDeviceTimeZoneLocationUpdatedTime(
    nn::time::SteadyClockTimePoint* pOutValue
    ) NN_NOEXCEPT;

/**
 * @brief       デバイスの地域更新時間を変更します。
 *
 * @param[in]   value                       更新時間
 */
void SetDeviceTimeZoneLocationUpdatedTime(
    const nn::time::SteadyClockTimePoint& value
    ) NN_NOEXCEPT;

}}} // nn::settings::system
