﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ネットワークサービスに関する設定 API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       本体情報アップロードが有効か否かを表す値を返します。
 *
 * @return      本体情報アップロードが有効か否かを表す値です。
 */
bool GetConsoleInformationUploadFlag() NN_NOEXCEPT;

/**
 * @brief       本体情報アップロードが有効か否かを表す値を設定します。
 *
 * @param[in]   value                       本体情報アップロードが有効か否かを表す値
 */
void SetConsoleInformationUploadFlag(bool value) NN_NOEXCEPT;

}}} // nn::settings::system
