﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   アカウントに関するシステムアプリケーション向け設定 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       アカウント選択の制御フラグ定義です。
 */
struct UserSelectorFlag
{
    /**
     * @brief       アカウントが一つの場合にアカウント選択を省略するか否かを表すフラグです。
     */
    typedef ::nn::util::BitFlagSet<32, UserSelectorFlag>::Flag<0> SkipsIfSingleUser;
};

/**
 * @brief       アカウント選択の制御フラグ集合を扱う型です。
 */
typedef ::nn::util::BitFlagSet<32, UserSelectorFlag> UserSelectorFlagSet;

/**
 * @brief       アカウント選択の設定を表す構造体です。
 */
struct UserSelectorSettings
{
    UserSelectorFlagSet flags;  //!< 制御フラグ
};

/**
 * @brief       アカウント設定を表す構造体です。
 */
struct AccountSettings
{
    UserSelectorSettings userSelectorSettings;  //!< アカウント選択の設定
};

//! @name アカウント設定関連 API
//! @{

/**
 * @brief       アカウント設定を取得します。
 *
 * @details     アカウント設定として指定されている値を取得します。
 *
 * @param[out]  pOutValue                   アカウント設定を読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetAccountSettings(AccountSettings* pOutValue) NN_NOEXCEPT;

/**
 * @brief       アカウント設定を変更します。
 *
 * @details     アカウント設定を指定された値に変更します。
 *
 * @param[in]   value                       アカウント設定
 */
void SetAccountSettings(const AccountSettings& value) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
