﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   キーボード設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace settings {

/**
 * @brief       キーボード配列の種別を表す列挙体です。
 */
enum KeyboardLayout
{
    KeyboardLayout_Japanese,                //!< 日本語
    KeyboardLayout_EnglishUs,               //!< 英語 (アメリカ)
    KeyboardLayout_EnglishUsInternational,  //!< 英語 (US-International)
    KeyboardLayout_EnglishUk,               //!< 英語 (イギリス)
    KeyboardLayout_French,                  //!< フランス語
    KeyboardLayout_FrenchCa,                //!< フランス語 (カナダ)
    KeyboardLayout_Spanish,                 //!< スペイン語
    KeyboardLayout_SpanishLatin,            //!< スペイン語 (ラテンアメリカ)
    KeyboardLayout_German,                  //!< ドイツ語
    KeyboardLayout_Italian,                 //!< イタリア語
    KeyboardLayout_Portuguese,              //!< ポルトガル語
    KeyboardLayout_Russian,                 //!< ロシア語
    KeyboardLayout_Korean,                  //!< 韓国語
    KeyboardLayout_ChineseSimplified,       //!< 簡体字中国語
    KeyboardLayout_ChineseTraditional,      //!< 繁体字中国語
};

//! @name キーボード設定関連 API
//! @{

/**
 * @brief       アプリケーション側で保持するキーボード配列の種別をシステムに伝えます。
 *
 * @details     ソフトウェアキーボードアプレットとアプリケーションによる独自対応とでキーボード配列を合わせたい場合に使用します。
 *
 * @param[in]   value                       キーボード配列の種別
 */
void SetApplicationOwnKeyboardLayout(KeyboardLayout value) NN_NOEXCEPT;

//! @}

}} // nn::settings
