﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ファームウェアデバッグ設定に関する Setter 向け API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/fwdbg/settings_SettingsCommon.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace settings { namespace fwdbg {

/**
 * @brief       設定項目へ値を設定します。
 *
 * @details     指定された設定のキーと対応する設定項目へ値を書き込みます。
 *
 * @param[in]   name                            設定の名前
 * @param[in]   key                             設定項目のキー
 * @param[in]   pValue                          書き込む値を指すポインタ
 * @param[in]   valueSize                       書き込む値のバイト数
 *
 * @pre
 *              - name != nullptr
 *              - 0 < strlen(name) && strlen(name) <= SettingsNameLengthMax
 *              - name に対応する設定が存在
 *              - key != nullptr
 *              - 0 < strlen(key) && strlen(key) <= SettingsItemKeyLengthMax
 *              - key に対応する設定項目が存在
 *              - pValue != nullptr
 */
void SetSettingsItemValue(const char* name,
                          const char* key,
                          const void* pValue,
                          size_t valueSize) NN_NOEXCEPT;

/**
 * @brief       設定項目の値をリセットします。
 *
 * @details     指定された設定のキーと対応する設定項目の値をデフォルト値にリセットします。
 *
 * @param[in]   name                            設定の名前
 * @param[in]   key                             設定項目のキー
 *
 * @pre
 *              - name != nullptr
 *              - 0 < strlen(name) && strlen(name) <= SettingsNameLengthMax
 *              - name に対応する設定が存在
 *              - key != nullptr
 *              - 0 < strlen(key) && strlen(key) <= SettingsItemKeyLengthMax
 *              - key に対応する設定項目が存在
 */
void ResetSettingsItemValue(const char* name, const char* key) NN_NOEXCEPT;

}}} // namespace nn::settings::fwdbg
