﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      sasbus モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_SASBUS_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_SASBUS_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_SASBUS_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_SASBUS_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_SASBUS_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_SASBUS_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sasbus, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_SASBUS_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Trace, 0, format, args)
#define NN_DETAIL_SASBUS_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Trace, 1, format, args)
#define NN_DETAIL_SASBUS_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Trace, 2, format, args)
#define NN_DETAIL_SASBUS_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Trace, 3, format, args)

#define NN_DETAIL_SASBUS_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Info, 0, format, args)
#define NN_DETAIL_SASBUS_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Info, 1, format, args)
#define NN_DETAIL_SASBUS_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Info, 2, format, args)
#define NN_DETAIL_SASBUS_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Info, 3, format, args)

#define NN_DETAIL_SASBUS_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Warn, 0, format, args)
#define NN_DETAIL_SASBUS_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Warn, 1, format, args)
#define NN_DETAIL_SASBUS_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Warn, 2, format, args)
#define NN_DETAIL_SASBUS_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Warn, 3, format, args)

#define NN_DETAIL_SASBUS_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Error, 0, format, args)
#define NN_DETAIL_SASBUS_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Error, 1, format, args)
#define NN_DETAIL_SASBUS_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Error, 2, format, args)
#define NN_DETAIL_SASBUS_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Error, 3, format, args)

#define NN_DETAIL_SASBUS_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Fatal, 0, format, args)
#define NN_DETAIL_SASBUS_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Fatal, 1, format, args)
#define NN_DETAIL_SASBUS_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Fatal, 2, format, args)
#define NN_DETAIL_SASBUS_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sasbus, Fatal, 3, format, args)

#define NN_DETAIL_SASBUS_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Trace, 0, text, length)
#define NN_DETAIL_SASBUS_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Trace, 1, text, length)
#define NN_DETAIL_SASBUS_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Trace, 2, text, length)
#define NN_DETAIL_SASBUS_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Trace, 3, text, length)

#define NN_DETAIL_SASBUS_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Info, 0, text, length)
#define NN_DETAIL_SASBUS_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Info, 1, text, length)
#define NN_DETAIL_SASBUS_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Info, 2, text, length)
#define NN_DETAIL_SASBUS_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Info, 3, text, length)

#define NN_DETAIL_SASBUS_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Warn, 0, text, length)
#define NN_DETAIL_SASBUS_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Warn, 1, text, length)
#define NN_DETAIL_SASBUS_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Warn, 2, text, length)
#define NN_DETAIL_SASBUS_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Warn, 3, text, length)

#define NN_DETAIL_SASBUS_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Error, 0, text, length)
#define NN_DETAIL_SASBUS_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Error, 1, text, length)
#define NN_DETAIL_SASBUS_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Error, 2, text, length)
#define NN_DETAIL_SASBUS_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Error, 3, text, length)

#define NN_DETAIL_SASBUS_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Fatal, 0, text, length)
#define NN_DETAIL_SASBUS_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Fatal, 1, text, length)
#define NN_DETAIL_SASBUS_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Fatal, 2, text, length)
#define NN_DETAIL_SASBUS_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sasbus, Fatal, 3, text, length)
