﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   PWM ドライバライブラリの API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace pwm {
namespace driver {

/**
 * @brief PWM ドライバライブラリを初期化します。
 *
 * @post        ライブラリは初期化済の状態になります。
 *
 * @details     PWM ドライバライブラリを初期化します。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief PWM ドライバライブラリを終了します。
 *
 * @post        ライブラリは初期化前の状態になります。
 *
 * @details     PWM ドライバライブラリを終了します。
 */
void Finalize() NN_NOEXCEPT;

} // driver
} // pwm
} // nn
