﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      pwm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PWM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PWM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PWM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PWM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PWM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PWM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PWM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PWM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PWM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PWM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PWM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PWM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PWM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PWM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PWM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PWM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PWM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PWM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PWM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PWM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pwm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PWM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Trace, 0, format, args)
#define NN_DETAIL_PWM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Trace, 1, format, args)
#define NN_DETAIL_PWM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Trace, 2, format, args)
#define NN_DETAIL_PWM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Trace, 3, format, args)

#define NN_DETAIL_PWM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Info, 0, format, args)
#define NN_DETAIL_PWM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Info, 1, format, args)
#define NN_DETAIL_PWM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Info, 2, format, args)
#define NN_DETAIL_PWM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Info, 3, format, args)

#define NN_DETAIL_PWM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Warn, 0, format, args)
#define NN_DETAIL_PWM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Warn, 1, format, args)
#define NN_DETAIL_PWM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Warn, 2, format, args)
#define NN_DETAIL_PWM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Warn, 3, format, args)

#define NN_DETAIL_PWM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Error, 0, format, args)
#define NN_DETAIL_PWM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Error, 1, format, args)
#define NN_DETAIL_PWM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Error, 2, format, args)
#define NN_DETAIL_PWM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Error, 3, format, args)

#define NN_DETAIL_PWM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Fatal, 0, format, args)
#define NN_DETAIL_PWM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Fatal, 1, format, args)
#define NN_DETAIL_PWM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Fatal, 2, format, args)
#define NN_DETAIL_PWM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pwm, Fatal, 3, format, args)

#define NN_DETAIL_PWM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Trace, 0, text, length)
#define NN_DETAIL_PWM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Trace, 1, text, length)
#define NN_DETAIL_PWM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Trace, 2, text, length)
#define NN_DETAIL_PWM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Trace, 3, text, length)

#define NN_DETAIL_PWM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Info, 0, text, length)
#define NN_DETAIL_PWM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Info, 1, text, length)
#define NN_DETAIL_PWM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Info, 2, text, length)
#define NN_DETAIL_PWM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Info, 3, text, length)

#define NN_DETAIL_PWM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Warn, 0, text, length)
#define NN_DETAIL_PWM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Warn, 1, text, length)
#define NN_DETAIL_PWM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Warn, 2, text, length)
#define NN_DETAIL_PWM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Warn, 3, text, length)

#define NN_DETAIL_PWM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Error, 0, text, length)
#define NN_DETAIL_PWM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Error, 1, text, length)
#define NN_DETAIL_PWM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Error, 2, text, length)
#define NN_DETAIL_PWM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Error, 3, text, length)

#define NN_DETAIL_PWM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Fatal, 0, text, length)
#define NN_DETAIL_PWM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Fatal, 1, text, length)
#define NN_DETAIL_PWM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Fatal, 2, text, length)
#define NN_DETAIL_PWM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pwm, Fatal, 3, text, length)
