﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PSM ライブラリの本体機能用の API 宣言。
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/psm/psm_SystemTypes.h>

namespace nn { namespace psm {

/**
 * @brief      電池残量を取得します。
 * @return     電池残量 [%]
 * @pre
 *  - PSM ライブラリが初期化済の状態である
 * @details    電池残量を 1 % から 100 % までの 1 % 刻みで取得します。
 */
int GetBatteryChargePercentage() NN_NOEXCEPT;

/**
 * @brief      本体に接続されている充電器の種別を取得します。
 * @return     本体に接続されている充電器の種別
 * @pre
 *  - PSM ライブラリが初期化済の状態である
 * @details    本体に接続されている充電器の種別を取得します。
 *             本関数は本体に充電器が接続されていないときも呼び出すことができ、
 *             その場合には ChargerType_Unconnected が取得できます。
 */
ChargerType GetChargerType() NN_NOEXCEPT;

/**
 * @brief      本体に接続されている充電器の変化とイベントを紐付けます。
 * @param[in]  pEvent   本体に接続されている充電器が変化したときシグナル化するイベント
 * @pre
 *  - PSM ライブラリが初期化済の状態である
 * @details    本体に接続されている充電器の変化とイベントを紐付けます。
 *             イベントのクリアモードは手動クリアです。
 */
void GetChargerTypeChangeEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;

}} // namespace nn::psm
