﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/prepo_Types.h>
#include <nn/bgtc/bgtc_Types.h>
#include <nn/account/account_types.h>

namespace nn { namespace prepo { namespace service {

/*!
    @brief      サーバーの実行を開始します。
*/
void StartServer() NN_NOEXCEPT;

/*!
    @brief      サーバーの実行を停止します。
*/
void StopServer() NN_NOEXCEPT;

/*!
    @brief      スリープ中、半起床状態に遷移してタスクの処理を行う予定時刻を取得します。

    @param[out] outSeconds  予定時刻までの時間間隔。

    @return     スリープ中に処理したいタスクが存在するかどうか。

    @pre
        - outSeconds != nullptr
*/
bool GetHalfAwakeScheduleInterval(nn::bgtc::Interval* outSeconds) NN_NOEXCEPT;

/*!
    @brief      システムが半起床状態になったことを通知します。
*/
void NotifySystemHalfAwaked() NN_NOEXCEPT;

/*!
    @brief      システムが全起床状態になったことを通知します。
*/
void NotifySystemFullAwaked() NN_NOEXCEPT;

/*!
    @brief      システムがスリープに入る準備を行ったことを通知します。

    @param[in]  isFromFullAwake 全起床状態からのスリープかどうか。
*/
void NotifySystemSleepReady(bool isFromFullAwake) NN_NOEXCEPT;

/*!
    @brief      システムがシャットダウンする準備を行ったことを通知します。
*/
void NotifySystemShutdownReady() NN_NOEXCEPT;

/*!
    @brief      スリープ準備完了まで待機します。
*/
void WaitForSleepReady() NN_NOEXCEPT;

/*!
    @brief      シャットダウン準備完了まで待機します。
*/
void WaitForShutdownReady() NN_NOEXCEPT;

/*!
    @brief      バックグラウンド通信用の接続が行われたことを通知します。
*/
void NotifyNetworkConnected() NN_NOEXCEPT;

/*!
    @brief      ニンテンドーアカウントの情報のキャッシュの更新処理の結果を通知します。
*/
void NotifyUpdateNintendoAccountCacheResult(const nn::account::Uid& uid, nn::Result result) NN_NOEXCEPT;

}}}
