﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/prepo_Types.h>

namespace nn { namespace prepo { namespace detail {

/*!
    @brief      レポートデータのファイルの最大サイズです。
*/
const size_t ReportFileSizeMax = 128 * 1024;

/*!
    @brief      レポートファイルのヘッダサイズです。

    @details
                レポートファイルはファイルの先頭に、プレイレポートの要素数を array 16 形式で格納します。@n
                array 16 のヘッダイサイズは 3 Byte です。そのため、レポートファイルのヘッダサイズは 3 Byte です。
*/
const size_t ReportFileHeaderSize = 3;

/*!
    @brief      msgpack に保存する Extension のデータ種別です。
*/
enum MsgpackExtensionType : Bit8
{
    MsgpackExtensionType_Any64BitId = 0 //!< 任意の 64 ビット長の ID。
};

}}}
