﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/settings/settings_Language.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace pl { namespace detail { // NOLINT(whitespace/braces)

class ISharedFontManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISharedFontManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISharedFontManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLoad, (::std::int32_t sharedFontType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLoadState, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> loadState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryAddressOffset, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFontInOrderOfPriority, (::nn::sf::Out<bool> outAllFontLoaded, ::nn::sf::Out<::std::int32_t> outFontCount, const ::nn::sf::OutArray<::std::int32_t>& outTypes, const ::nn::sf::OutArray<::std::int32_t>& outOffsets, const ::nn::sf::OutArray<::std::int32_t>& outSizes, ::nn::settings::LanguageCode languageCode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFontInOrderOfPriorityForSystem, (::nn::sf::Out<bool> outAllFontLoaded, ::nn::sf::Out<::std::int32_t> outFontCount, const ::nn::sf::OutArray<::std::int32_t>& outTypes, const ::nn::sf::OutArray<::std::int32_t>& outOffsets, const ::nn::sf::OutArray<::std::int32_t>& outSizes, ::nn::settings::LanguageCode languageCode))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISharedFontManager)

        ::nn::Result RequestLoad(::std::int32_t sharedFontType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < nn::pl::SharedFontType_Max), sharedFontType)), "_ >= 0 && _ < nn::pl::SharedFontType_Max (where _ = sharedFontType)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLoad, (sharedFontType));
        }

        ::nn::Result GetLoadState(::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> loadState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < nn::pl::SharedFontType_Max), sharedFontType)), "_ >= 0 && _ < nn::pl::SharedFontType_Max (where _ = sharedFontType)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLoadState, (sharedFontType, loadState));
        }

        ::nn::Result GetSize(::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < nn::pl::SharedFontType_Max), sharedFontType)), "_ >= 0 && _ < nn::pl::SharedFontType_Max (where _ = sharedFontType)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSize, (sharedFontType, size));
        }

        ::nn::Result GetSharedMemoryAddressOffset(::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < nn::pl::SharedFontType_Max), sharedFontType)), "_ >= 0 && _ < nn::pl::SharedFontType_Max (where _ = sharedFontType)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedMemoryAddressOffset, (sharedFontType, offset));
        }

        ::nn::Result GetSharedMemoryNativeHandle(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (outHandle));
        }

        ::nn::Result GetSharedFontInOrderOfPriority(::nn::sf::Out<bool> outAllFontLoaded, ::nn::sf::Out<::std::int32_t> outFontCount, const ::nn::sf::OutArray<::std::int32_t>& outTypes, const ::nn::sf::OutArray<::std::int32_t>& outOffsets, const ::nn::sf::OutArray<::std::int32_t>& outSizes, ::nn::settings::LanguageCode languageCode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedFontInOrderOfPriority, (outAllFontLoaded, outFontCount, outTypes, outOffsets, outSizes, languageCode));
        }

        ::nn::Result GetSharedFontInOrderOfPriorityForSystem(::nn::sf::Out<bool> outAllFontLoaded, ::nn::sf::Out<::std::int32_t> outFontCount, const ::nn::sf::OutArray<::std::int32_t>& outTypes, const ::nn::sf::OutArray<::std::int32_t>& outOffsets, const ::nn::sf::OutArray<::std::int32_t>& outSizes, ::nn::settings::LanguageCode languageCode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedFontInOrderOfPriorityForSystem, (outAllFontLoaded, outFontCount, outTypes, outOffsets, outSizes, languageCode));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISharedFontManager
    {
    public:
        nn::Result RequestLoad(std::int32_t sharedFontType) NN_NOEXCEPT;
        nn::Result GetLoadState(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> loadState) NN_NOEXCEPT;
        nn::Result GetSize(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> size) NN_NOEXCEPT;
        nn::Result GetSharedMemoryAddressOffset(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> offset) NN_NOEXCEPT;
        nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result GetSharedFontInOrderOfPriority(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT;
        nn::Result GetSharedFontInOrderOfPriorityForSystem(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result RequestLoad(std::int32_t sharedFontType) NN_NOEXCEPT;
    nn::Result GetLoadState(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> loadState) NN_NOEXCEPT;
    nn::Result GetSize(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> size) NN_NOEXCEPT;
    nn::Result GetSharedMemoryAddressOffset(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> offset) NN_NOEXCEPT;
    nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result GetSharedFontInOrderOfPriority(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT;
    nn::Result GetSharedFontInOrderOfPriorityForSystem(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::pl::detail::ISharedFontManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLoad, (::std::int32_t sharedFontType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLoad, (sharedFontType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLoadState, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> loadState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLoadState, (sharedFontType, loadState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSize, (sharedFontType, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryAddressOffset, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedMemoryAddressOffset, (sharedFontType, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFontInOrderOfPriority, (::nn::sf::Out<bool> outAllFontLoaded, ::nn::sf::Out<::std::int32_t> outFontCount, const ::nn::sf::OutArray<::std::int32_t>& outTypes, const ::nn::sf::OutArray<::std::int32_t>& outOffsets, const ::nn::sf::OutArray<::std::int32_t>& outSizes, ::nn::settings::LanguageCode languageCode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedFontInOrderOfPriority, (outAllFontLoaded, outFontCount, outTypes, outOffsets, outSizes, languageCode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFontInOrderOfPriorityForSystem, (::nn::sf::Out<bool> outAllFontLoaded, ::nn::sf::Out<::std::int32_t> outFontCount, const ::nn::sf::OutArray<::std::int32_t>& outTypes, const ::nn::sf::OutArray<::std::int32_t>& outOffsets, const ::nn::sf::OutArray<::std::int32_t>& outSizes, ::nn::settings::LanguageCode languageCode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedFontInOrderOfPriorityForSystem, (outAllFontLoaded, outFontCount, outTypes, outOffsets, outSizes, languageCode));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::pl::detail::ISharedFontManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::pl::detail::ISharedFontManager))

    // nn::Result RequestLoad(std::int32_t sharedFontType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLoad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sharedFontType, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sharedFontType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sharedFontType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLoad)

    // nn::Result GetLoadState(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> loadState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLoadState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sharedFontType, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sharedFontType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(loadState, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (loadState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sharedFontType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(loadState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLoadState)

    // nn::Result GetSize(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sharedFontType, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sharedFontType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(size, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sharedFontType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSize)

    // nn::Result GetSharedMemoryAddressOffset(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedMemoryAddressOffset)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sharedFontType, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sharedFontType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sharedFontType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedMemoryAddressOffset)

    // nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedMemoryNativeHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedMemoryNativeHandle)

    // nn::Result GetSharedFontInOrderOfPriority(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedFontInOrderOfPriority)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outTypes, 0, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outOffsets, 1, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSizes, 2, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (outTypes, outOffsets, outSizes))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(languageCode, (::nn::settings::LanguageCode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (languageCode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAllFontLoaded, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFontCount, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outAllFontLoaded, outFontCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAllFontLoaded), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFontCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTypes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outOffsets), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSizes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(languageCode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedFontInOrderOfPriority)

    // nn::Result GetSharedFontInOrderOfPriorityForSystem(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedFontInOrderOfPriorityForSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outTypes, 0, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outOffsets, 1, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSizes, 2, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (outTypes, outOffsets, outSizes))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(languageCode, (::nn::settings::LanguageCode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (languageCode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAllFontLoaded, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFontCount, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outAllFontLoaded, outFontCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAllFontLoaded), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFontCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTypes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outOffsets), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSizes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(languageCode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedFontInOrderOfPriorityForSystem)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::settings::LanguageCode), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::pl::detail::ISharedFontManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::pl::detail::ISharedFontManager))

    // nn::Result RequestLoad(std::int32_t sharedFontType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLoad, (::std::int32_t sharedFontType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLoad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sharedFontType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLoad)
    }

    // nn::Result GetLoadState(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> loadState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLoadState, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> loadState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLoadState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sharedFontType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(loadState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLoadState)
    }

    // nn::Result GetSize(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sharedFontType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSize)
    }

    // nn::Result GetSharedMemoryAddressOffset(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryAddressOffset, (::std::int32_t sharedFontType, ::nn::sf::Out<::std::int32_t> offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedMemoryAddressOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sharedFontType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedMemoryAddressOffset)
    }

    // nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedMemoryNativeHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedMemoryNativeHandle)
    }

    // nn::Result GetSharedFontInOrderOfPriority(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFontInOrderOfPriority, (::nn::sf::Out<bool> outAllFontLoaded, ::nn::sf::Out<::std::int32_t> outFontCount, const ::nn::sf::OutArray<::std::int32_t>& outTypes, const ::nn::sf::OutArray<::std::int32_t>& outOffsets, const ::nn::sf::OutArray<::std::int32_t>& outSizes, ::nn::settings::LanguageCode languageCode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedFontInOrderOfPriority)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAllFontLoaded)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFontCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTypes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outOffsets)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSizes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(languageCode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedFontInOrderOfPriority)
    }

    // nn::Result GetSharedFontInOrderOfPriorityForSystem(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedFontInOrderOfPriorityForSystem, (::nn::sf::Out<bool> outAllFontLoaded, ::nn::sf::Out<::std::int32_t> outFontCount, const ::nn::sf::OutArray<::std::int32_t>& outTypes, const ::nn::sf::OutArray<::std::int32_t>& outOffsets, const ::nn::sf::OutArray<::std::int32_t>& outSizes, ::nn::settings::LanguageCode languageCode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedFontInOrderOfPriorityForSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAllFontLoaded)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFontCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTypes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outOffsets)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSizes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(languageCode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedFontInOrderOfPriorityForSystem)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::pl::detail::ISharedFontManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::pl::detail::ISharedFontManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLoad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < nn::pl::SharedFontType_Max), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sharedFontType)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLoad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sharedFontType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLoadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < nn::pl::SharedFontType_Max), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sharedFontType)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLoadState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sharedFontType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(loadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < nn::pl::SharedFontType_Max), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sharedFontType)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sharedFontType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedMemoryAddressOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < nn::pl::SharedFontType_Max), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sharedFontType)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedMemoryAddressOffset)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sharedFontType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedMemoryNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedMemoryNativeHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedFontInOrderOfPriority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outTypes)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outOffsets)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSizes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedFontInOrderOfPriority)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAllFontLoaded),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFontCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outTypes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outOffsets),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSizes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(languageCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedFontInOrderOfPriorityForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outTypes)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outOffsets)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSizes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedFontInOrderOfPriorityForSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAllFontLoaded),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFontCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outTypes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outOffsets),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSizes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(languageCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLoad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLoadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedMemoryAddressOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedMemoryNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedFontInOrderOfPriority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedFontInOrderOfPriorityForSystem)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::pl::detail::ISharedFontManager))
