﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      perflog モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PERFLOG_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERFLOG_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERFLOG_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERFLOG_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERFLOG_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERFLOG_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perflog, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERFLOG_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Trace, 0, format, args)
#define NN_DETAIL_PERFLOG_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Trace, 1, format, args)
#define NN_DETAIL_PERFLOG_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Trace, 2, format, args)
#define NN_DETAIL_PERFLOG_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Trace, 3, format, args)

#define NN_DETAIL_PERFLOG_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Info, 0, format, args)
#define NN_DETAIL_PERFLOG_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Info, 1, format, args)
#define NN_DETAIL_PERFLOG_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Info, 2, format, args)
#define NN_DETAIL_PERFLOG_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Info, 3, format, args)

#define NN_DETAIL_PERFLOG_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Warn, 0, format, args)
#define NN_DETAIL_PERFLOG_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Warn, 1, format, args)
#define NN_DETAIL_PERFLOG_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Warn, 2, format, args)
#define NN_DETAIL_PERFLOG_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Warn, 3, format, args)

#define NN_DETAIL_PERFLOG_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Error, 0, format, args)
#define NN_DETAIL_PERFLOG_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Error, 1, format, args)
#define NN_DETAIL_PERFLOG_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Error, 2, format, args)
#define NN_DETAIL_PERFLOG_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Error, 3, format, args)

#define NN_DETAIL_PERFLOG_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Fatal, 0, format, args)
#define NN_DETAIL_PERFLOG_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Fatal, 1, format, args)
#define NN_DETAIL_PERFLOG_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Fatal, 2, format, args)
#define NN_DETAIL_PERFLOG_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perflog, Fatal, 3, format, args)

#define NN_DETAIL_PERFLOG_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Trace, 0, text, length)
#define NN_DETAIL_PERFLOG_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Trace, 1, text, length)
#define NN_DETAIL_PERFLOG_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Trace, 2, text, length)
#define NN_DETAIL_PERFLOG_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Trace, 3, text, length)

#define NN_DETAIL_PERFLOG_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Info, 0, text, length)
#define NN_DETAIL_PERFLOG_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Info, 1, text, length)
#define NN_DETAIL_PERFLOG_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Info, 2, text, length)
#define NN_DETAIL_PERFLOG_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Info, 3, text, length)

#define NN_DETAIL_PERFLOG_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Warn, 0, text, length)
#define NN_DETAIL_PERFLOG_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Warn, 1, text, length)
#define NN_DETAIL_PERFLOG_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Warn, 2, text, length)
#define NN_DETAIL_PERFLOG_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Warn, 3, text, length)

#define NN_DETAIL_PERFLOG_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Error, 0, text, length)
#define NN_DETAIL_PERFLOG_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Error, 1, text, length)
#define NN_DETAIL_PERFLOG_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Error, 2, text, length)
#define NN_DETAIL_PERFLOG_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Error, 3, text, length)

#define NN_DETAIL_PERFLOG_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Fatal, 0, text, length)
#define NN_DETAIL_PERFLOG_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Fatal, 1, text, length)
#define NN_DETAIL_PERFLOG_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Fatal, 2, text, length)
#define NN_DETAIL_PERFLOG_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perflog, Fatal, 3, text, length)
