﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_Types.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/nn_ApplicationId.h>
#include <nn/nn_Result.h>
#include <nn/pdm/pdm_PrivateTypes.h>
#include <nn/pdm/pdm_QueryLastPlayTimeApi.h>
#include <nn/pdm/pdm_SystemTypes.h>
#include <nn/pdm/pdm_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace pdm { namespace detail { // NOLINT(whitespace/braces)

class IQueryService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IQueryService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IQueryService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryApplicationEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::ApplicationEvent>& outList, ::std::int32_t eventIndexOffset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatistics, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByUserAccountId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList, const ::nn::account::Uid& user))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByNetworkServiceAccountId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList, ::nn::account::NetworkServiceAccountId networkServiceAccountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndUserAccountId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId, const ::nn::account::Uid& user))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId, ::nn::account::NetworkServiceAccountId networkServiceAccountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryLastPlayTime, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::LastPlayTime>& outList, const ::nn::sf::InArray<::nn::ApplicationId>& applicationIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayEvent>& outList, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailablePlayEventRange, (::nn::sf::Out<::std::int32_t> outCount, ::nn::sf::Out<::std::int32_t> startIndex, ::nn::sf::Out<::std::int32_t> lastIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryAccountEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::AccountEvent>& outList, ::std::int32_t eventIndexOffset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryAccountPlayEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::AccountPlayEvent>& outList, ::std::int32_t offset, const ::nn::account::Uid& user))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailableAccountPlayEventRange, (::nn::sf::Out<::std::int32_t> outCount, ::nn::sf::Out<::std::int32_t> startIndex, ::nn::sf::Out<::std::int32_t> lastIndex, const ::nn::account::Uid& user))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryApplicationPlayStatisticsForSystem, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::ApplicationPlayStatistics>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& applicationIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryRecentlyPlayedApplication, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationId>& outList, const ::nn::account::Uid& user))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRecentlyPlayedApplicationUpdateEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IQueryService)

        ::nn::Result QueryApplicationEvent(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::ApplicationEvent>& outList, ::std::int32_t eventIndexOffset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryApplicationEvent, (outCount, outList, eventIndexOffset));
        }

        ::nn::Result QueryPlayStatistics(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryPlayStatistics, (outCount, outList));
        }

        ::nn::Result QueryPlayStatisticsByUserAccountId(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList, const ::nn::account::Uid& user) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByUserAccountId, (outCount, outList, user));
        }

        ::nn::Result QueryPlayStatisticsByNetworkServiceAccountId(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList, ::nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByNetworkServiceAccountId, (outCount, outList, networkServiceAccountId));
        }

        ::nn::Result QueryPlayStatisticsByApplicationId(::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationId, (outValue, applicationId));
        }

        ::nn::Result QueryPlayStatisticsByApplicationIdAndUserAccountId(::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId, const ::nn::account::Uid& user) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndUserAccountId, (outValue, applicationId, user));
        }

        ::nn::Result QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId(::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId, ::nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId, (outValue, applicationId, networkServiceAccountId));
        }

        ::nn::Result QueryLastPlayTime(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::LastPlayTime>& outList, const ::nn::sf::InArray<::nn::ApplicationId>& applicationIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryLastPlayTime, (outCount, outList, applicationIdList));
        }

        ::nn::Result QueryPlayEvent(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayEvent>& outList, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryPlayEvent, (outCount, outList, offset));
        }

        ::nn::Result GetAvailablePlayEventRange(::nn::sf::Out<::std::int32_t> outCount, ::nn::sf::Out<::std::int32_t> startIndex, ::nn::sf::Out<::std::int32_t> lastIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAvailablePlayEventRange, (outCount, startIndex, lastIndex));
        }

        ::nn::Result QueryAccountEvent(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::AccountEvent>& outList, ::std::int32_t eventIndexOffset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryAccountEvent, (outCount, outList, eventIndexOffset));
        }

        ::nn::Result QueryAccountPlayEvent(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::AccountPlayEvent>& outList, ::std::int32_t offset, const ::nn::account::Uid& user) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryAccountPlayEvent, (outCount, outList, offset, user));
        }

        ::nn::Result GetAvailableAccountPlayEventRange(::nn::sf::Out<::std::int32_t> outCount, ::nn::sf::Out<::std::int32_t> startIndex, ::nn::sf::Out<::std::int32_t> lastIndex, const ::nn::account::Uid& user) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAvailableAccountPlayEventRange, (outCount, startIndex, lastIndex, user));
        }

        ::nn::Result QueryApplicationPlayStatisticsForSystem(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::ApplicationPlayStatistics>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& applicationIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryApplicationPlayStatisticsForSystem, (outCount, outList, applicationIdList));
        }

        ::nn::Result QueryRecentlyPlayedApplication(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationId>& outList, const ::nn::account::Uid& user) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryRecentlyPlayedApplication, (outCount, outList, user));
        }

        ::nn::Result GetRecentlyPlayedApplicationUpdateEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRecentlyPlayedApplicationUpdateEvent, (pOutHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IQueryService
    {
    public:
        nn::Result QueryApplicationEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT;
        nn::Result QueryPlayStatistics(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList) NN_NOEXCEPT;
        nn::Result QueryPlayStatisticsByUserAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, const nn::account::Uid& user) NN_NOEXCEPT;
        nn::Result QueryPlayStatisticsByNetworkServiceAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT;
        nn::Result QueryPlayStatisticsByApplicationId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result QueryPlayStatisticsByApplicationIdAndUserAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, const nn::account::Uid& user) NN_NOEXCEPT;
        nn::Result QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT;
        nn::Result QueryLastPlayTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::LastPlayTime>& outList, const nn::sf::InArray<nn::ApplicationId>& applicationIdList) NN_NOEXCEPT;
        nn::Result QueryPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayEvent>& outList, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GetAvailablePlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex) NN_NOEXCEPT;
        nn::Result QueryAccountEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT;
        nn::Result QueryAccountPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountPlayEvent>& outList, std::int32_t offset, const nn::account::Uid& user) NN_NOEXCEPT;
        nn::Result GetAvailableAccountPlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex, const nn::account::Uid& user) NN_NOEXCEPT;
        nn::Result QueryApplicationPlayStatisticsForSystem(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationPlayStatistics>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& applicationIdList) NN_NOEXCEPT;
        nn::Result QueryRecentlyPlayedApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList, const nn::account::Uid& user) NN_NOEXCEPT;
        nn::Result GetRecentlyPlayedApplicationUpdateEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result QueryApplicationEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT;
    nn::Result QueryPlayStatistics(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByUserAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByNetworkServiceAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByApplicationId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByApplicationIdAndUserAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT;
    nn::Result QueryLastPlayTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::LastPlayTime>& outList, const nn::sf::InArray<nn::ApplicationId>& applicationIdList) NN_NOEXCEPT;
    nn::Result QueryPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayEvent>& outList, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetAvailablePlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex) NN_NOEXCEPT;
    nn::Result QueryAccountEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT;
    nn::Result QueryAccountPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountPlayEvent>& outList, std::int32_t offset, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result GetAvailableAccountPlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result QueryApplicationPlayStatisticsForSystem(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationPlayStatistics>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& applicationIdList) NN_NOEXCEPT;
    nn::Result QueryRecentlyPlayedApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList, const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result GetRecentlyPlayedApplicationUpdateEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::pdm::detail::IQueryService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryApplicationEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::ApplicationEvent>& outList, ::std::int32_t eventIndexOffset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryApplicationEvent, (outCount, outList, eventIndexOffset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatistics, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryPlayStatistics, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByUserAccountId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList, const ::nn::account::Uid& user))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryPlayStatisticsByUserAccountId, (outCount, outList, user));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByNetworkServiceAccountId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList, ::nn::account::NetworkServiceAccountId networkServiceAccountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryPlayStatisticsByNetworkServiceAccountId, (outCount, outList, networkServiceAccountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryPlayStatisticsByApplicationId, (outValue, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndUserAccountId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId, const ::nn::account::Uid& user))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndUserAccountId, (outValue, applicationId, user));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId, ::nn::account::NetworkServiceAccountId networkServiceAccountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId, (outValue, applicationId, networkServiceAccountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryLastPlayTime, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::LastPlayTime>& outList, const ::nn::sf::InArray<::nn::ApplicationId>& applicationIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryLastPlayTime, (outCount, outList, applicationIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayEvent>& outList, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryPlayEvent, (outCount, outList, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailablePlayEventRange, (::nn::sf::Out<::std::int32_t> outCount, ::nn::sf::Out<::std::int32_t> startIndex, ::nn::sf::Out<::std::int32_t> lastIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAvailablePlayEventRange, (outCount, startIndex, lastIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAccountEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::AccountEvent>& outList, ::std::int32_t eventIndexOffset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryAccountEvent, (outCount, outList, eventIndexOffset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAccountPlayEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::AccountPlayEvent>& outList, ::std::int32_t offset, const ::nn::account::Uid& user))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryAccountPlayEvent, (outCount, outList, offset, user));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailableAccountPlayEventRange, (::nn::sf::Out<::std::int32_t> outCount, ::nn::sf::Out<::std::int32_t> startIndex, ::nn::sf::Out<::std::int32_t> lastIndex, const ::nn::account::Uid& user))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAvailableAccountPlayEventRange, (outCount, startIndex, lastIndex, user));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryApplicationPlayStatisticsForSystem, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::ApplicationPlayStatistics>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& applicationIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryApplicationPlayStatisticsForSystem, (outCount, outList, applicationIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryRecentlyPlayedApplication, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationId>& outList, const ::nn::account::Uid& user))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryRecentlyPlayedApplication, (outCount, outList, user));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRecentlyPlayedApplicationUpdateEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRecentlyPlayedApplicationUpdateEvent, (pOutHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::pdm::detail::IQueryService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::pdm::detail::IQueryService))

    // nn::Result QueryApplicationEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryApplicationEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::ApplicationEvent>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventIndexOffset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (eventIndexOffset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventIndexOffset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryApplicationEvent)

    // nn::Result QueryPlayStatistics(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryPlayStatistics)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryPlayStatistics)

    // nn::Result QueryPlayStatisticsByUserAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryPlayStatisticsByUserAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (user))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryPlayStatisticsByUserAccountId)

    // nn::Result QueryPlayStatisticsByNetworkServiceAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryPlayStatisticsByNetworkServiceAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(networkServiceAccountId, (::nn::account::NetworkServiceAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (networkServiceAccountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(networkServiceAccountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryPlayStatisticsByNetworkServiceAccountId)

    // nn::Result QueryPlayStatisticsByApplicationId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryPlayStatisticsByApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::pdm::PlayStatistics), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryPlayStatisticsByApplicationId)

    // nn::Result QueryPlayStatisticsByApplicationIdAndUserAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryPlayStatisticsByApplicationIdAndUserAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (applicationId, user))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::pdm::PlayStatistics), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryPlayStatisticsByApplicationIdAndUserAccountId)

    // nn::Result QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(networkServiceAccountId, (::nn::account::NetworkServiceAccountId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (applicationId, networkServiceAccountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::pdm::PlayStatistics), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(networkServiceAccountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId)

    // nn::Result QueryLastPlayTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::LastPlayTime>& outList, const nn::sf::InArray<nn::ApplicationId>& applicationIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryLastPlayTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::LastPlayTime>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(applicationIdList, 1, (const ::nn::sf::InArray<::nn::ApplicationId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outList, applicationIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryLastPlayTime)

    // nn::Result QueryPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayEvent>& outList, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryPlayEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::PlayEvent>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryPlayEvent)

    // nn::Result GetAvailablePlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAvailablePlayEventRange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(startIndex, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(lastIndex, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outCount, startIndex, lastIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(startIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(lastIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAvailablePlayEventRange)

    // nn::Result QueryAccountEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryAccountEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::AccountEvent>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventIndexOffset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (eventIndexOffset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventIndexOffset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryAccountEvent)

    // nn::Result QueryAccountPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountPlayEvent>& outList, std::int32_t offset, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryAccountPlayEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::AccountPlayEvent>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, user))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryAccountPlayEvent)

    // nn::Result GetAvailableAccountPlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAvailableAccountPlayEventRange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (user))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(startIndex, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(lastIndex, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outCount, startIndex, lastIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(startIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(lastIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAvailableAccountPlayEventRange)

    // nn::Result QueryApplicationPlayStatisticsForSystem(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationPlayStatistics>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& applicationIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryApplicationPlayStatisticsForSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::pdm::ApplicationPlayStatistics>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(applicationIdList, 1, (const ::nn::sf::InArray<::nn::ncm::ApplicationId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outList, applicationIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryApplicationPlayStatisticsForSystem)

    // nn::Result QueryRecentlyPlayedApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryRecentlyPlayedApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::ApplicationId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (user))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryRecentlyPlayedApplication)

    // nn::Result GetRecentlyPlayedApplicationUpdateEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRecentlyPlayedApplicationUpdateEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRecentlyPlayedApplicationUpdateEvent)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::ApplicationEvent), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::PlayStatistics), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::LastPlayTime), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::PlayEvent), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::AccountEvent), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::AccountPlayEvent), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::ApplicationPlayStatistics), 24, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::pdm::detail::IQueryService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::pdm::detail::IQueryService))

    // nn::Result QueryApplicationEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryApplicationEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::ApplicationEvent>& outList, ::std::int32_t eventIndexOffset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryApplicationEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventIndexOffset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryApplicationEvent)
    }

    // nn::Result QueryPlayStatistics(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatistics, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryPlayStatistics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryPlayStatistics)
    }

    // nn::Result QueryPlayStatisticsByUserAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByUserAccountId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList, const ::nn::account::Uid& user))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryPlayStatisticsByUserAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryPlayStatisticsByUserAccountId)
    }

    // nn::Result QueryPlayStatisticsByNetworkServiceAccountId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayStatistics>& outList, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByNetworkServiceAccountId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayStatistics>& outList, ::nn::account::NetworkServiceAccountId networkServiceAccountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryPlayStatisticsByNetworkServiceAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(networkServiceAccountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryPlayStatisticsByNetworkServiceAccountId)
    }

    // nn::Result QueryPlayStatisticsByApplicationId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryPlayStatisticsByApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryPlayStatisticsByApplicationId)
    }

    // nn::Result QueryPlayStatisticsByApplicationIdAndUserAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndUserAccountId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId, const ::nn::account::Uid& user))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryPlayStatisticsByApplicationIdAndUserAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryPlayStatisticsByApplicationIdAndUserAccountId)
    }

    // nn::Result QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId(nn::sf::Out<nn::pdm::PlayStatistics> outValue, nn::ncm::ApplicationId applicationId, nn::account::NetworkServiceAccountId networkServiceAccountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId, (::nn::sf::Out<::nn::pdm::PlayStatistics> outValue, ::nn::ncm::ApplicationId applicationId, ::nn::account::NetworkServiceAccountId networkServiceAccountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(networkServiceAccountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId)
    }

    // nn::Result QueryLastPlayTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::LastPlayTime>& outList, const nn::sf::InArray<nn::ApplicationId>& applicationIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryLastPlayTime, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::LastPlayTime>& outList, const ::nn::sf::InArray<::nn::ApplicationId>& applicationIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryLastPlayTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryLastPlayTime)
    }

    // nn::Result QueryPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::PlayEvent>& outList, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryPlayEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::PlayEvent>& outList, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryPlayEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryPlayEvent)
    }

    // nn::Result GetAvailablePlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailablePlayEventRange, (::nn::sf::Out<::std::int32_t> outCount, ::nn::sf::Out<::std::int32_t> startIndex, ::nn::sf::Out<::std::int32_t> lastIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAvailablePlayEventRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(startIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(lastIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAvailablePlayEventRange)
    }

    // nn::Result QueryAccountEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountEvent>& outList, std::int32_t eventIndexOffset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAccountEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::AccountEvent>& outList, ::std::int32_t eventIndexOffset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryAccountEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventIndexOffset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryAccountEvent)
    }

    // nn::Result QueryAccountPlayEvent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::AccountPlayEvent>& outList, std::int32_t offset, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAccountPlayEvent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::AccountPlayEvent>& outList, ::std::int32_t offset, const ::nn::account::Uid& user))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryAccountPlayEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryAccountPlayEvent)
    }

    // nn::Result GetAvailableAccountPlayEventRange(nn::sf::Out<std::int32_t> outCount, nn::sf::Out<std::int32_t> startIndex, nn::sf::Out<std::int32_t> lastIndex, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailableAccountPlayEventRange, (::nn::sf::Out<::std::int32_t> outCount, ::nn::sf::Out<::std::int32_t> startIndex, ::nn::sf::Out<::std::int32_t> lastIndex, const ::nn::account::Uid& user))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAvailableAccountPlayEventRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(startIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(lastIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAvailableAccountPlayEventRange)
    }

    // nn::Result QueryApplicationPlayStatisticsForSystem(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::pdm::ApplicationPlayStatistics>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& applicationIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryApplicationPlayStatisticsForSystem, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::pdm::ApplicationPlayStatistics>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& applicationIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryApplicationPlayStatisticsForSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryApplicationPlayStatisticsForSystem)
    }

    // nn::Result QueryRecentlyPlayedApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList, const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryRecentlyPlayedApplication, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationId>& outList, const ::nn::account::Uid& user))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryRecentlyPlayedApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryRecentlyPlayedApplication)
    }

    // nn::Result GetRecentlyPlayedApplicationUpdateEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRecentlyPlayedApplicationUpdateEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRecentlyPlayedApplicationUpdateEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRecentlyPlayedApplicationUpdateEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::pdm::detail::IQueryService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::pdm::detail::IQueryService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryApplicationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryApplicationEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventIndexOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryPlayStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryPlayStatistics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryPlayStatisticsByUserAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryPlayStatisticsByUserAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryPlayStatisticsByNetworkServiceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryPlayStatisticsByNetworkServiceAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(networkServiceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryPlayStatisticsByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryPlayStatisticsByApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryPlayStatisticsByApplicationIdAndUserAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryPlayStatisticsByApplicationIdAndUserAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(networkServiceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryLastPlayTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(applicationIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryLastPlayTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(applicationIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryPlayEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryPlayEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAvailablePlayEventRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAvailablePlayEventRange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(startIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(lastIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryAccountEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryAccountEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventIndexOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryAccountPlayEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryAccountPlayEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAvailableAccountPlayEventRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAvailableAccountPlayEventRange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(startIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(lastIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryApplicationPlayStatisticsForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(applicationIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryApplicationPlayStatisticsForSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(applicationIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryRecentlyPlayedApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryRecentlyPlayedApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRecentlyPlayedApplicationUpdateEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRecentlyPlayedApplicationUpdateEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryApplicationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryPlayStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryPlayStatisticsByUserAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryPlayStatisticsByNetworkServiceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryPlayStatisticsByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryPlayStatisticsByApplicationIdAndUserAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryLastPlayTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryPlayEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAvailablePlayEventRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryAccountEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryAccountPlayEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAvailableAccountPlayEventRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryApplicationPlayStatisticsForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryRecentlyPlayedApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRecentlyPlayedApplicationUpdateEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::pdm::detail::IQueryService))
